/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.model;

import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.SerializationException;
import com.bladecoder.engine.actions.Action;
import com.bladecoder.engine.actions.ActionCallback;
import com.bladecoder.engine.model.VerbRunner;
import com.bladecoder.engine.serialization.ActionCallbackSerializer;
import com.bladecoder.engine.serialization.BladeJson;
import com.bladecoder.engine.util.ActionUtils;
import com.bladecoder.engine.util.EngineLogger;
import java.util.ArrayList;

public class Verb
implements VerbRunner,
Json.Serializable {
    public static final String LOOKAT_VERB = "lookat";
    public static final String PICKUP_VERB = "pickup";
    public static final String ACTION_VERB = "action";
    public static final String LEAVE_VERB = "leave";
    public static final String TALKTO_VERB = "talkto";
    public static final String USE_VERB = "use";
    public static final String GOTO_VERB = "goto";
    public static final String TEST_VERB = "test";
    public static final String INIT_VERB = "init";
    public static final String INIT_NEW_GAME_VERB = "initNewGame";
    public static final String INIT_SAVED_GAME_VERB = "initSavedGame";
    private String id;
    private String state;
    private String target;
    private String icon;
    private final ArrayList<Action> actions = new ArrayList();
    private int ip = -1;
    private String currentTarget;
    private ActionCallback cb;

    public Verb() {
    }

    public Verb(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getHashKey() {
        String key = this.id;
        if (this.target != null) {
            key = key + "." + this.target;
        }
        if (this.state != null) {
            key = key + "." + this.state;
        }
        return key;
    }

    public void add(Action a) {
        this.actions.add(a);
    }

    @Override
    public ArrayList<Action> getActions() {
        return this.actions;
    }

    @Override
    public String getCurrentTarget() {
        return this.currentTarget;
    }

    @Override
    public void run(String currentTarget, ActionCallback cb) {
        this.currentTarget = currentTarget;
        this.cb = cb;
        if (EngineLogger.debugMode()) {
            StringBuilder sb = new StringBuilder(">>> Running verb: ").append(this.id);
            if (currentTarget != null) {
                sb.append(" currentTarget: " + currentTarget);
            }
            EngineLogger.debug(sb.toString());
        }
        this.ip = 0;
        this.nextStep();
    }

    public void nextStep() {
        boolean stop = false;
        while (!this.isFinished() && !stop) {
            Action a = this.actions.get(this.ip);
            if (EngineLogger.debugMode()) {
                EngineLogger.debug(this.ip + ". " + a.getClass().getSimpleName());
            }
            try {
                if (a.run(this)) {
                    stop = true;
                    continue;
                }
                ++this.ip;
            }
            catch (Exception e) {
                EngineLogger.error("EXCEPTION EXECUTING ACTION: " + a.getClass().getSimpleName() + " - " + e.getMessage(), e);
                ++this.ip;
            }
        }
        if (this.ip == this.actions.size()) {
            EngineLogger.debug(">>> Verb FINISHED: " + this.id);
            if (this.cb != null) {
                ActionCallback cb2 = this.cb;
                this.cb = null;
                cb2.resume();
            }
        }
    }

    public boolean isFinished() {
        return this.ip >= this.actions.size() || this.ip < 0;
    }

    @Override
    public void resume() {
        ++this.ip;
        this.nextStep();
    }

    @Override
    public int getIP() {
        return this.ip;
    }

    @Override
    public void setIP(int ip) {
        this.ip = ip;
    }

    @Override
    public void cancel() {
        this.ip = this.actions.size() + 1;
        for (Action c : this.actions) {
            if (!(c instanceof VerbRunner)) continue;
            ((VerbRunner)((Object)c)).cancel();
        }
        if (this.cb != null) {
            ActionCallback cb2 = this.cb;
            this.cb = null;
            cb2.resume();
        }
        EngineLogger.debug(">>> Verb CANCELLED: " + this.id);
    }

    public void write(Json json) {
        BladeJson bjson = (BladeJson)json;
        if (bjson.getMode() == BladeJson.Mode.MODEL) {
            json.writeValue("id", (Object)this.id);
            if (this.target != null) {
                json.writeValue("target", (Object)this.target);
            }
            if (this.state != null) {
                json.writeValue("state", (Object)this.state);
            }
            if (this.icon != null) {
                json.writeValue("icon", (Object)this.icon);
            }
            json.writeArrayStart("actions");
            for (Action a : this.actions) {
                ActionUtils.writeJson(a, json);
            }
            json.writeArrayEnd();
        } else {
            json.writeValue("ip", (Object)this.ip);
            if (this.cb != null) {
                json.writeValue("cb", (Object)ActionCallbackSerializer.find(bjson.getWorld(), bjson.getScene(), this.cb));
            }
            if (this.currentTarget != null) {
                json.writeValue("currentTarget", (Object)this.currentTarget);
            }
            json.writeArrayStart("actions");
            for (Action a : this.actions) {
                if (!(a instanceof Json.Serializable)) continue;
                json.writeObjectStart();
                ((Json.Serializable)a).write(json);
                json.writeObjectEnd();
            }
            json.writeArrayEnd();
        }
    }

    public void read(Json json, JsonValue jsonData) {
        BladeJson bjson = (BladeJson)json;
        if (bjson.getMode() == BladeJson.Mode.MODEL) {
            this.id = (String)json.readValue("id", String.class, jsonData);
            this.target = (String)json.readValue("target", String.class, (Object)null, jsonData);
            this.state = (String)json.readValue("state", String.class, (Object)null, jsonData);
            this.icon = (String)json.readValue("icon", String.class, (Object)null, jsonData);
            this.actions.clear();
            JsonValue actionsValue = jsonData.get("actions");
            for (int i = 0; i < actionsValue.size; ++i) {
                JsonValue aValue = actionsValue.get(i);
                String clazz = aValue.getString("class");
                try {
                    Action a = ActionUtils.readJson(bjson.getWorld(), json, aValue);
                    this.actions.add(a);
                    continue;
                }
                catch (SerializationException e) {
                    EngineLogger.error("Error loading action: " + clazz + " " + aValue.toString());
                    throw e;
                }
            }
        } else {
            this.currentTarget = (String)json.readValue("currentTarget", String.class, (Object)null, jsonData);
            this.ip = (Integer)json.readValue("ip", Integer.class, jsonData);
            this.cb = ActionCallbackSerializer.find(bjson.getWorld(), bjson.getScene(), (String)json.readValue("cb", String.class, jsonData));
            JsonValue actionsValue = jsonData.get("actions");
            int i = 0;
            for (Action a : this.actions) {
                if (!(a instanceof Json.Serializable) || i >= actionsValue.size) continue;
                if (actionsValue.get(i) != null) {
                    ((Json.Serializable)a).read(json, actionsValue.get(i));
                    ++i;
                    continue;
                }
                break;
            }
        }
    }
}

