/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.model;

import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.Timer;
import com.bladecoder.engine.assets.AssetConsumer;
import com.bladecoder.engine.assets.EngineAssetManager;
import com.bladecoder.engine.model.TextManager;
import com.bladecoder.engine.util.EngineLogger;

public class VoiceManager
implements Json.Serializable,
AssetConsumer {
    private transient Music voice = null;
    String fileName = null;
    private boolean isPlayingSer = false;
    private float voicePosSer = 0.0f;
    private float volume = 1.0f;
    public static float VOLUME_MULTIPLIER = 1.0f;
    private transient boolean isPaused = false;
    private transient TextManager textManager = null;
    private final Timer.Task backgroundLoadingTask = new Timer.Task(){

        public void run() {
            try {
                if (!EngineAssetManager.getInstance().isLoading()) {
                    this.cancel();
                    VoiceManager.this.retrieveAssets();
                    if (VoiceManager.this.voice != null) {
                        VoiceManager.this.voice.play();
                    }
                }
            }
            catch (GdxRuntimeException e) {
                EngineLogger.error(e.getMessage());
                VoiceManager.this.voice = null;
                VoiceManager.this.fileName = null;
                VoiceManager.this.textManager.next();
            }
        }
    };

    public VoiceManager(TextManager textManager) {
        this.textManager = textManager;
    }

    public void pause() {
        if (this.voice != null && this.voice.isPlaying()) {
            this.voice.pause();
            this.isPaused = true;
        }
    }

    public void resume() {
        if (this.voice != null && this.isPaused) {
            this.voice.play();
            this.isPaused = false;
        }
    }

    public void stop() {
        if (this.voice != null) {
            this.voice.stop();
            this.dispose();
        }
    }

    public void play(String fileName) {
        this.stop();
        this.fileName = fileName;
        if (fileName != null) {
            this.loadAssets();
            this.backgroundLoadingTask.cancel();
            Timer.schedule((Timer.Task)this.backgroundLoadingTask, (float)0.0f, (float)0.0f);
        }
    }

    public void setVolume(float volume) {
        this.volume = volume;
        if (this.voice != null) {
            this.voice.setVolume(volume * VOLUME_MULTIPLIER);
        }
    }

    public void dispose() {
        if (this.voice != null) {
            if (this.voice.isPlaying()) {
                this.voice.stop();
            }
            EngineLogger.debug("DISPOSING VOICE: " + this.fileName);
            EngineAssetManager.getInstance().unload("voices/" + this.fileName);
            this.voice = null;
            this.fileName = null;
            this.isPlayingSer = false;
            this.voicePosSer = 0.0f;
        }
    }

    @Override
    public void loadAssets() {
        if (this.voice == null && this.fileName != null) {
            EngineLogger.debug("LOADING VOICE: " + this.fileName);
            EngineAssetManager.getInstance().load("voices/" + this.fileName, Music.class);
        }
    }

    @Override
    public void retrieveAssets() {
        if (this.voice == null && this.fileName != null) {
            EngineLogger.debug("RETRIEVING VOICE: " + this.fileName);
            this.voice = (Music)EngineAssetManager.getInstance().get("voices/" + this.fileName, Music.class);
            this.voice.setOnCompletionListener(new Music.OnCompletionListener(){

                public void onCompletion(Music music) {
                    if (VoiceManager.this.textManager.getCurrentText() != null) {
                        VoiceManager.this.textManager.getCurrentText().setAutoTime();
                    }
                }
            });
            if (this.voice != null) {
                this.voice.setVolume(this.volume * VOLUME_MULTIPLIER);
            }
            if (this.isPlayingSer) {
                this.voice.play();
                if (this.voice != null) {
                    this.voice.setPosition(this.voicePosSer);
                }
                this.isPlayingSer = false;
                this.voicePosSer = 0.0f;
            }
        }
    }

    public void write(Json json) {
        json.writeValue("fileName", (Object)this.fileName);
        json.writeValue("isPlaying", (Object)(this.voice != null && (this.voice.isPlaying() || this.isPaused) ? 1 : 0));
        json.writeValue("musicPos", (Object)Float.valueOf(this.voice != null && (this.voice.isPlaying() || this.isPaused) ? this.voice.getPosition() : 0.0f));
    }

    public void read(Json json, JsonValue jsonData) {
        this.fileName = (String)json.readValue("fileName", String.class, jsonData);
        this.isPlayingSer = (Boolean)json.readValue("isPlaying", Boolean.TYPE, (Object)false, jsonData);
        this.voicePosSer = ((Float)json.readValue("musicPos", Float.TYPE, (Object)Float.valueOf(0.0f), jsonData)).floatValue();
    }
}

