/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.ui;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.utils.BaseDrawable;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.TransformDrawable;

public class AnimationDrawable
extends BaseDrawable
implements TransformDrawable {
    public final Animation<TextureAtlas.AtlasRegion> anim;
    private float stateTime = 0.0f;
    private Color tint;

    public AnimationDrawable(Animation<TextureAtlas.AtlasRegion> anim) {
        this.anim = anim;
        this.setMinWidth(((TextureAtlas.AtlasRegion[])anim.getKeyFrames())[0].getRegionWidth());
        this.setMinHeight(((TextureAtlas.AtlasRegion[])anim.getKeyFrames())[0].getRegionHeight());
    }

    public AnimationDrawable(AnimationDrawable ad) {
        super((Drawable)ad);
        this.anim = new Animation(ad.getAnimation().getFrameDuration(), ad.getAnimation().getKeyFrames());
        this.anim.setPlayMode(Animation.PlayMode.LOOP);
    }

    public void act(float delta) {
        this.stateTime += delta;
    }

    public void reset() {
        this.stateTime = 0.0f;
    }

    public void draw(Batch batch, float x, float y, float width, float height) {
        if (this.tint != null) {
            batch.setColor(this.tint);
        }
        batch.draw((TextureRegion)this.anim.getKeyFrame(this.stateTime), x, y, width, height);
        if (this.tint != null) {
            batch.setColor(Color.WHITE);
        }
    }

    public void draw(Batch batch, float x, float y, float originX, float originY, float width, float height, float scaleX, float scaleY, float rotation) {
        if (this.tint != null) {
            batch.setColor(this.tint);
        }
        batch.draw((TextureRegion)this.anim.getKeyFrame(this.stateTime), x, y, originX, originY, width, height, scaleX, scaleY, rotation);
        if (this.tint != null) {
            batch.setColor(Color.WHITE);
        }
    }

    public Animation<TextureAtlas.AtlasRegion> getAnimation() {
        return this.anim;
    }

    public Drawable tint(Color tint) {
        AnimationDrawable d = new AnimationDrawable(this);
        d.setTint(tint);
        return d;
    }

    public void setTint(Color t) {
        this.tint = t;
    }
}

