/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.ui;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.bladecoder.engine.model.ActorRenderer;
import com.bladecoder.engine.model.InteractiveActor;
import com.bladecoder.engine.model.Inventory;
import com.bladecoder.engine.model.SpriteActor;
import com.bladecoder.engine.model.Verb;
import com.bladecoder.engine.ui.PieMenu;
import com.bladecoder.engine.ui.SceneScreen;
import com.bladecoder.engine.ui.UI;
import com.bladecoder.engine.ui.defaults.ScenePointer;
import com.bladecoder.engine.util.Config;
import com.bladecoder.engine.util.DPIUtils;
import com.bladecoder.engine.util.EngineLogger;
import java.util.Locale;

public class InventoryUI
extends Group {
    private int tileSize;
    private int margin;
    private float rowSpace;
    private int cols;
    private int rows;
    private final InventoryPos inventoryPos;
    private boolean autosize = true;
    private SpriteActor draggedActor = null;
    private final SceneScreen sceneScreen;
    private InventoryUIStyle style;
    private Button menuButton;
    private final Vector2 orgPos = new Vector2();
    private final Vector2 targetPos = new Vector2();
    private final ScenePointer pointer;
    private boolean singleAction = Config.getInstance().getProperty("single_action_inventory", false);
    private final Vector3 mousepos = new Vector3();

    public InventoryUI(SceneScreen scr, ScenePointer pointer) {
        this.style = (InventoryUIStyle)scr.getUI().getSkin().get(InventoryUIStyle.class);
        this.sceneScreen = scr;
        this.pointer = pointer;
        this.inventoryPos = InventoryPos.valueOf(Config.getInstance().getProperty("inventory_pos", "DOWN").toUpperCase(Locale.ENGLISH));
        this.autosize = Config.getInstance().getProperty("inventory_autosize", true);
        this.addListener((EventListener)new InputListener(){

            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                if (InventoryUI.this.draggedActor != null) {
                    InventoryUI.this.stopDragging(button);
                } else {
                    SpriteActor actor = InventoryUI.this.getItemAt(x, y);
                    if (actor != null) {
                        if (InventoryUI.this.singleAction) {
                            InventoryUI.this.sceneScreen.runVerb(actor, "lookat", null);
                        } else {
                            InventoryUI.this.sceneScreen.actorClick(actor, button);
                        }
                    } else {
                        InventoryUI.this.hide();
                    }
                }
            }

            public boolean mouseMoved(InputEvent event, float x, float y) {
                return true;
            }

            public void touchDragged(InputEvent event, float x, float y, int pointer) {
                if (InventoryUI.this.draggedActor == null) {
                    InventoryUI.this.startDragging(x, y);
                }
            }

            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return true;
            }

            public void exit(InputEvent event, float x, float y, int pointer, Actor toActor) {
                if (!(toActor instanceof PieMenu) && !(toActor instanceof InventoryUI) && InventoryUI.this.draggedActor != null) {
                    InventoryUI.this.hide();
                }
            }
        });
        if (this.style.menuButtonStyle != null) {
            this.menuButton = new Button(this.style.menuButtonStyle);
            this.addActor((Actor)this.menuButton);
            this.menuButton.addListener((EventListener)new ChangeListener(){

                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    InventoryUI.this.sceneScreen.getUI().setCurrentScreen(UI.Screens.MENU_SCREEN);
                }
            });
            float iconSize = DPIUtils.getPrefButtonSize();
            this.menuButton.setSize(iconSize, iconSize);
        }
    }

    public void show() {
        if (!this.isVisible()) {
            this.resize((int)this.getStage().getCamera().viewportWidth, (int)this.getStage().getCamera().viewportHeight);
            this.setVisible(true);
            this.setPosition(this.orgPos.x, this.orgPos.y);
            this.addAction((Action)Actions.moveTo((float)this.targetPos.x, (float)this.targetPos.y, (float)0.1f));
        }
    }

    public void hide() {
        if (this.isVisible()) {
            this.addAction((Action)Actions.sequence((Action)Actions.moveTo((float)this.orgPos.x, (float)this.orgPos.y, (float)0.1f), (Action)Actions.hide()));
        }
    }

    public void resize(int width, int height) {
        Inventory inventory = this.sceneScreen.getWorld().getInventory();
        this.tileSize = (int)DPIUtils.getTouchMinSize() * 2;
        this.margin = (int)DPIUtils.getMarginSize();
        this.rowSpace = DPIUtils.getSpacing();
        int capacity = 0;
        do {
            int w = (int)((float)width * 0.7f / (float)this.tileSize) * this.tileSize;
            int h = (int)((float)height * 0.7f / (float)this.tileSize) * this.tileSize;
            if (this.autosize) {
                if (this.inventoryPos == InventoryPos.LEFT || this.inventoryPos == InventoryPos.RIGHT) {
                    int w2 = this.tileSize * ((inventory.getNumItems() - 1) / (h / this.tileSize) + 1);
                    if (w2 < w) {
                        w = w2;
                    }
                } else {
                    int h2 = this.tileSize * ((inventory.getNumItems() - 1) / (w / this.tileSize) + 1);
                    if (h2 < h) {
                        h = h2;
                    }
                }
            }
            this.cols = w / this.tileSize;
            this.rows = h / this.tileSize;
            this.setSize((float)w + (float)(this.cols - 1) * this.rowSpace + (float)(this.margin * 2), (float)h + (float)(this.rows - 1) * this.rowSpace + (float)(this.margin * 2));
            capacity = this.cols * this.rows;
            if (inventory.getNumItems() <= capacity) continue;
            this.tileSize = (int)((double)this.tileSize * 0.8);
        } while (inventory.getNumItems() > capacity);
        if (inventory.getNumItems() > capacity) {
            EngineLogger.error("Items in inventory excees the UI capacity");
        }
        this.setVisible(false);
        if (this.inventoryPos == InventoryPos.TOP) {
            this.orgPos.set(((float)width - this.getWidth()) / 2.0f, (float)height + this.getHeight());
            this.targetPos.set(((float)width - this.getWidth()) / 2.0f, (float)height - this.getHeight() - DPIUtils.getSpacing());
        } else if (this.inventoryPos == InventoryPos.DOWN) {
            this.orgPos.set(((float)width - this.getWidth()) / 2.0f, -this.getHeight());
            this.targetPos.set(((float)width - this.getWidth()) / 2.0f, DPIUtils.getSpacing());
        } else if (this.inventoryPos == InventoryPos.LEFT) {
            this.orgPos.set(-this.getWidth(), ((float)height - this.getHeight()) / 2.0f);
            this.targetPos.set(DPIUtils.getSpacing(), ((float)height - this.getHeight()) / 2.0f);
        } else if (this.inventoryPos == InventoryPos.RIGHT) {
            this.orgPos.set((float)width + this.getWidth(), ((float)height - this.getHeight()) / 2.0f);
            this.targetPos.set((float)width - this.getWidth() - DPIUtils.getSpacing(), ((float)height - this.getHeight()) / 2.0f);
        } else {
            this.orgPos.set(((float)width - this.getWidth()) / 2.0f, -this.getHeight());
            this.targetPos.set(((float)width - this.getWidth()) / 2.0f, ((float)height - this.getHeight()) / 2.0f);
        }
        this.setX(this.orgPos.x);
        this.setY(this.orgPos.y);
        if (this.menuButton != null) {
            this.menuButton.setPosition(this.getWidth() - this.menuButton.getWidth() / 2.0f, (this.getHeight() - this.menuButton.getHeight()) / 2.0f);
            float iconSize = DPIUtils.getPrefButtonSize();
            this.menuButton.setSize(iconSize, iconSize);
        }
    }

    public void setStyle(String name) {
        this.style = (InventoryUIStyle)this.sceneScreen.getUI().getSkin().get(name == null ? "default" : name, InventoryUIStyle.class);
    }

    public void retrieveAssets(TextureAtlas atlas) {
    }

    public void draw(Batch batch, float alpha) {
        Inventory inventory = this.sceneScreen.getWorld().getInventory();
        if (!inventory.isVisible()) {
            this.setVisible(false);
            return;
        }
        if (this.style.background != null) {
            this.style.background.draw(batch, this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
        int capacity = this.cols * this.rows;
        for (int i = 0; i < inventory.getNumItems() && i < capacity; ++i) {
            SpriteActor a = inventory.get(i);
            ActorRenderer r = a.getRenderer();
            float size = ((float)this.tileSize - this.rowSpace) / (r.getHeight() > r.getWidth() ? r.getHeight() : r.getWidth());
            float x = i % this.cols;
            float y = this.rows - 1 - i / this.cols;
            if (this.style.itemBackground != null) {
                this.style.itemBackground.draw(batch, this.getX() + x * (float)this.tileSize + x * this.rowSpace + (float)this.margin, this.getY() + y * (float)this.tileSize + y * this.rowSpace + (float)this.margin, (float)this.tileSize, (float)this.tileSize);
            }
            r.draw((SpriteBatch)batch, this.getX() + x * (float)this.tileSize + x * this.rowSpace + (float)(this.tileSize / 2) + (float)this.margin, this.getY() + ((float)this.tileSize - r.getHeight() * size) / 2.0f + y * (float)this.tileSize + y * this.rowSpace + (float)this.margin, size, size, 0.0f, a.getTint());
        }
        super.draw(batch, alpha);
    }

    public void cancelDragging() {
        this.draggedActor = null;
        this.pointer.drag(null);
    }

    private void startDragging(float x, float y) {
        this.draggedActor = this.getItemAt(x, y);
        if (this.draggedActor != null) {
            this.pointer.drag(this.draggedActor);
        }
    }

    public boolean isDragging() {
        return this.draggedActor != null;
    }

    private void stopDragging(int button) {
        this.sceneScreen.getWorld().getSceneCamera().getInputUnProject(this.sceneScreen.getViewport(), this.mousepos);
        InteractiveActor targetActor = this.sceneScreen.getCurrentActor();
        if (targetActor != null) {
            if (targetActor != this.draggedActor) {
                this.use(targetActor, this.draggedActor);
            } else if (this.singleAction) {
                this.sceneScreen.runVerb(targetActor, "lookat", null);
            } else {
                this.sceneScreen.actorClick(targetActor, button);
            }
        }
        this.draggedActor = null;
        this.pointer.drag(null);
    }

    private void use(InteractiveActor targetActor, InteractiveActor invActor) {
        Verb vtarget = targetActor.getVerb("use", invActor.getId());
        Verb vinv = invActor.getVerb("use", targetActor.getId());
        Verb bestMatch = vtarget;
        if (bestMatch == null) {
            bestMatch = vinv;
        } else if (vtarget != null && vinv != null && targetActor.getId().equals(vinv.getTarget()) && !invActor.getId().equals(vtarget.getTarget())) {
            bestMatch = vinv;
        }
        if (vinv == bestMatch) {
            this.sceneScreen.runVerb(invActor, "use", targetActor.getId());
        } else {
            this.sceneScreen.runVerb(targetActor, "use", invActor.getId());
        }
    }

    public SpriteActor getItemAt(float x, float y) {
        if (x < (float)this.margin || y < (float)this.margin || x >= this.getWidth() - (float)this.margin || y >= this.getHeight() - (float)this.margin) {
            return null;
        }
        Inventory inventory = this.sceneScreen.getWorld().getInventory();
        int i = (this.rows - 1 - (int)(y - (float)this.margin) / (this.tileSize + (int)this.rowSpace)) * this.cols + (int)(x - (float)this.margin) / (this.tileSize + (int)this.rowSpace);
        if (i >= 0 && i < inventory.getNumItems()) {
            return inventory.get(i);
        }
        return null;
    }

    public InventoryPos getInventoryPos() {
        return this.inventoryPos;
    }

    public static class InventoryUIStyle {
        public Drawable background;
        public Drawable itemBackground;
        public Button.ButtonStyle menuButtonStyle;
        public Button.ButtonStyle inventoryButtonStyle;

        public InventoryUIStyle() {
        }

        public InventoryUIStyle(InventoryUIStyle style) {
            this.background = style.background;
            this.menuButtonStyle = style.menuButtonStyle;
            this.itemBackground = style.itemBackground;
            this.inventoryButtonStyle = style.inventoryButtonStyle;
        }
    }

    public static enum InventoryPos {
        TOP,
        DOWN,
        LEFT,
        RIGHT,
        CENTER;

    }
}

