/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.ui;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.viewport.Viewport;
import com.bladecoder.engine.ui.AnimationDrawable;
import com.bladecoder.engine.util.DPIUtils;

public class Pointer
extends Actor {
    private static final String POINTER_ICON = "pointer";
    private Drawable pointerIcon;
    private final Vector2 mousepos = new Vector2();
    private float pointerScale;

    public Pointer(Skin skin) {
        this.pointerIcon = skin.getDrawable(POINTER_ICON);
        this.setTouchable(Touchable.disabled);
        this.resize();
        this.show();
    }

    private void getInputUnproject(Viewport v, Vector2 out) {
        out.set((float)Gdx.input.getX(), (float)Gdx.input.getY());
        v.unproject(out);
    }

    public void act(float delta) {
        if (this.pointerIcon instanceof AnimationDrawable) {
            ((AnimationDrawable)this.pointerIcon).act(delta);
        }
        super.act(delta);
        if (this.getStage().getActors().get(this.getStage().getActors().size - 1) != this) {
            this.toFront();
        }
    }

    public void draw(Batch batch, float alpha) {
        this.getInputUnproject(this.getStage().getViewport(), this.mousepos);
        this.setPosition(this.mousepos.x - this.getWidth() / 2.0f, this.mousepos.y - this.getHeight() / 2.0f);
        this.pointerIcon.draw(batch, this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    public void resize() {
        this.pointerScale = DPIUtils.getTouchMinSize() / this.pointerIcon.getMinHeight() * 0.8f;
        this.setSize(this.pointerIcon.getMinWidth() * this.pointerScale, this.pointerIcon.getMinHeight() * this.pointerScale);
    }

    public void show() {
        if (!Gdx.input.isPeripheralAvailable(Input.Peripheral.MultitouchScreen)) {
            this.setVisible(true);
        } else {
            this.setVisible(false);
        }
    }

    public void hide() {
        this.setVisible(false);
    }
}

