/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.ui;

import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.bladecoder.engine.model.AnimationRenderer;
import com.bladecoder.engine.model.BaseActor;
import com.bladecoder.engine.model.CharacterActor;
import com.bladecoder.engine.model.InteractiveActor;
import com.bladecoder.engine.model.Scene;
import com.bladecoder.engine.model.SpriteActor;
import com.bladecoder.engine.model.World;
import com.bladecoder.engine.util.Config;
import com.bladecoder.engine.util.EngineLogger;
import java.util.ArrayList;
import java.util.List;

public class TesterBot {
    private float maxWaitInverval = 1.0f;
    private float waitInverval = 0.0f;
    private float deltaTime = 0.0f;
    private float inSceneTime = 20.0f;
    private float inSceneTimeDelta = 0.0f;
    private Vector2 gotoVector = new Vector2();
    private boolean enabled = false;
    private boolean runLeaveVerbs = true;
    private boolean runGoto = false;
    private boolean passTexts = true;
    private boolean waitWhenWalking = true;
    private final ArrayList<String> excludeList = new ArrayList();
    private final boolean inventoryAction;
    private final World w;

    public TesterBot(World w) {
        this.w = w;
        this.inventoryAction = !Config.getInstance().getProperty("single_action_inventory", false);
    }

    public void update(float d) {
        if (!this.enabled) {
            return;
        }
        this.deltaTime += d;
        this.inSceneTimeDelta += d;
        if (this.w.inCutMode() && this.isPassTexts()) {
            this.w.getCurrentScene().getTextManager().next();
        }
        if (this.deltaTime > this.waitInverval && !this.w.inCutMode()) {
            this.deltaTime = 0.0f;
            this.waitInverval = MathUtils.random((float)this.maxWaitInverval);
            boolean isWalking = false;
            CharacterActor player = this.w.getCurrentScene().getPlayer();
            if (player != null && ((AnimationRenderer)player.getRenderer()).getCurrentAnimationId().startsWith("walk")) {
                isWalking = true;
            }
            if (this.isWaitWhenWalking() && isWalking) {
                return;
            }
            Scene s = this.w.getCurrentScene();
            if (!this.w.hasDialogOptions()) {
                boolean chooseActor = MathUtils.randomBoolean((float)0.75f);
                if (!this.isRunGoto() || chooseActor) {
                    boolean chooseSceneActor = MathUtils.randomBoolean();
                    if (chooseSceneActor && s.getActors().size() > 0) {
                        String verb;
                        int pos = MathUtils.random((int)(s.getActors().size() - 1));
                        BaseActor a = (BaseActor)s.getActors().values().toArray()[pos];
                        if (!(a instanceof InteractiveActor)) {
                            return;
                        }
                        InteractiveActor scnActor = (InteractiveActor)a;
                        if (this.excludeList.contains(scnActor.getId()) || !scnActor.canInteract()) {
                            return;
                        }
                        if (scnActor.getVerb("leave") != null) {
                            verb = "leave";
                        } else if (MathUtils.randomBoolean((float)0.33f)) {
                            verb = "lookat";
                        } else {
                            String string = verb = scnActor.getVerb("talkto") != null ? "talkto" : "pickup";
                        }
                        if (!verb.equals("leave") || this.runLeaveVerbs && !(this.inSceneTime > this.inSceneTimeDelta)) {
                            EngineLogger.debug("<TESTERBOT>: " + scnActor.getId() + "::" + verb);
                            scnActor.runVerb(verb);
                            if (verb.equals("leave")) {
                                this.inSceneTimeDelta = 0.0f;
                            }
                        }
                    } else if (this.w.getInventory().getNumItems() > 0 && this.w.getInventory().isVisible()) {
                        int pos = MathUtils.random((int)(this.w.getInventory().getNumItems() - 1));
                        SpriteActor invActor = this.w.getInventory().get(pos);
                        if (this.excludeList.contains(invActor.getId())) {
                            return;
                        }
                        int choosedVerb = MathUtils.random((int)3);
                        if (choosedVerb == 0) {
                            EngineLogger.debug("<TESTERBOT> INVENTORY: " + invActor.getId() + "::" + "lookat");
                            invActor.runVerb("lookat");
                        } else if (choosedVerb == 1 && this.inventoryAction) {
                            EngineLogger.debug("<TESTERBOT> INVENTORY: " + invActor.getId() + "::" + "pickup");
                            invActor.runVerb("pickup");
                        } else {
                            InteractiveActor targetActor = null;
                            if (this.w.getInventory().getNumItems() > 1 && MathUtils.randomBoolean((float)0.33f)) {
                                int pos2 = MathUtils.random((int)(this.w.getInventory().getNumItems() - 1));
                                if (pos2 == pos) {
                                    pos2 = (pos2 + 1) % this.w.getInventory().getNumItems();
                                }
                                if (this.excludeList.contains((targetActor = this.w.getInventory().get(pos2)).getId())) {
                                    return;
                                }
                                EngineLogger.debug("<TESTERBOT> INVENTORY: " + invActor.getId() + "::" + "use" + "::" + targetActor.getId());
                                if (invActor.getVerb("use", targetActor.getId()) != null) {
                                    invActor.runVerb("use", targetActor.getId());
                                } else {
                                    targetActor.runVerb("use", invActor.getId());
                                }
                            } else {
                                int pos2 = MathUtils.random((int)(s.getActors().size() - 1));
                                if (!(s.getActors().values().toArray()[pos2] instanceof InteractiveActor)) {
                                    return;
                                }
                                targetActor = (InteractiveActor)s.getActors().values().toArray()[pos2];
                                if (!this.excludeList.contains(targetActor.getId()) && targetActor.isVisible() && targetActor.canInteract()) {
                                    EngineLogger.debug("<TESTERBOT> INVENTORY: " + invActor.getId() + "::" + "use" + "::" + targetActor.getId());
                                    if (invActor.getVerb("use", targetActor.getId()) != null) {
                                        invActor.runVerb("use", targetActor.getId());
                                    } else {
                                        targetActor.runVerb("use", invActor.getId());
                                    }
                                }
                            }
                        }
                    }
                } else if (s.getPlayer() != null) {
                    this.gotoVector.x = MathUtils.random() * this.w.getCurrentScene().getCamera().getScrollingWidth();
                    this.gotoVector.y = MathUtils.random() * this.w.getCurrentScene().getCamera().getScrollingHeight();
                    if (s.getPlayer().getVerb("goto") != null) {
                        EngineLogger.debug("<TESTERBOT> GOTO: GOTO VERB");
                        s.getPlayer().runVerb("goto");
                    } else {
                        EngineLogger.debug("<TESTERBOT> GOTO: " + this.gotoVector);
                        s.getPlayer().goTo(this.gotoVector, null, false);
                    }
                }
            } else {
                List<String> visibleOptions = this.w.getDialogOptions();
                if (visibleOptions.size() > 0) {
                    int pos = MathUtils.random((int)(visibleOptions.size() - 1));
                    EngineLogger.debug("<TESTERBOT> SELECT OPTION: " + pos);
                    this.w.selectDialogOption(pos);
                }
            }
        }
    }

    public void draw(SpriteBatch batch) {
        if (this.enabled) {
            // empty if block
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (enabled) {
            EngineLogger.debug("<TESTERBOT> BOT ENABLED...");
        } else {
            EngineLogger.debug("<TESTERBOT> BOT DISABLED...");
        }
    }

    public boolean isRunLeaveVerbs() {
        return this.runLeaveVerbs;
    }

    public void setRunLeaveVerbs(boolean runLeaveVerbs) {
        this.runLeaveVerbs = runLeaveVerbs;
    }

    public boolean isRunGoto() {
        return this.runGoto;
    }

    public void setRunGoto(boolean runGoto) {
        this.runGoto = runGoto;
    }

    public float getMaxWaitInverval() {
        return this.maxWaitInverval;
    }

    public void setMaxWaitInverval(float maxWaitInverval) {
        this.maxWaitInverval = maxWaitInverval;
    }

    public float getInSceneTime() {
        return this.inSceneTime;
    }

    public void setInSceneTime(float inSceneTime) {
        this.inSceneTime = inSceneTime;
    }

    public boolean isPassTexts() {
        return this.passTexts;
    }

    public void setPassTexts(boolean passTexts) {
        this.passTexts = passTexts;
    }

    public boolean isWaitWhenWalking() {
        return this.waitWhenWalking;
    }

    public void setWaitWhenWalking(boolean waitWhenWalking) {
        this.waitWhenWalking = waitWhenWalking;
    }

    public String getExcludeList() {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < this.excludeList.size(); ++i) {
            s.append(this.excludeList.get(i));
            if (i >= this.excludeList.size() - 1) continue;
            s.append(',');
        }
        return s.toString();
    }

    public void setExcludeList(String l) {
        String[] split = l.split(",");
        this.excludeList.clear();
        for (int i = 0; i < split.length; ++i) {
            this.excludeList.add(split[i].trim());
        }
    }
}

