/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.ui.defaults;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.InputMultiplexer;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.input.GestureDetector;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.Polygon;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.TransformDrawable;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.viewport.Viewport;
import com.bladecoder.engine.assets.EngineAssetManager;
import com.bladecoder.engine.model.AnchorActor;
import com.bladecoder.engine.model.BaseActor;
import com.bladecoder.engine.model.CharacterActor;
import com.bladecoder.engine.model.InteractiveActor;
import com.bladecoder.engine.model.Scene;
import com.bladecoder.engine.model.Text;
import com.bladecoder.engine.model.Transition;
import com.bladecoder.engine.model.Verb;
import com.bladecoder.engine.model.World;
import com.bladecoder.engine.model.WorldListener;
import com.bladecoder.engine.ui.AnimButton;
import com.bladecoder.engine.ui.AnimationDrawable;
import com.bladecoder.engine.ui.DialogUI;
import com.bladecoder.engine.ui.ITextManagerUI;
import com.bladecoder.engine.ui.InventoryButton;
import com.bladecoder.engine.ui.InventoryUI;
import com.bladecoder.engine.ui.PieMenu;
import com.bladecoder.engine.ui.Recorder;
import com.bladecoder.engine.ui.SceneExtendViewport;
import com.bladecoder.engine.ui.SceneFitViewport;
import com.bladecoder.engine.ui.SceneScreen;
import com.bladecoder.engine.ui.TesterBot;
import com.bladecoder.engine.ui.TextManagerUI;
import com.bladecoder.engine.ui.UI;
import com.bladecoder.engine.ui.defaults.SceneGestureDetector;
import com.bladecoder.engine.ui.defaults.ScenePointer;
import com.bladecoder.engine.ui.defaults.SceneWorldListener;
import com.bladecoder.engine.util.Config;
import com.bladecoder.engine.util.DPIUtils;
import com.bladecoder.engine.util.EngineLogger;
import com.bladecoder.engine.util.RectangleRenderer;
import java.util.Locale;

public class DefaultSceneScreen
implements SceneScreen {
    private static final float LOADING_WAIT_TIME_MS = 400.0f;
    private UI ui;
    private Stage stage;
    private PieMenu pie;
    private InventoryUI inventoryUI;
    private Actor dialogUI;
    private Actor textManagerUI;
    private ShapeRenderer renderer;
    private InventoryButton inventoryButton;
    private Button menuButton;
    private UIModes uiMode = UIModes.TWO_BUTTONS;
    private Recorder recorder;
    private TesterBot testerBot;
    private final Viewport viewport;
    private final Vector3 unprojectTmp = new Vector3();
    private final Vector2 unproject2Tmp = new Vector2();
    private final StringBuilder sbTmp = new StringBuilder();
    private InteractiveActor currentActor = null;
    private boolean drawHotspots = false;
    private boolean showHotspotsFeature = true;
    private final boolean showDesc;
    private final boolean fastLeave;
    private float speed = 1.0f;
    private ScenePointer pointer;
    private boolean uiEnabled = true;
    private final GlyphLayout textLayout = new GlyphLayout();
    private final GestureDetector inputProcessor = new SceneGestureDetector(this);
    private final WorldListener worldListener = new SceneWorldListener(this);

    public DefaultSceneScreen() {
        this.viewport = Config.getInstance().getProperty("extend_viewport", true) ? new SceneExtendViewport() : new SceneFitViewport();
        this.showDesc = Config.getInstance().getProperty("show_desc", true);
        this.fastLeave = Config.getInstance().getProperty("fast_leave", false);
        this.showHotspotsFeature = Config.getInstance().getProperty("show_hotspots", true);
    }

    @Override
    public UI getUI() {
        return this.ui;
    }

    @Override
    public World getWorld() {
        return this.ui.getWorld();
    }

    public boolean isUiEnabled() {
        return this.uiEnabled;
    }

    public PieMenu getPie() {
        return this.pie;
    }

    public InventoryButton getInventoryButton() {
        return this.inventoryButton;
    }

    public boolean getDrawHotspots() {
        return this.drawHotspots;
    }

    public void setDrawHotspots(boolean drawHotspots) {
        this.drawHotspots = drawHotspots && this.showHotspotsFeature;
    }

    public void setShowHotspotsFeature(boolean v) {
        this.showHotspotsFeature = v;
    }

    public UIModes getUIMode() {
        return this.uiMode;
    }

    void showUIText(Text t) {
        String style = t.style == null ? "ui-text" : t.style;
        Label msg = new Label((CharSequence)t.str, this.getUI().getSkin(), style);
        msg.setWrap(true);
        msg.setAlignment(1, 1);
        if (t.color != null) {
            msg.setColor(t.color);
        }
        msg.setSize(msg.getWidth() + DPIUtils.getMarginSize() * 2.0f, msg.getHeight() + DPIUtils.getMarginSize() * 2.0f);
        this.stage.addActor((Actor)msg);
        this.unprojectTmp.set(t.x, t.y, 0.0f);
        this.getWorld().getSceneCamera().scene2screen(this.getStage().getViewport(), this.unprojectTmp);
        float posx = t.x == -1.0f ? ((float)this.getStage().getViewport().getScreenWidth() - msg.getWidth()) / 2.0f : (t.x == -2.0f ? DPIUtils.getMarginSize() : this.unprojectTmp.x);
        float posy = t.y == -1.0f ? ((float)this.getStage().getViewport().getScreenHeight() - msg.getHeight()) / 2.0f : (t.y == -2.0f ? (float)this.getStage().getViewport().getScreenHeight() - msg.getHeight() - DPIUtils.getMarginSize() * 3.0f : this.unprojectTmp.y);
        msg.setPosition(posx, posy);
        msg.getColor().a = 0.0f;
        msg.addAction((Action)Actions.sequence((Action)Actions.fadeIn((float)0.4f, (Interpolation)Interpolation.fade), (Action)Actions.delay((float)t.time, (Action)Actions.sequence((Action)Actions.fadeOut((float)0.4f, (Interpolation)Interpolation.fade), (Action)Actions.removeActor()))));
    }

    void updateUI() {
        World w = this.getWorld();
        if (w.getAssetState() == null || w.getAssetState() == World.AssetState.LOAD_ASSETS || w.getAssetState() == World.AssetState.LOAD_ASSETS_AND_INIT_SCENE) {
            return;
        }
        if (this.uiMode == UIModes.PIE && this.pie.isVisible()) {
            this.pie.hide();
        }
        this.currentActor = null;
        this.pointer.reset();
        if (w.isPaused() || w.inCutMode() || this.testerBot.isEnabled() || this.recorder.isPlaying()) {
            this.inventoryUI.hide();
            this.inventoryButton.setVisible(false);
            this.dialogUI.setVisible(false);
            this.inventoryUI.cancelDragging();
            this.uiEnabled = false;
            EngineLogger.debug("Updating UI: DISABLED.");
        } else {
            if (this.getWorld().hasDialogOptions()) {
                this.inventoryUI.hide();
                this.inventoryButton.setVisible(false);
                this.dialogUI.setVisible(true);
                this.inventoryUI.cancelDragging();
                EngineLogger.debug("Updating UI: DIALOG OPTIONS.");
            } else {
                this.inventoryUI.hide();
                this.dialogUI.setVisible(false);
                this.inventoryButton.setVisible(w.getInventory().isVisible());
                EngineLogger.debug("Updating UI: ENABLED.");
            }
            this.uiEnabled = true;
        }
    }

    @Override
    public void setSpeed(float s) {
        this.speed = s;
    }

    @Override
    public float getSpeed() {
        return this.speed;
    }

    private void update(float delta) {
        World world = this.getWorld();
        float deltaScaled = delta * this.speed;
        if (!world.isDisposed()) {
            world.update(deltaScaled);
            if (world.isDisposed()) {
                return;
            }
        }
        if (world.getAssetState() != World.AssetState.LOADED) {
            long t0;
            long t = t0 = System.currentTimeMillis();
            while (EngineAssetManager.getInstance().isLoading() && (float)(t - t0) < 400.0f) {
                t = System.currentTimeMillis();
            }
            if ((float)(t - t0) >= 400.0f) {
                this.ui.setCurrentScreen(UI.Screens.LOADING_SCREEN);
            } else {
                this.updateUI();
                world.resize(this.viewport.getWorldWidth(), this.viewport.getWorldHeight());
                world.update(0.0f);
            }
            return;
        }
        this.stage.act(delta);
        this.pointer.update(delta);
        if (this.drawHotspots) {
            Drawable hotspotDrawable = this.getUI().getSkin().getDrawable("leave");
            Drawable leaveDrawable = this.getUI().getSkin().getDrawable("hotspot");
            if (hotspotDrawable != null && hotspotDrawable instanceof AnimationDrawable) {
                ((AnimationDrawable)hotspotDrawable).act(delta);
            }
            if (leaveDrawable != null && leaveDrawable instanceof AnimationDrawable) {
                ((AnimationDrawable)leaveDrawable).act(delta);
            }
        }
        if (world.isPaused()) {
            return;
        }
        this.recorder.update(deltaScaled);
        this.testerBot.update(deltaScaled);
        InteractiveActor actorUnderCursor = null;
        if (this.uiEnabled && !world.hasDialogOptions()) {
            if (this.inventoryUI.isVisible()) {
                this.unproject2Tmp.set((float)Gdx.input.getX(), (float)Gdx.input.getY());
                this.inventoryUI.screenToLocalCoordinates(this.unproject2Tmp);
                actorUnderCursor = this.inventoryUI.getItemAt(this.unproject2Tmp.x, this.unproject2Tmp.y);
            } else {
                actorUnderCursor = this.getActorUnderCursor();
            }
            if (!this.pie.isVisible() && actorUnderCursor != this.currentActor) {
                this.currentActor = actorUnderCursor;
                if (this.currentActor != null) {
                    if (this.showDesc) {
                        this.pointer.setDesc(this.currentActor.getDesc());
                    }
                    Verb leaveVerb = this.currentActor.getVerb("leave");
                    Drawable r = null;
                    if (leaveVerb != null) {
                        r = this.getDrawable(leaveVerb.getIcon());
                        if (r != null) {
                            this.pointer.setIcon(r);
                        } else {
                            this.pointer.setLeaveIcon(this.calcLeaveArrowRotation(this.currentActor));
                        }
                    } else {
                        Verb actionVerb = this.currentActor.getVerb("action");
                        if (actionVerb != null && (r = this.getDrawable(actionVerb.getIcon())) != null) {
                            this.pointer.setIcon(r);
                        } else {
                            this.pointer.setHotspotIcon();
                        }
                    }
                } else {
                    this.pointer.setDefaultIcon();
                }
            } else if (this.pie.isVisible()) {
                this.currentActor = actorUnderCursor;
            }
        }
    }

    private Drawable getDrawable(String name) {
        if (name == null) {
            return null;
        }
        try {
            return this.getUI().getSkin().getDrawable(name);
        }
        catch (GdxRuntimeException e) {
            return null;
        }
    }

    private InteractiveActor getActorUnderCursor() {
        float tolerance = this.inventoryUI.isDragging() ? DPIUtils.getTouchMinSize() : (Gdx.input.isPeripheralAvailable(Input.Peripheral.MultitouchScreen) ? DPIUtils.getTouchMinSize() / 2.0f : 0.0f);
        return this.getWorld().getInteractiveActorAtInput(this.viewport, tolerance);
    }

    private float calcLeaveArrowRotation(InteractiveActor actor) {
        Verb verb = actor.getVerb("leave");
        if (verb == null || verb.getIcon() == null) {
            actor.getBBox().getBoundingRectangle().getCenter(this.unproject2Tmp);
            if (this.unproject2Tmp.x < this.stage.getViewport().getWorldWidth() / 3.0f) {
                return 180.0f;
            }
            if (this.unproject2Tmp.x > this.stage.getViewport().getWorldWidth() / 3.0f * 2.0f) {
                return 0.0f;
            }
            if (this.unproject2Tmp.y < this.stage.getViewport().getWorldHeight() / 5.0f) {
                return -90.0f;
            }
            return 90.0f;
        }
        String dir = verb.getIcon();
        if (dir.equals("left")) {
            return 180.0f;
        }
        if (dir.equals("right")) {
            return 0.0f;
        }
        if (dir.equals("down")) {
            return -90.0f;
        }
        return 90.0f;
    }

    public void render(float delta) {
        World world = this.getWorld();
        this.update(delta);
        if (world.getAssetState() != World.AssetState.LOADED) {
            return;
        }
        SpriteBatch batch = this.ui.getBatch();
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        world.draw();
        if (EngineLogger.debugMode() && EngineLogger.getDebugLevel() == 1) {
            this.renderer.setProjectionMatrix(world.getSceneCamera().combined);
            world.getCurrentScene().drawBBoxLines(this.renderer);
            this.renderer.end();
        }
        this.stage.draw();
        batch.setProjectionMatrix(this.viewport.getCamera().combined);
        batch.begin();
        if (!(world.inCutMode() || this.recorder.isPlaying() || this.testerBot.isEnabled())) {
            this.pointer.draw(batch, this.viewport);
        }
        Transition t = world.getTransition();
        t.draw(batch, this.viewport.getScreenWidth(), this.viewport.getScreenHeight());
        this.recorder.draw(batch);
        this.testerBot.draw(batch);
        if (this.drawHotspots) {
            this.drawHotspots(batch);
        }
        if (EngineLogger.debugMode()) {
            this.drawDebugText(batch);
        }
        batch.end();
    }

    private void drawDebugText(SpriteBatch batch) {
        Color color;
        World w = this.getWorld();
        w.getSceneCamera().getInputUnProject(this.viewport, this.unprojectTmp);
        this.sbTmp.setLength(0);
        if (EngineLogger.lastError != null) {
            this.sbTmp.append(EngineLogger.lastError);
            color = Color.RED;
        } else {
            this.sbTmp.append(" ");
            long millis = w.getTimeOfGame();
            long second = millis / 1000L % 60L;
            long minute = millis / 60000L % 60L;
            long hour = millis / 3600000L;
            String time = String.format("%02d:%02d:%02d", hour, minute, second);
            this.sbTmp.append(time);
            if (EngineLogger.getDebugLevel() == 1) {
                if (w.inCutMode()) {
                    this.sbTmp.append(" CUT_MODE ");
                } else if (w.hasDialogOptions()) {
                    this.sbTmp.append(" DIALOG_MODE ");
                } else if (w.isPaused()) {
                    this.sbTmp.append(" PAUSED ");
                }
                this.sbTmp.append(" ( ");
                this.sbTmp.append((int)this.unprojectTmp.x);
                this.sbTmp.append(", ");
                this.sbTmp.append((int)this.unprojectTmp.y);
                this.sbTmp.append(") FPS:");
                this.sbTmp.append(Gdx.graphics.getFramesPerSecond());
                if (w.getCurrentScene().getState() != null) {
                    this.sbTmp.append(" Scn State: ");
                    this.sbTmp.append(w.getCurrentScene().getState());
                }
                if (w.getCurrentScene().getPlayer() != null) {
                    this.sbTmp.append(" Depth Scl: ");
                    this.sbTmp.append(w.getCurrentScene().getFakeDepthScale(this.unprojectTmp.y));
                }
            }
            color = Color.WHITE;
        }
        String strDebug = this.sbTmp.toString();
        this.textLayout.setText(this.ui.getSkin().getFont("debug"), (CharSequence)strDebug, color, (float)this.viewport.getScreenWidth(), 8, true);
        RectangleRenderer.draw((Batch)batch, 0.0f, (float)this.viewport.getScreenHeight() - this.textLayout.height - 10.0f, this.textLayout.width, this.textLayout.height + 10.0f, Color.BLACK);
        this.ui.getSkin().getFont("debug").draw((Batch)batch, this.textLayout, 0.0f, (float)(this.viewport.getScreenHeight() - 5));
        if (EngineLogger.getDebugLevel() == 1) {
            for (BaseActor a : w.getCurrentScene().getActors().values()) {
                if (a instanceof AnchorActor) continue;
                Rectangle r = a.getBBox().getBoundingRectangle();
                this.sbTmp.setLength(0);
                this.sbTmp.append(a.getId());
                if (a instanceof InteractiveActor && ((InteractiveActor)a).getState() != null) {
                    this.sbTmp.append(".").append(((InteractiveActor)a).getState());
                }
                this.unprojectTmp.set(r.getX(), r.getY(), 0.0f);
                w.getSceneCamera().scene2screen(this.viewport, this.unprojectTmp);
                this.ui.getSkin().getFont("debug").draw((Batch)batch, (CharSequence)this.sbTmp.toString(), this.unprojectTmp.x, this.unprojectTmp.y);
            }
        }
    }

    private void drawHotspots(SpriteBatch batch) {
        World world = this.getWorld();
        for (BaseActor a : world.getCurrentScene().getActors().values()) {
            InteractiveActor ia;
            if (!(a instanceof InteractiveActor) || !a.isVisible() || a == world.getCurrentScene().getPlayer() || !(ia = (InteractiveActor)a).canInteract()) continue;
            Polygon p = a.getBBox();
            if (p == null) {
                EngineLogger.error("ERROR DRAWING HOTSPOT FOR: " + a.getId());
            }
            Rectangle r = a.getBBox().getBoundingRectangle();
            this.unprojectTmp.set(r.getX() + r.getWidth() / 2.0f, r.getY() + r.getHeight() / 2.0f, 0.0f);
            world.getSceneCamera().scene2screen(this.viewport, this.unprojectTmp);
            if (!this.showDesc || ia.getDesc() == null) {
                Drawable drawable;
                float size = DPIUtils.ICON_SIZE * DPIUtils.getSizeMultiplier();
                if (ia.getVerb("leave") != null) {
                    drawable = (TransformDrawable)this.getUI().getSkin().getDrawable("leave");
                    drawable.draw((Batch)batch, this.unprojectTmp.x - size / 2.0f, this.unprojectTmp.y - size / 2.0f, size / 2.0f, size / 2.0f, size, size, 1.0f, 1.0f, this.calcLeaveArrowRotation(ia));
                    continue;
                }
                drawable = this.getUI().getSkin().getDrawable("hotspot");
                if (drawable == null) continue;
                drawable.draw((Batch)batch, this.unprojectTmp.x - size / 2.0f, this.unprojectTmp.y - size / 2.0f, size, size);
                continue;
            }
            BitmapFont font = this.getUI().getSkin().getFont("desc");
            String desc = ia.getDesc();
            if (desc.charAt(0) == '@') {
                desc = this.getWorld().getI18N().getString(desc.substring(1));
            }
            this.textLayout.setText(font, (CharSequence)desc);
            float textX = this.unprojectTmp.x - this.textLayout.width / 2.0f;
            float textY = this.unprojectTmp.y + this.textLayout.height;
            RectangleRenderer.draw((Batch)batch, textX - 8.0f, textY - this.textLayout.height - 8.0f, this.textLayout.width + 16.0f, this.textLayout.height + 16.0f, Color.BLACK);
            font.draw((Batch)batch, this.textLayout, textX, textY);
        }
    }

    public void resize(int width, int height) {
        World world = this.getWorld();
        if (!world.isDisposed()) {
            this.viewport.setWorldSize((float)world.getWidth(), (float)world.getHeight());
            this.viewport.update(width, height, true);
            world.resize(this.viewport.getWorldWidth(), this.viewport.getWorldHeight());
        } else {
            this.viewport.setWorldSize((float)width, (float)height);
            this.viewport.update(width, height, true);
        }
        this.updateUI();
        this.pie.resize(this.viewport.getScreenWidth(), this.viewport.getScreenHeight());
        this.inventoryUI.resize(this.viewport.getScreenWidth(), this.viewport.getScreenHeight());
        this.inventoryButton.resize(width, height);
        this.pointer.resize(width, height);
        float size = DPIUtils.getPrefButtonSize();
        float margin = DPIUtils.getMarginSize();
        this.menuButton.setSize(size, size);
        this.menuButton.setPosition((float)this.stage.getViewport().getScreenWidth() - this.menuButton.getWidth() - margin, (float)this.stage.getViewport().getScreenHeight() - this.menuButton.getHeight() - margin);
    }

    public void dispose() {
        this.renderer.dispose();
        this.stage.dispose();
    }

    private void retrieveAssets(TextureAtlas atlas) {
        this.renderer = new ShapeRenderer();
        this.inventoryUI.retrieveAssets(atlas);
    }

    void sceneClick(int button, int count) {
        World w = this.getWorld();
        w.getSceneCamera().getInputUnProject(this.viewport, this.unprojectTmp);
        Scene s = w.getCurrentScene();
        CharacterActor player = s.getPlayer();
        this.currentActor = this.getActorUnderCursor();
        if (this.currentActor != null) {
            if (EngineLogger.debugMode()) {
                EngineLogger.debug(this.currentActor.toString());
            }
            if (count > 1) {
                if (count == 2 && this.fastLeave && !this.recorder.isRecording() && player != null && this.currentActor.getVerb("leave") != null) {
                    player.fastWalk();
                }
                return;
            }
            this.actorClick(this.currentActor, button);
        } else if (player != null) {
            if (count > 1) {
                return;
            }
            if (s.getPlayer().getVerb("goto") != null) {
                this.runVerb(s.getPlayer(), "goto", null);
            } else {
                Vector2 pos = new Vector2(this.unprojectTmp.x, this.unprojectTmp.y);
                if (this.recorder.isRecording()) {
                    this.recorder.add(pos);
                }
                player.goTo(pos, null, false);
            }
        }
    }

    @Override
    public void actorClick(InteractiveActor a, int button) {
        boolean lookatButton;
        boolean bl = lookatButton = button == 1;
        if (a.getVerb("leave") != null) {
            this.runVerb(a, "leave", null);
        } else if (a.getVerb("action") != null) {
            this.runVerb(a, "action", null);
        } else if (this.uiMode == UIModes.SINGLE_CLICK) {
            String verb = "talkto";
            if (a.getVerb(verb) == null) {
                verb = "pickup";
            }
            if (a.getVerb(verb) == null) {
                verb = "lookat";
            }
            this.runVerb(a, verb, null);
        } else if (this.uiMode == UIModes.TWO_BUTTONS) {
            String verb = "lookat";
            if (!lookatButton) {
                verb = a.getVerb("talkto") != null ? "talkto" : "pickup";
            }
            this.runVerb(a, verb, null);
        } else if (this.uiMode == UIModes.PIE) {
            this.getInputUnProject(this.unprojectTmp);
            this.pie.show(a, this.unprojectTmp.x, this.unprojectTmp.y);
            this.pointer.reset();
        }
    }

    private void getInputUnProject(Vector3 out) {
        out.set((float)Gdx.input.getX(), (float)Gdx.input.getY(), 0.0f);
        this.viewport.unproject(out);
    }

    @Override
    public void runVerb(InteractiveActor a, String verb, String target) {
        if (this.recorder.isRecording()) {
            this.recorder.add(a.getId(), verb, target);
        }
        a.runVerb(verb, target);
    }

    void showMenu() {
        this.pause();
        this.ui.setCurrentScreen(UI.Screens.MENU_SCREEN);
    }

    public InventoryUI getInventoryUI() {
        return this.inventoryUI;
    }

    public Actor getTextManagerUI() {
        return this.textManagerUI;
    }

    public Actor getDialogUI() {
        return this.dialogUI;
    }

    public void setTextManagerUI(Actor a) {
        if (a instanceof ITextManagerUI) {
            this.textManagerUI.remove();
            this.textManagerUI = a;
            this.stage.addActor(this.textManagerUI);
        } else {
            EngineLogger.error("ERROR setTextManagerUI: actor is not a ITextManagerUI");
            this.dispose();
            Gdx.app.exit();
        }
    }

    public void setDialogUI(Actor a) {
        this.dialogUI.remove();
        this.dialogUI = a;
        this.stage.addActor(this.dialogUI);
    }

    public Stage getStage() {
        return this.stage;
    }

    public Button getMenuButton() {
        return this.menuButton;
    }

    public void show() {
        InputMultiplexer multiplexer = new InputMultiplexer();
        multiplexer.addProcessor((InputProcessor)this.stage);
        multiplexer.addProcessor((InputProcessor)this.inputProcessor);
        Gdx.input.setInputProcessor((InputProcessor)multiplexer);
        if (this.getWorld().isDisposed()) {
            try {
                this.getWorld().load();
            }
            catch (Exception e) {
                EngineLogger.error("ERROR LOADING GAME", e);
                this.dispose();
                Gdx.app.exit();
            }
        }
        this.getWorld().setListener(this.worldListener);
        this.getWorld().resume();
    }

    public void hide() {
        this.getWorld().pause();
    }

    public void pause() {
        this.getWorld().pause();
    }

    public void resume() {
        this.getWorld().resume();
        if (EngineLogger.lastError != null && EngineLogger.debugMode()) {
            EngineLogger.lastError = null;
            EngineLogger.lastException = null;
        }
    }

    @Override
    public Viewport getViewport() {
        return this.viewport;
    }

    @Override
    public InteractiveActor getCurrentActor() {
        return this.currentActor;
    }

    @Override
    public void setUI(final UI ui) {
        this.ui = ui;
        this.recorder = ui.getRecorder();
        this.testerBot = ui.getTesterBot();
        this.pie = new PieMenu(this);
        this.textManagerUI = new TextManagerUI(ui.getSkin(), this.getWorld());
        this.menuButton = new AnimButton(ui.getSkin(), "menu");
        this.dialogUI = new DialogUI(ui.getSkin(), this.getWorld(), ui.getRecorder());
        this.pointer = new ScenePointer(ui.getSkin(), this.getWorld());
        this.inventoryUI = new InventoryUI(this, this.pointer);
        this.inventoryButton = new InventoryButton(ui.getSkin(), this.getWorld(), this.inventoryUI);
        this.uiMode = UIModes.valueOf(Config.getInstance().getProperty("ui_mode", "TWO_BUTTONS").toUpperCase(Locale.ENGLISH));
        if (Gdx.input.isPeripheralAvailable(Input.Peripheral.MultitouchScreen) && this.uiMode == UIModes.TWO_BUTTONS) {
            this.uiMode = UIModes.PIE;
        }
        this.pie.setVisible(false);
        this.menuButton.addListener((EventListener)new ClickListener(){

            public void clicked(InputEvent event, float x, float y) {
                ui.setCurrentScreen(UI.Screens.MENU_SCREEN);
            }
        });
        this.retrieveAssets(ui.getUIAtlas());
        this.stage = new Stage(this.viewport);
        this.stage.addActor(this.textManagerUI);
        this.stage.addActor(this.dialogUI);
        this.stage.addActor((Actor)this.inventoryButton);
        this.stage.addActor((Actor)this.menuButton);
        this.stage.addActor((Actor)this.inventoryUI);
        this.stage.addActor((Actor)this.pie);
    }

    public static enum UIModes {
        TWO_BUTTONS,
        PIE,
        SINGLE_CLICK;

    }
}

