/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.ui.defaults;

import com.badlogic.gdx.input.GestureDetector;
import com.bladecoder.engine.model.TextManager;
import com.bladecoder.engine.model.World;
import com.bladecoder.engine.ui.defaults.DefaultSceneScreen;
import com.bladecoder.engine.util.EngineLogger;

public class SceneGestureListener
extends GestureDetector.GestureAdapter {
    private DefaultSceneScreen dsc;

    public SceneGestureListener(DefaultSceneScreen dsc) {
        this.dsc = dsc;
    }

    public boolean touchDown(float x, float y, int pointer, int button) {
        return true;
    }

    public boolean tap(float x, float y, int count, int button) {
        EngineLogger.debug("Event TAP button: " + button + " count: " + count);
        World w = this.dsc.getWorld();
        if (w.getAssetState() != World.AssetState.LOADED || w.isPaused() || this.dsc.getUI().getRecorder().isPlaying() || this.dsc.getUI().getTesterBot().isEnabled()) {
            return true;
        }
        if (this.dsc.getPie().isVisible()) {
            this.dsc.getPie().hide();
        }
        if (this.dsc.getDrawHotspots()) {
            this.dsc.setDrawHotspots(false);
        } else if (w.inCutMode() || !TextManager.AUTO_HIDE_TEXTS && this.dsc.getTextManagerUI().isVisible()) {
            if (this.dsc.getUI().getRecorder().isRecording()) {
                return true;
            }
            w.getCurrentScene().getTextManager().next();
        } else if (this.dsc.getInventoryUI().isVisible()) {
            this.dsc.getInventoryUI().hide();
        } else if (!w.hasDialogOptions()) {
            if (button == 2) {
                if (!this.dsc.getInventoryUI().isVisible()) {
                    this.dsc.getInventoryUI().show();
                }
            } else {
                this.dsc.sceneClick(button, count);
            }
        }
        return true;
    }

    public boolean longPress(float x, float y) {
        EngineLogger.debug("Event LONG PRESS");
        if (this.dsc.isUiEnabled() && !this.dsc.getWorld().hasDialogOptions()) {
            this.dsc.setDrawHotspots(true);
        }
        return false;
    }

    public boolean pan(float x, float y, float deltaX, float deltaY) {
        return true;
    }

    public boolean panStop(float x, float y, int pointer, int button) {
        this.tap(x, y, 1, button);
        return true;
    }
}

