/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.ui.defaults;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.TransformDrawable;
import com.badlogic.gdx.utils.viewport.Viewport;
import com.bladecoder.engine.model.ActorRenderer;
import com.bladecoder.engine.model.SpriteActor;
import com.bladecoder.engine.model.World;
import com.bladecoder.engine.ui.AnimationDrawable;
import com.bladecoder.engine.util.DPIUtils;
import com.bladecoder.engine.util.RectangleRenderer;

public class ScenePointer {
    private static final String LEAVE_ICON = "leave";
    private static final String POINTER_ICON = "pointer";
    private static final String HOTSPOT_ICON = "hotspotpointer";
    private static final Color DRAG_NOT_HOTSPOT_COLOR = new Color(0.5f, 0.5f, 0.5f, 1.0f);
    private Color tmpTint = new Color();
    private BitmapFont font;
    private String desc = null;
    private Drawable leaveIcon;
    private Drawable pointerIcon;
    private Drawable hotspotIcon;
    private Drawable currentIcon;
    private SpriteActor draggingActor;
    private final Vector2 mousepos = new Vector2();
    private float pointerScale;
    private float leaveRotation = 0.0f;
    private final World world;
    private final GlyphLayout layout = new GlyphLayout();

    public ScenePointer(Skin skin, World w) {
        this.world = w;
        this.font = skin.getFont("desc");
        this.pointerIcon = skin.getDrawable(POINTER_ICON);
        this.leaveIcon = skin.getDrawable(LEAVE_ICON);
        this.hotspotIcon = skin.getDrawable(HOTSPOT_ICON);
        this.reset();
    }

    public void reset() {
        this.setDefaultIcon();
        this.draggingActor = null;
    }

    public void drag(SpriteActor a) {
        this.draggingActor = a;
        this.tmpTint.set(DRAG_NOT_HOTSPOT_COLOR);
        if (a != null && this.draggingActor.getTint() != null) {
            this.tmpTint.mul(this.draggingActor.getTint());
        }
    }

    public void setDefaultIcon() {
        this.currentIcon = this.pointerIcon;
        this.desc = null;
    }

    public void setLeaveIcon(float rot) {
        this.currentIcon = this.leaveIcon;
        this.leaveRotation = rot;
    }

    public void setHotspotIcon() {
        this.currentIcon = this.hotspotIcon;
    }

    public void setIcon(Drawable r) {
        this.currentIcon = r;
    }

    public void setDesc(String s) {
        this.desc = s;
        if (this.desc != null) {
            if (this.desc.charAt(0) == '@') {
                this.desc = this.world.getI18N().getString(this.desc.substring(1));
            }
            this.layout.setText(this.font, (CharSequence)this.desc);
        }
    }

    private void getInputUnproject(Viewport v, Vector2 out) {
        out.set((float)Gdx.input.getX(), (float)Gdx.input.getY());
        v.unproject(out);
    }

    public void update(float delta) {
        if (this.currentIcon instanceof AnimationDrawable) {
            ((AnimationDrawable)this.currentIcon).act(delta);
        }
    }

    public void draw(SpriteBatch batch, Viewport v) {
        this.getInputUnproject(v, this.mousepos);
        boolean multiTouch = Gdx.input.isPeripheralAvailable(Input.Peripheral.MultitouchScreen);
        if (this.desc != null && (!multiTouch || Gdx.input.isTouched())) {
            float margin = DPIUtils.UI_SPACE;
            float textX = this.mousepos.x - this.layout.width / 2.0f;
            float textY = this.mousepos.y + this.layout.height + DPIUtils.UI_SPACE + DPIUtils.getTouchMinSize();
            if (textX < 0.0f) {
                textX = 0.0f;
            }
            RectangleRenderer.draw((Batch)batch, textX - margin, textY - this.layout.height - margin, this.layout.width + margin * 2.0f, this.layout.height + margin * 2.0f, Color.BLACK);
            this.font.draw((Batch)batch, this.layout, textX, textY);
        }
        if (this.draggingActor == null) {
            if (!multiTouch || this.currentIcon == this.leaveIcon && Gdx.input.isTouched()) {
                if (this.currentIcon instanceof TransformDrawable) {
                    TransformDrawable i = (TransformDrawable)this.currentIcon;
                    i.draw((Batch)batch, this.mousepos.x - this.currentIcon.getMinWidth() / 2.0f, this.mousepos.y - this.currentIcon.getMinHeight() / 2.0f, this.currentIcon.getMinWidth() / 2.0f, this.currentIcon.getMinHeight() / 2.0f, this.currentIcon.getMinWidth(), this.currentIcon.getMinHeight(), this.pointerScale, this.pointerScale, this.currentIcon == this.leaveIcon ? this.leaveRotation : 0.0f);
                } else {
                    float width = this.currentIcon.getMinWidth() * this.pointerScale;
                    float height = this.currentIcon.getMinHeight() * this.pointerScale;
                    float x = this.mousepos.x - width / 2.0f;
                    float y = this.mousepos.y - height / 2.0f;
                    this.currentIcon.draw((Batch)batch, x, y, width, height);
                }
            }
        } else {
            float h = this.draggingActor.getHeight() > this.draggingActor.getWidth() ? this.draggingActor.getHeight() : this.draggingActor.getWidth();
            float size = DPIUtils.getTouchMinSize() / h * 1.8f;
            ActorRenderer r = this.draggingActor.getRenderer();
            r.draw(batch, this.mousepos.x, this.mousepos.y - this.draggingActor.getHeight() * size / 2.0f, size, size, 0.0f, this.currentIcon != this.hotspotIcon ? this.tmpTint : this.draggingActor.getTint());
        }
    }

    public void resize(int width, int height) {
        this.pointerScale = DPIUtils.getTouchMinSize() / this.pointerIcon.getMinHeight() * 0.8f;
    }
}

