/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.ui.defaults;

import com.bladecoder.engine.model.Text;
import com.bladecoder.engine.model.World;
import com.bladecoder.engine.model.WorldListener;
import com.bladecoder.engine.ui.ITextManagerUI;
import com.bladecoder.engine.ui.defaults.DefaultSceneScreen;

public class SceneWorldListener
implements WorldListener {
    private final DefaultSceneScreen dsc;

    public SceneWorldListener(DefaultSceneScreen dsc) {
        this.dsc = dsc;
    }

    @Override
    public void text(Text t) {
        if (t != null && t.type == Text.Type.UI) {
            this.dsc.showUIText(t);
        } else {
            ((ITextManagerUI)this.dsc.getTextManagerUI()).setText(t);
        }
    }

    @Override
    public void dialogOptions() {
        this.dsc.updateUI();
    }

    @Override
    public void cutMode(boolean value) {
        this.dsc.updateUI();
    }

    @Override
    public void inventoryEnabled(boolean value) {
        this.dsc.getInventoryUI().hide();
        this.dsc.getInventoryButton().setVisible(value);
    }

    @Override
    public void pause(boolean value) {
        if (this.dsc.getUI().getWorld().getAssetState() == World.AssetState.LOADED) {
            this.dsc.updateUI();
        }
    }
}

