/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.util;

import com.badlogic.gdx.files.FileHandle;
import com.bladecoder.engine.assets.EngineAssetManager;
import com.bladecoder.engine.util.EngineLogger;
import java.io.IOException;
import java.util.Properties;

public final class Config {
    public static final String INVENTORY_POS_PROP = "inventory_pos";
    public static final String INVENTORY_AUTOSIZE_PROP = "inventory_autosize";
    public static final String SINGLE_ACTION_INVENTORY = "single_action_inventory";
    public static final String TITLE_PROP = "title";
    public static final String LOAD_GAMESTATE_PROP = "load_gamestate";
    public static final String PLAY_RECORD_PROP = "play_recording";
    public static final String TEST_SCENE_PROP = "test_scene";
    public static final String FORCE_RES_PROP = "force_res";
    public static final String DEBUG_PROP = "debug";
    public static final String CHAPTER_PROP = "chapter";
    public static final String SHOW_DESC_PROP = "show_desc";
    public static final String EXTEND_VIEWPORT_PROP = "extend_viewport";
    public static final String VERSION_PROP = "version";
    public static final String BLADE_ENGINE_VERSION_PROP = "bladeEngineVersion";
    public static final String CHARACTER_ICON_ATLAS = "character_icon_atlas";
    public static final String UI_MODE = "ui_mode";
    public static final String FAST_LEAVE = "fast_leave";
    public static final String AUTO_HIDE_TEXTS = "auto_hide_texts";
    public static final String RESOLUTIONS = "resolutions";
    public static final String SHOW_HOTSPOTS = "show_hotspots";
    public static final String PROPERTIES_FILENAME = "BladeEngine.properties";
    public static final String PREFS_FILENAME = "prefs.properties";
    private static Config instance;
    private final Properties config = new Properties();
    private final Properties prefs = new Properties();

    private Config() {
        this.load();
    }

    public static final Config getInstance() {
        if (instance == null) {
            instance = new Config();
        }
        return instance;
    }

    public String getProperty(String key, String defaultValue) {
        return this.config.getProperty(key, defaultValue);
    }

    public void load() {
        try {
            this.config.load(EngineAssetManager.getInstance().getAsset(PROPERTIES_FILENAME).reader());
        }
        catch (Exception e) {
            EngineLogger.error("ERROR LOADING BladeEngine.properties :" + e.getMessage());
        }
        FileHandle prefsFile = EngineAssetManager.getInstance().getUserFile(PREFS_FILENAME, this.getProperty(TITLE_PROP, null));
        if (prefsFile.exists()) {
            try {
                this.prefs.load(prefsFile.reader());
            }
            catch (IOException e) {
                EngineLogger.error("ERROR LOADING PREFERENCES prefs.properties: " + e.getMessage());
            }
        }
    }

    public boolean getProperty(String key, boolean defaultValue) {
        boolean result = false;
        try {
            result = Boolean.parseBoolean(this.getProperty(key, String.valueOf(defaultValue)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public int getProperty(String key, int defaultValue) {
        int result = 0;
        try {
            result = Integer.parseInt(this.getProperty(key, String.valueOf(defaultValue)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public String getPref(String name, String defaultValue) {
        return this.prefs.getProperty(name, defaultValue);
    }

    public void setPref(String name, String value) {
        this.prefs.setProperty(name, value);
    }

    public void savePrefs() {
        try {
            this.prefs.store(EngineAssetManager.getInstance().getUserFile(PREFS_FILENAME, this.getProperty(TITLE_PROP, null)).writer(false), null);
        }
        catch (IOException e) {
            EngineLogger.error("ERROR SAVING PREFERENCES: " + e.getMessage());
        }
    }
}

