/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.util;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;

public final class RectangleRenderer {
    private static Texture texture;

    private static Texture makePixel() {
        Pixmap p = new Pixmap(1, 1, Pixmap.Format.RGBA8888);
        p.setColor(Color.WHITE);
        p.fillRectangle(0, 0, 1, 1);
        Texture _temp = new Texture(p, true);
        p.dispose();
        return _temp;
    }

    public static void draw(Batch batch, float posX, float posY, float width, float height, Color color) {
        if (texture == null) {
            texture = RectangleRenderer.makePixel();
        }
        float tmp = batch.getPackedColor();
        batch.setColor(color);
        batch.draw(texture, posX, posY, 0.0f, 0.0f, width, height, 1.0f, 1.0f, 0.0f, 0, 0, 1, 1, false, false);
        batch.setPackedColor(tmp);
    }

    public static void dispose() {
        if (texture != null) {
            texture.dispose();
        }
        texture = null;
    }
}

