/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine;

import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.utils.BufferUtils;
import com.bladecoder.engine.assets.EngineAssetManager;
import com.bladecoder.engine.model.World;
import com.bladecoder.engine.ui.UI;
import com.bladecoder.engine.util.Config;
import com.bladecoder.engine.util.DPIUtils;
import com.bladecoder.engine.util.EngineLogger;
import java.io.IOException;
import java.nio.IntBuffer;
import java.text.MessageFormat;

public class BladeEngine
implements ApplicationListener {
    private String chapter;
    private String gameState;
    private String testScene;
    private String recordName;
    private String forceRes;
    private boolean debug = false;
    private boolean restart = false;
    private UI ui;
    private World world;

    public static UI getAppUI() {
        return ((BladeEngine)Gdx.app.getApplicationListener()).getUI();
    }

    public void setTestMode(String s) {
        this.testScene = s;
    }

    public void loadGameState(String s) {
        this.gameState = s;
    }

    public void setPlayMode(String recordName) {
        this.recordName = recordName;
    }

    public void setDebugMode() {
        this.debug = true;
    }

    public void setRestart() {
        this.restart = true;
    }

    public void setChapter(String chapter) {
        this.chapter = chapter;
    }

    public void forceResolution(String forceRes) {
        this.forceRes = forceRes;
    }

    public UI getUI() {
        return this.ui;
    }

    public void loadGame(String baseFolder) {
        if (this.ui != null) {
            this.ui.dispose();
            this.world.dispose();
        }
        this.world = new World();
        EngineAssetManager.setAssetFolder(baseFolder);
        Config.getInstance().load();
        try {
            this.world.loadWorldDesc();
        }
        catch (Exception e) {
            EngineLogger.error("EXITING: " + e.getMessage());
            Gdx.app.exit();
        }
        this.ui = new UI(this.world);
    }

    public void create() {
        if (!this.debug) {
            this.debug = Config.getInstance().getProperty("debug", this.debug);
        }
        if (this.debug) {
            EngineLogger.setDebug();
        } else {
            EngineLogger.setDebugLevel(1);
        }
        EngineLogger.debug("GAME CREATE");
        if (this.forceRes == null) {
            this.forceRes = Config.getInstance().getProperty("force_res", this.forceRes);
        }
        if (this.forceRes != null) {
            EngineAssetManager.getInstance().forceResolution(this.forceRes);
        }
        this.loadGame(null);
        if (EngineLogger.debugMode()) {
            if (this.chapter == null) {
                this.chapter = Config.getInstance().getProperty("chapter", this.chapter);
            }
            if (this.testScene == null) {
                this.testScene = Config.getInstance().getProperty("test_scene", this.testScene);
            }
            if (this.testScene != null || this.chapter != null) {
                try {
                    this.world.loadChapter(this.chapter, this.testScene, true);
                }
                catch (Exception e) {
                    this.dispose();
                    EngineLogger.error("Error loading model:" + e.getMessage(), e);
                    Gdx.app.exit();
                }
                this.ui.setCurrentScreen(UI.Screens.SCENE_SCREEN);
            }
            if (this.gameState == null) {
                this.gameState = Config.getInstance().getProperty("load_gamestate", this.gameState);
            }
            if (this.gameState != null) {
                try {
                    this.world.loadGameState(this.gameState);
                }
                catch (IOException e) {
                    EngineLogger.error(e.getMessage());
                }
            }
            if (this.restart) {
                try {
                    this.world.getSerializer().loadChapter();
                    this.ui.setCurrentScreen(UI.Screens.SCENE_SCREEN);
                }
                catch (Exception e) {
                    EngineLogger.error("ERROR LOADING GAME", e);
                    this.dispose();
                    Gdx.app.exit();
                }
            }
            if (this.recordName == null) {
                this.recordName = Config.getInstance().getProperty("play_recording", this.recordName);
            }
            if (this.recordName != null) {
                this.ui.getRecorder().setFilename(this.recordName);
                this.ui.getRecorder().load();
                this.ui.getRecorder().setPlaying(true);
                this.ui.setCurrentScreen(UI.Screens.SCENE_SCREEN);
            }
        }
        IntBuffer size = BufferUtils.newIntBuffer((int)16);
        Gdx.gl.glGetIntegerv(3379, size);
        int maxSize = size.get();
        EngineLogger.debug("Max. texture Size: " + maxSize);
        EngineLogger.debug("Density: " + Gdx.graphics.getDensity());
        EngineLogger.debug("Dimensions: " + Gdx.graphics.getWidth() + "x" + Gdx.graphics.getHeight());
        EngineLogger.debug("Size Multiplier: " + DPIUtils.getSizeMultiplier());
    }

    public void dispose() {
        EngineLogger.debug("GAME DISPOSE");
        this.world.dispose();
        this.ui.dispose();
    }

    public void render() {
        this.ui.render();
        if (EngineLogger.lastError != null && EngineLogger.debugMode() && !this.world.isPaused()) {
            this.pause();
        }
    }

    public void resize(int width, int height) {
        EngineLogger.debug(MessageFormat.format("GAME RESIZE {0}x{1}", width, height));
        if (this.ui != null) {
            this.ui.resize(width, height);
        }
    }

    public void pause() {
        boolean bot = this.ui.getTesterBot().isEnabled();
        boolean r = this.ui.getRecorder().isPlaying();
        if (!(this.world.isDisposed() || (bot || r) && EngineLogger.lastError == null)) {
            EngineLogger.debug("GAME PAUSE");
            this.ui.pause();
            try {
                this.world.saveGameState();
            }
            catch (IOException e) {
                EngineLogger.error(e.getMessage());
            }
        } else {
            EngineLogger.debug("NOT PAUSING WHEN BOT IS RUNNING OR PLAYING RECORDED GAME");
        }
    }

    public void resume() {
        EngineLogger.debug("GAME RESUME");
        this.resize(Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        this.ui.resume();
    }
}

