/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.actions;

import com.bladecoder.engine.actions.Action;
import com.bladecoder.engine.actions.ActionDescription;
import com.bladecoder.engine.actions.ActionProperty;
import com.bladecoder.engine.actions.ActionPropertyDescription;
import com.bladecoder.engine.model.VerbRunner;
import com.bladecoder.engine.model.World;
import com.bladecoder.engine.util.EngineLogger;

@ActionDescription(value="Adds an integer value to the selected property.")
public class AddValueToProperty
implements Action {
    @ActionProperty(required=true)
    @ActionPropertyDescription(value="Property name")
    private String prop;
    @ActionProperty(required=true)
    @ActionPropertyDescription(value="The integer value to add.")
    private int value;
    private World w;

    @Override
    public void init(World w) {
        this.w = w;
    }

    @Override
    public boolean run(VerbRunner cb) {
        String p = this.w.getCustomProperty(this.prop);
        int v = 0;
        if (p != null) {
            try {
                v = Integer.parseInt(p);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.w.setCustomProperty(this.prop, Integer.toString(v += this.value));
        EngineLogger.debug("AddValueToProperty: " + this.prop + "=" + this.w.getCustomProperty(this.prop));
        return false;
    }
}

