/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.actions;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Disposable;
import com.bladecoder.engine.actions.Action;
import com.bladecoder.engine.actions.ActionDescription;
import com.bladecoder.engine.actions.ActionProperty;
import com.bladecoder.engine.actions.ActionPropertyDescription;
import com.bladecoder.engine.actions.Param;
import com.bladecoder.engine.assets.EngineAssetManager;
import com.bladecoder.engine.model.BaseActor;
import com.bladecoder.engine.model.Inventory;
import com.bladecoder.engine.model.Scene;
import com.bladecoder.engine.model.SpriteActor;
import com.bladecoder.engine.model.VerbRunner;
import com.bladecoder.engine.model.World;
import com.bladecoder.engine.util.EngineLogger;
import java.text.MessageFormat;

@ActionDescription(value="Drops the selected inventory actor.")
public class DropItemAction
implements Action {
    @ActionProperty
    @ActionPropertyDescription(value="The 'id' from the inventory item to remove. If empty remove all items.")
    private String actor;
    @ActionProperty(type=Param.Type.SCENE, required=false)
    @ActionPropertyDescription(value="The target scene. If not selected the item is dropped in the current scene.")
    private String scene = null;
    @ActionProperty
    @ActionPropertyDescription(value="Position in the scene where de actor is dropped")
    private Vector2 pos;
    @ActionProperty
    @ActionPropertyDescription(value="Inventory name. If empty, the active inventory is used.")
    private String inventory;
    private World w;

    @Override
    public void init(World w) {
        this.w = w;
    }

    @Override
    public boolean run(VerbRunner cb) {
        Scene ts = null;
        ts = this.scene == null ? this.w.getCurrentScene() : this.w.getScene(this.scene);
        Inventory inv = null;
        if (this.inventory == null) {
            inv = this.w.getInventory();
        } else {
            inv = this.w.getInventories().get(this.inventory);
            if (inv == null) {
                EngineLogger.error("Inventory not found: " + this.inventory);
                return false;
            }
        }
        if (this.actor != null) {
            SpriteActor a = inv.get(this.actor);
            if (a == null) {
                EngineLogger.error(MessageFormat.format("DropItemAction -  Item not found: {0}", this.actor));
                return false;
            }
            this.removeActor(inv, ts, a);
        } else {
            int n = inv.getNumItems();
            for (int i = n - 1; i >= 0; --i) {
                SpriteActor a = inv.get(i);
                this.removeActor(inv, ts, a);
            }
        }
        return false;
    }

    private void removeActor(Inventory inv, Scene ts, BaseActor a) {
        float scale = EngineAssetManager.getInstance().getScale();
        inv.removeItem(a.getId());
        if (ts != this.w.getCurrentScene() && this.w.getCachedScene(ts.getId()) == null && a instanceof Disposable) {
            ((Disposable)a).dispose();
        }
        ts.addActor(a);
        if (this.pos != null) {
            a.setPosition(this.pos.x * scale, this.pos.y * scale);
        }
    }
}

