/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.actions;

import com.bladecoder.engine.actions.AbstractIfAction;
import com.bladecoder.engine.actions.ActionDescription;
import com.bladecoder.engine.actions.ActionProperty;
import com.bladecoder.engine.actions.ActionPropertyDescription;
import com.bladecoder.engine.actions.SceneActorRef;
import com.bladecoder.engine.model.AnimationRenderer;
import com.bladecoder.engine.model.BaseActor;
import com.bladecoder.engine.model.InteractiveActor;
import com.bladecoder.engine.model.Inventory;
import com.bladecoder.engine.model.Scene;
import com.bladecoder.engine.model.SpriteActor;
import com.bladecoder.engine.model.VerbRunner;
import com.bladecoder.engine.model.World;
import com.bladecoder.engine.util.ActionUtils;
import com.bladecoder.engine.util.EngineLogger;
import com.bladecoder.engine.util.PolygonUtils;

@ActionDescription(name="IfActorAttr", value="Execute the actions inside the If/EndIf if the attribute has the specified value.")
public class IfAttrAction
extends AbstractIfAction {
    public static final String ENDTYPE_VALUE = "else";
    @ActionProperty(required=true)
    @ActionPropertyDescription(value="The target actor")
    private SceneActorRef actor;
    @ActionProperty(required=true, defaultValue="STATE")
    @ActionPropertyDescription(value="The actor attribute")
    private ActorAttribute attr;
    @ActionProperty
    @ActionPropertyDescription(value="The attribute value")
    private String value;
    private World w;

    @Override
    public void init(World w) {
        this.w = w;
    }

    @Override
    public boolean run(VerbRunner cb) {
        Scene s = this.actor.getScene(this.w);
        String actorId = this.actor.getActorId();
        if (this.attr.equals((Object)ActorAttribute.STATE)) {
            BaseActor a = s.getActor(actorId, true);
            if (!(a instanceof InteractiveActor)) {
                EngineLogger.error(this.getClass() + "- Actor not found: " + actorId);
                return false;
            }
            InteractiveActor ia = (InteractiveActor)a;
            if (!ActionUtils.compareNullStr(this.value, ia.getState())) {
                this.gotoElse(cb);
            }
        } else if (this.attr.equals((Object)ActorAttribute.VISIBLE)) {
            BaseActor a = s.getActor(actorId, true);
            if (a == null) {
                EngineLogger.error(this.getClass() + "- Actor not found: " + actorId);
                return false;
            }
            boolean val = Boolean.parseBoolean(this.value);
            if (val != a.isVisible()) {
                this.gotoElse(cb);
            }
        } else if (this.attr.equals((Object)ActorAttribute.INTERACTIVE)) {
            BaseActor a = s.getActor(actorId, true);
            if (a == null) {
                EngineLogger.error(this.getClass() + "- Actor not found: " + actorId);
                return false;
            }
            boolean val = Boolean.parseBoolean(this.value);
            if (a instanceof InteractiveActor) {
                if (val != ((InteractiveActor)a).getInteraction()) {
                    this.gotoElse(cb);
                }
            } else if (val) {
                this.gotoElse(cb);
            }
        } else if (this.attr.equals((Object)ActorAttribute.IN_INVENTORY)) {
            Inventory inventory = null;
            boolean val = true;
            if (this.value != null) {
                inventory = this.w.getInventories().get(this.value);
            }
            if (inventory == null) {
                val = Boolean.parseBoolean(this.value);
                inventory = this.w.getInventory();
            }
            SpriteActor item = null;
            item = inventory.get(actorId);
            if (val && item == null || !val && item != null) {
                this.gotoElse(cb);
            }
        } else if (this.attr.equals((Object)ActorAttribute.TARGET)) {
            if (!ActionUtils.compareNullStr(this.value, cb.getCurrentTarget())) {
                this.gotoElse(cb);
            }
        } else if (this.attr.equals((Object)ActorAttribute.IN_SCENE)) {
            boolean val = Boolean.parseBoolean(this.value);
            BaseActor a2 = s.getActor(actorId, false);
            if (val && a2 == null || !val && a2 != null) {
                this.gotoElse(cb);
            }
        } else if (this.attr.equals((Object)ActorAttribute.IN_UI)) {
            boolean val = Boolean.parseBoolean(this.value);
            InteractiveActor a2 = this.w.getUIActors().get(actorId);
            if (val && a2 == null || !val && a2 != null) {
                this.gotoElse(cb);
            }
        } else if (this.attr.equals((Object)ActorAttribute.LAYER)) {
            BaseActor a = s.getActor(actorId, true);
            if (!(a instanceof InteractiveActor)) {
                EngineLogger.error(this.getClass() + "- No not found: " + actorId);
                return false;
            }
            InteractiveActor ia = (InteractiveActor)a;
            if (!ActionUtils.compareNullStr(this.value, ia.getLayer())) {
                this.gotoElse(cb);
            }
        } else if (this.attr.equals((Object)ActorAttribute.DIRECTION)) {
            BaseActor a = s.getActor(actorId, true);
            if (!(a instanceof SpriteActor)) {
                EngineLogger.error(this.getClass() + "- No not found: " + actorId);
                return false;
            }
            SpriteActor sa = (SpriteActor)a;
            if (sa.getRenderer() instanceof AnimationRenderer) {
                String dir = null;
                String anim = ((AnimationRenderer)sa.getRenderer()).getCurrentAnimationId();
                int idx = anim.lastIndexOf(46);
                if (idx != -1) {
                    dir = anim.substring(idx + 1);
                }
                if (!ActionUtils.compareNullStr(this.value, dir)) {
                    this.gotoElse(cb);
                }
            }
        } else if (this.attr.equals((Object)ActorAttribute.INSIDE)) {
            BaseActor a = s.getActor(actorId, true);
            if (a == null) {
                EngineLogger.error(this.getClass() + "- No not found: " + actorId);
                return false;
            }
            BaseActor insideActor = this.w.getCurrentScene().getActor(this.value, false);
            if (insideActor == null) {
                EngineLogger.debug("Actor for inside test not found: " + this.value);
                this.gotoElse(cb);
                return false;
            }
            boolean inside = PolygonUtils.isPointInside(insideActor.getBBox(), a.getX(), a.getY(), true);
            if (!inside) {
                this.gotoElse(cb);
            }
        }
        return false;
    }

    public static enum ActorAttribute {
        STATE,
        VISIBLE,
        INTERACTIVE,
        IN_INVENTORY,
        TARGET,
        IN_SCENE,
        LAYER,
        DIRECTION,
        IN_UI,
        INSIDE;

    }
}

