/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.actions;

import com.bladecoder.engine.actions.Action;
import com.bladecoder.engine.actions.ActionDescription;
import com.bladecoder.engine.actions.ActionProperty;
import com.bladecoder.engine.actions.ActionPropertyDescription;
import com.bladecoder.engine.ink.InkVerbRunner;
import com.bladecoder.engine.model.VerbRunner;
import com.bladecoder.engine.model.World;
import com.bladecoder.engine.util.EngineLogger;

@ActionDescription(value="Stops the selected Ink flow.")
public class InkCancelAction
implements Action {
    @ActionPropertyDescription(value="The conversation flow. Empty for the default flow.")
    @ActionProperty(required=false)
    private String flow;
    private World w;

    @Override
    public void init(World w) {
        this.w = w;
    }

    @Override
    public boolean run(VerbRunner cb) {
        try {
            InkVerbRunner inkVerbRunner;
            if (this.flow == null) {
                inkVerbRunner = this.w.getInkManager().getDefaultVerbRunner();
                this.w.getInkManager().getStory().switchToDefaultFlow();
            } else {
                inkVerbRunner = this.w.getInkManager().getVerbRunners().get(this.flow);
                if (inkVerbRunner == null) {
                    EngineLogger.debug("Flow not found: " + this.flow);
                    return false;
                }
                this.w.getInkManager().getStory().switchFlow(this.flow);
            }
            inkVerbRunner.cancel();
            this.w.getInkManager().getStory().resetCallstack();
        }
        catch (Exception e) {
            EngineLogger.error("Error cancelling flow: " + this.flow == null ? "DEFAULT" : this.flow);
        }
        return false;
    }
}

