/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.actions;

import com.bladecoder.engine.actions.Action;
import com.bladecoder.engine.actions.ActionDescription;
import com.bladecoder.engine.actions.ActionProperty;
import com.bladecoder.engine.actions.ActionPropertyDescription;
import com.bladecoder.engine.model.VerbRunner;
import com.bladecoder.engine.model.World;
import com.bladecoder.engine.util.EngineLogger;

@ActionDescription(value="Jump an Ink knot or stich.")
public class InkRunAction
implements Action {
    @ActionPropertyDescription(value="The knot/stich/function path to jump. Ej: 'myKnotName' or 'myKnotName.theStitchWithin'")
    @ActionProperty(required=true)
    private String path;
    @ActionPropertyDescription(value="List of params (comma separated) for the path. Use the % prefix for numbers.")
    @ActionProperty(required=false)
    private String params;
    @ActionPropertyDescription(value="The conversation flow. Empty selects the default flow.")
    @ActionProperty(required=false)
    private String flow;
    @ActionProperty(required=true)
    @ActionPropertyDescription(value="Waits for the action to finish.")
    private boolean wait = true;
    private World w;

    @Override
    public void init(World w) {
        this.w = w;
    }

    @Override
    public boolean run(VerbRunner cb) {
        try {
            Object[] p = null;
            if (this.params != null && !this.params.trim().isEmpty()) {
                String[] split = this.params.split(",");
                p = new Object[split.length];
                for (int i = 0; i < split.length; ++i) {
                    String v = split[i].trim();
                    Object val = v;
                    if (v.charAt(0) == '%') {
                        try {
                            val = Integer.parseInt(v.substring(1));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    p[i] = val;
                }
            }
            this.w.getInkManager().runPath(this.path, p, this.flow, this.wait ? cb : null);
        }
        catch (Exception e) {
            EngineLogger.error("Cannot jump to: " + this.path + " " + e.getMessage());
        }
        return this.wait;
    }
}

