/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.actions;

import com.badlogic.gdx.utils.Disposable;
import com.bladecoder.engine.actions.Action;
import com.bladecoder.engine.actions.ActionDescription;
import com.bladecoder.engine.actions.ActionProperty;
import com.bladecoder.engine.actions.ActionPropertyDescription;
import com.bladecoder.engine.actions.Param;
import com.bladecoder.engine.actions.SceneActorRef;
import com.bladecoder.engine.assets.AssetConsumer;
import com.bladecoder.engine.assets.EngineAssetManager;
import com.bladecoder.engine.model.BaseActor;
import com.bladecoder.engine.model.Scene;
import com.bladecoder.engine.model.VerbRunner;
import com.bladecoder.engine.model.World;
import com.bladecoder.engine.util.EngineLogger;

@ActionDescription(value="Move the actor to the selected scene")
public class MoveToSceneAction
implements Action {
    @ActionProperty(required=true)
    @ActionPropertyDescription(value="The selected actor")
    private SceneActorRef actor;
    @ActionPropertyDescription(value="The target scene. The current scene if empty.")
    @ActionProperty(type=Param.Type.SCENE)
    private String scene;
    private World w;

    @Override
    public void init(World w) {
        this.w = w;
    }

    @Override
    public boolean run(VerbRunner cb) {
        Scene s = this.actor.getScene(this.w);
        String actorId = this.actor.getActorId();
        if (actorId == null) {
            EngineLogger.error(this.getClass() + ": No actor specified");
            return false;
        }
        BaseActor a = s.getActor(actorId, false);
        if (a == null) {
            EngineLogger.error(this.getClass() + "- Actor not found: " + actorId + " in scene: " + s.getId());
            return false;
        }
        s.removeActor(a);
        Scene ts = null;
        ts = this.scene == null ? this.w.getCurrentScene() : this.w.getScene(this.scene);
        if ((s == this.w.getCurrentScene() || this.w.getCachedScene(ts.getId()) != null) && ts != this.w.getCurrentScene() && this.w.getCachedScene(ts.getId()) == null && a instanceof Disposable) {
            ((Disposable)a).dispose();
        }
        if ((ts == this.w.getCurrentScene() || this.w.getCachedScene(ts.getId()) != null) && s != this.w.getCurrentScene() && this.w.getCachedScene(s.getId()) == null && a instanceof AssetConsumer) {
            ((AssetConsumer)((Object)a)).loadAssets();
            EngineAssetManager.getInstance().finishLoading();
            ((AssetConsumer)((Object)a)).retrieveAssets();
        }
        ts.addActor(a);
        return false;
    }
}

