/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.actions;

import com.bladecoder.engine.actions.Action;
import com.bladecoder.engine.actions.ActionDescription;
import com.bladecoder.engine.actions.ActionProperty;
import com.bladecoder.engine.actions.ActionPropertyDescription;
import com.bladecoder.engine.model.MusicDesc;
import com.bladecoder.engine.model.MusicManager;
import com.bladecoder.engine.model.VerbRunner;
import com.bladecoder.engine.model.World;

@ActionDescription(value="Plays/Stops music.")
public class MusicAction
implements Action {
    @ActionProperty
    @ActionPropertyDescription(value="The music filename to play. If empty, the current music will be stopped.")
    private String filename;
    @ActionProperty(required=true, defaultValue="false")
    @ActionPropertyDescription(value="Music Loop")
    private boolean loop = false;
    @ActionProperty(required=true, defaultValue="0")
    @ActionPropertyDescription(value="The music starts to play after the delay.")
    private float initialDelay = 0.0f;
    @ActionProperty(required=true, defaultValue="-1")
    @ActionPropertyDescription(value="Time for repeating the music when no looping. -1 for no repeat.")
    private float repeatDelay = -1.0f;
    @ActionProperty(required=true, defaultValue="true")
    @ActionPropertyDescription(value="Stops the music when leaving the current scene.")
    private boolean stopWhenLeaving = true;
    @ActionProperty(required=true, defaultValue="1.0")
    @ActionPropertyDescription(value="Volume of the music [0-1].")
    private float volume = 1.0f;
    private World w;

    @Override
    public void init(World w) {
        this.w = w;
    }

    @Override
    public boolean run(VerbRunner cb) {
        MusicManager musicEngine = this.w.getMusicManager();
        if (this.filename == null) {
            musicEngine.setMusic(null);
        } else {
            MusicDesc md = new MusicDesc();
            md.setFilename(this.filename);
            md.setLoop(this.loop);
            md.setInitialDelay(this.initialDelay);
            md.setRepeatDelay(this.repeatDelay);
            md.setStopWhenLeaving(this.stopWhenLeaving);
            md.setVolume(this.volume);
            musicEngine.setMusic(md);
        }
        return false;
    }
}

