/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.actions;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.viewport.Viewport;
import com.bladecoder.engine.BladeEngine;
import com.bladecoder.engine.actions.Action;
import com.bladecoder.engine.actions.ActionDescription;
import com.bladecoder.engine.actions.ActionProperty;
import com.bladecoder.engine.actions.ActionPropertyDescription;
import com.bladecoder.engine.actions.SceneActorRef;
import com.bladecoder.engine.assets.EngineAssetManager;
import com.bladecoder.engine.model.BaseActor;
import com.bladecoder.engine.model.Scene;
import com.bladecoder.engine.model.VerbRunner;
import com.bladecoder.engine.model.World;
import com.bladecoder.engine.ui.SceneScreen;
import com.bladecoder.engine.ui.UI;

@ActionDescription(value="Sets actor position in screen coordinates. This is used to show an actor in the same screen position when the scene has scrolled.")
public class ScreenPositionAction
implements Action {
    @ActionProperty(required=true)
    @ActionPropertyDescription(value="The target actor")
    private SceneActorRef actor;
    @ActionProperty(required=true)
    @ActionPropertyDescription(value="The position to set")
    private Vector2 position;
    @ActionProperty(defaultValue="NONE")
    @ActionPropertyDescription(value="The position can be relative to an anchor.")
    private Anchor anchor = Anchor.NONE;
    private World w;

    @Override
    public void init(World w) {
        this.w = w;
    }

    @Override
    public boolean run(VerbRunner cb) {
        Scene s = this.actor.getScene(this.w);
        BaseActor a = s.getActor(this.actor.getActorId(), true);
        if (this.position != null) {
            float scale = EngineAssetManager.getInstance().getScale();
            Viewport viewport = ((SceneScreen)BladeEngine.getAppUI().getScreen(UI.Screens.SCENE_SCREEN)).getViewport();
            Vector3 v = new Vector3(this.position.x * scale, this.position.y * scale, 0.0f);
            if (this.anchor == Anchor.CENTER) {
                v.x += viewport.getWorldWidth() / 2.0f;
                v.y += viewport.getWorldHeight() / 2.0f;
            } else if (this.anchor == Anchor.TOP_LEFT) {
                v.x += 0.0f;
                v.y += viewport.getWorldHeight();
            } else if (this.anchor == Anchor.TOP_RIGHT) {
                v.x += viewport.getWorldWidth();
                v.y += viewport.getWorldHeight();
            } else if (this.anchor == Anchor.BOTTOM_RIGHT) {
                v.x += viewport.getWorldWidth();
                v.y += 0.0f;
            } else if (this.anchor == Anchor.BOTTOM_LEFT) {
                v.x += 0.0f;
                v.y += 0.0f;
            } else if (this.anchor == Anchor.TOP) {
                v.x += viewport.getWorldWidth() / 2.0f;
                v.y += viewport.getWorldHeight();
            } else if (this.anchor == Anchor.BOTTOM) {
                v.x += viewport.getWorldWidth() / 2.0f;
                v.y += 0.0f;
            } else if (this.anchor == Anchor.LEFT) {
                v.x += 0.0f;
                v.y += viewport.getWorldHeight() / 2.0f;
            } else if (this.anchor == Anchor.RIGHT) {
                v.x += viewport.getWorldWidth();
                v.y += viewport.getWorldHeight() / 2.0f;
            }
            v.x *= (float)viewport.getScreenWidth() / viewport.getWorldWidth();
            v.y *= (float)viewport.getScreenHeight() / viewport.getWorldHeight();
            v.y = (float)Gdx.graphics.getHeight() - v.y;
            if (this.w.getUIActors().getActors().contains(a)) {
                this.w.getUIActors().getCamera().unproject(v, 0.0f, 0.0f, (float)viewport.getScreenWidth(), (float)viewport.getScreenHeight());
            } else {
                this.w.getCurrentScene().getCamera().unproject(v, 0.0f, 0.0f, viewport.getScreenWidth(), viewport.getScreenHeight());
            }
            a.setPosition(v.x, v.y);
        }
        return false;
    }

    public static enum Anchor {
        NONE,
        CENTER,
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT,
        TOP,
        BOTTOM,
        LEFT,
        RIGHT;

    }
}

