/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.actions;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Disposable;
import com.bladecoder.engine.actions.Action;
import com.bladecoder.engine.actions.ActionDescription;
import com.bladecoder.engine.actions.ActionProperty;
import com.bladecoder.engine.actions.ActionPropertyDescription;
import com.bladecoder.engine.actions.Param;
import com.bladecoder.engine.actions.SceneActorRef;
import com.bladecoder.engine.assets.AssetConsumer;
import com.bladecoder.engine.assets.EngineAssetManager;
import com.bladecoder.engine.model.BaseActor;
import com.bladecoder.engine.model.CharacterActor;
import com.bladecoder.engine.model.InteractiveActor;
import com.bladecoder.engine.model.Scene;
import com.bladecoder.engine.model.SceneLayer;
import com.bladecoder.engine.model.SpriteActor;
import com.bladecoder.engine.model.VerbRunner;
import com.bladecoder.engine.model.World;
import com.bladecoder.engine.util.EngineLogger;

@ActionDescription(value="Change actor attributes.")
public class SetActorAttrAction
implements Action {
    @ActionProperty(required=true)
    @ActionPropertyDescription(value="The target actor")
    private SceneActorRef actor;
    @ActionProperty
    @ActionPropertyDescription(value="Sets the actor visibility")
    private Boolean visible;
    @ActionProperty
    @ActionPropertyDescription(value="When 'true' the actor responds to the user input")
    private Boolean interaction;
    @ActionPropertyDescription(value="The actor layer")
    @ActionProperty(type=Param.Type.LAYER)
    private String layer;
    @ActionProperty
    @ActionPropertyDescription(value="The order to draw bigger is near")
    private Float zIndex;
    @ActionProperty
    @ActionPropertyDescription(value="Enable/Disable the Fake Depth for the actor")
    private Boolean fakeDepth;
    @ActionProperty
    @ActionPropertyDescription(value="Sets the actor scale proportionally")
    private Float scale;
    @ActionProperty
    @ActionPropertyDescription(value="Sets the actor scale non proportionally")
    private Vector2 scaleXY;
    @ActionProperty
    @ActionPropertyDescription(value="Sets the actor rotation")
    private Float rotation;
    @ActionPropertyDescription(value="The tint to draw the actor (RRGGBBAA).")
    @ActionProperty(type=Param.Type.COLOR)
    private Color tint;
    @ActionProperty
    @ActionPropertyDescription(value="Sets the actor as an UI Actor. UI actors persists between scenes and are not affected by the scroll.")
    private Boolean uiActor;
    @ActionProperty
    @ActionPropertyDescription(value="Sets the actor 'stand' animation. Only supported for character actors.")
    private String standAnimation;
    @ActionProperty
    @ActionPropertyDescription(value="Sets the actor 'walk' animation. Only supported for character actors.")
    private String walkAnimation;
    @ActionProperty
    @ActionPropertyDescription(value="Sets the actor 'talk' animation. Only supported for character actors.")
    private String talkAnimation;
    @ActionProperty
    @ActionPropertyDescription(value="Sets the actor speed for walking. Only supported for character actors.")
    private Float walkingSpeed;
    @ActionProperty
    @ActionPropertyDescription(value="Sets the position of the text when talking. Relative to the character position.")
    private Vector2 talkingTextPos;
    private World w;

    @Override
    public void init(World w) {
        this.w = w;
    }

    @Override
    public boolean run(VerbRunner cb) {
        InteractiveActor iActor;
        Scene s = this.actor.getScene(this.w);
        BaseActor a = s.getActor(this.actor.getActorId(), true);
        if (a == null) {
            EngineLogger.error("SetActorAttr - Actor not found:" + this.actor.getActorId());
            return false;
        }
        if (this.visible != null) {
            a.setVisible(this.visible);
        }
        if (this.interaction != null) {
            if (a instanceof InteractiveActor) {
                ((InteractiveActor)a).setInteraction(this.interaction);
            } else {
                EngineLogger.error("'Interaction' property not supported for actor:" + a.getId());
            }
        }
        if (this.layer != null) {
            if (a instanceof InteractiveActor) {
                iActor = (InteractiveActor)a;
                String oldLayer = iActor.getLayer();
                s.getLayer(oldLayer).remove(iActor);
                iActor.setLayer(this.layer);
                SceneLayer l = s.getLayer(this.layer);
                l.add(iActor);
                if (!l.isDynamic()) {
                    l.orderByZIndex();
                }
            } else {
                EngineLogger.error("'layer' property not supported for actor:" + a.getId());
            }
        }
        if (this.zIndex != null) {
            if (a instanceof InteractiveActor) {
                iActor = (InteractiveActor)a;
                iActor.setZIndex(this.zIndex.floatValue());
                SceneLayer l = s.getLayer(iActor.getLayer());
                if (!l.isDynamic()) {
                    l.orderByZIndex();
                }
            } else {
                EngineLogger.error("'zIndex' property not supported for actor:" + a.getId());
            }
        }
        if (this.scale != null) {
            if (a instanceof SpriteActor) {
                ((SpriteActor)a).setScale(this.scale.floatValue());
            } else {
                EngineLogger.error("'scale' property not supported for actor:" + a.getId());
            }
        }
        if (this.scaleXY != null) {
            if (a instanceof SpriteActor) {
                ((SpriteActor)a).setScale(this.scaleXY.x, this.scaleXY.y);
            } else {
                EngineLogger.error("'scale' property not supported for actor:" + a.getId());
            }
        }
        if (this.rotation != null) {
            if (a instanceof SpriteActor) {
                ((SpriteActor)a).setRot(this.rotation.floatValue());
            } else {
                EngineLogger.error("'rotation' property not supported for actor:" + a.getId());
            }
        }
        if (this.tint != null) {
            if (a instanceof SpriteActor) {
                ((SpriteActor)a).setTint(this.tint.cpy());
            } else {
                EngineLogger.error("'tint' property not supported for actor:" + a.getId());
            }
        }
        if (this.fakeDepth != null) {
            if (a instanceof SpriteActor) {
                ((SpriteActor)a).setFakeDepth(this.fakeDepth);
            } else {
                EngineLogger.error("'fakeDepth' property not supported for actor:" + a.getId());
            }
        }
        if (this.standAnimation != null) {
            if (a instanceof CharacterActor) {
                ((CharacterActor)a).setStandAnim(this.standAnimation);
            } else {
                EngineLogger.error("'standAnimation' property not supported for actor:" + a.getId());
            }
        }
        if (this.walkAnimation != null) {
            if (a instanceof CharacterActor) {
                ((CharacterActor)a).setWalkAnim(this.walkAnimation);
            } else {
                EngineLogger.error("'walkAnimation' property not supported for actor:" + a.getId());
            }
        }
        if (this.talkAnimation != null) {
            if (a instanceof CharacterActor) {
                ((CharacterActor)a).setTalkAnim(this.talkAnimation);
            } else {
                EngineLogger.error("'talkAnimation' property not supported for actor:" + a.getId());
            }
        }
        if (this.walkingSpeed != null) {
            if (a instanceof CharacterActor) {
                ((CharacterActor)a).setWalkingSpeed(this.walkingSpeed.floatValue());
            } else {
                EngineLogger.error("'walkingSpeed' property not supported for actor:" + a.getId());
            }
        }
        if (this.uiActor != null) {
            if (a instanceof InteractiveActor) {
                if (this.uiActor.booleanValue()) {
                    this.setUIActor(s, (InteractiveActor)a);
                } else {
                    this.removeUIActor(s, (InteractiveActor)a);
                }
            } else {
                EngineLogger.error("'uiActor' property not supported for actor:" + a.getId());
            }
        }
        if (this.talkingTextPos != null) {
            if (a instanceof CharacterActor) {
                ((CharacterActor)a).setTalkingTextPos(this.talkingTextPos);
            } else {
                EngineLogger.error("'talkingTextPos' property not supported for actor:" + a.getId());
            }
        }
        return false;
    }

    private void setUIActor(Scene scn, InteractiveActor actor) {
        scn.removeActor(actor);
        if (scn != this.w.getCurrentScene() && this.w.getCachedScene(scn.getId()) == null && actor instanceof AssetConsumer) {
            ((AssetConsumer)((Object)actor)).loadAssets();
            EngineAssetManager.getInstance().finishLoading();
            ((AssetConsumer)((Object)actor)).retrieveAssets();
        }
        this.w.getUIActors().addActor(actor);
    }

    private void removeUIActor(Scene scn, InteractiveActor actor) {
        InteractiveActor a = this.w.getUIActors().removeActor(actor.getId());
        if (a != null) {
            if (scn != this.w.getCurrentScene() && a instanceof Disposable) {
                ((Disposable)a).dispose();
            }
            scn.addActor(a);
        } else {
            EngineLogger.debug("UIActor not found: " + actor.getId());
        }
    }
}

