/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.actions;

import com.bladecoder.engine.actions.Action;
import com.bladecoder.engine.actions.ActionDescription;
import com.bladecoder.engine.actions.ActionProperty;
import com.bladecoder.engine.actions.ActionPropertyDescription;
import com.bladecoder.engine.actions.Param;
import com.bladecoder.engine.actions.SceneActorRef;
import com.bladecoder.engine.assets.EngineAssetManager;
import com.bladecoder.engine.model.BaseActor;
import com.bladecoder.engine.model.CharacterActor;
import com.bladecoder.engine.model.Inventory;
import com.bladecoder.engine.model.Scene;
import com.bladecoder.engine.model.VerbRunner;
import com.bladecoder.engine.model.World;

@ActionDescription(value="Sets the scene player")
public class SetPlayerAction
implements Action {
    @ActionProperty(type=Param.Type.SCENE_CHARACTER_ACTOR)
    @ActionPropertyDescription(value="The scene player")
    private SceneActorRef actor;
    @ActionProperty
    @ActionPropertyDescription(value="The inventory 'id' for the player. If empty, the inventory will not change.")
    private String inventory;
    private World w;

    @Override
    public void init(World w) {
        this.w = w;
    }

    @Override
    public boolean run(VerbRunner cb) {
        Scene s = this.actor == null ? this.w.getCurrentScene() : this.actor.getScene(this.w);
        BaseActor a = this.actor == null || this.actor.getActorId() == null ? null : s.getActor(this.actor.getActorId(), true);
        s.setPlayer((CharacterActor)a);
        if (this.inventory != null && !this.inventory.equals(this.w.getCurrentInventory())) {
            Inventory old = this.w.getInventory();
            this.w.setInventory(this.inventory);
            this.w.getInventory().loadAssets();
            EngineAssetManager.getInstance().finishLoading();
            this.w.getInventory().retrieveAssets();
            old.dispose();
        }
        return false;
    }
}

