/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.actions;

import com.bladecoder.engine.actions.Action;
import com.bladecoder.engine.actions.ActionDescription;
import com.bladecoder.engine.actions.ActionProperty;
import com.bladecoder.engine.actions.ActionPropertyDescription;
import com.bladecoder.engine.actions.Param;
import com.bladecoder.engine.actions.SceneActorRef;
import com.bladecoder.engine.model.Scene;
import com.bladecoder.engine.model.VerbRunner;
import com.bladecoder.engine.model.World;

@ActionDescription(name="SetWalkzone", value="Set the scene walkzone.")
public class SetWalkzoneAction
implements Action {
    @ActionProperty(type=Param.Type.SCENE_WALKZONE_ACTOR, required=false)
    @ActionPropertyDescription(value="The target actor")
    private SceneActorRef actor;
    private World w;

    @Override
    public void init(World w) {
        this.w = w;
    }

    @Override
    public boolean run(VerbRunner cb) {
        if (this.actor == null) {
            this.w.getCurrentScene().setWalkZone(null);
        } else {
            Scene s = this.actor.getScene(this.w);
            s.setWalkZone(this.actor.getActorId());
            if (s == this.w.getCurrentScene() || this.w.getCachedScene(s.getId()) != null) {
                s.calcWalkzone();
            }
        }
        return false;
    }
}

