/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.actions;

import com.badlogic.gdx.graphics.Color;
import com.bladecoder.engine.actions.Action;
import com.bladecoder.engine.actions.ActionDescription;
import com.bladecoder.engine.actions.ActionProperty;
import com.bladecoder.engine.actions.ActionPropertyDescription;
import com.bladecoder.engine.actions.Param;
import com.bladecoder.engine.anim.SpriteTintTween;
import com.bladecoder.engine.anim.Tween;
import com.bladecoder.engine.model.SpriteActor;
import com.bladecoder.engine.model.VerbRunner;
import com.bladecoder.engine.model.World;
import com.bladecoder.engine.util.InterpolationMode;

@ActionDescription(value="Sets an actor Color animation")
public class TintAnimAction
implements Action {
    @ActionPropertyDescription(value="The target actor")
    @ActionProperty(type=Param.Type.SPRITE_ACTOR, required=true)
    private String actor;
    @ActionProperty(type=Param.Type.COLOR, required=true)
    @ActionPropertyDescription(value="The target color (RRGGBBAA).")
    private Color color;
    @ActionProperty(required=true, defaultValue="1.0")
    @ActionPropertyDescription(value="Duration of the animation in seconds")
    private float speed;
    @ActionProperty
    @ActionPropertyDescription(value="The The times to repeat")
    private int count = 1;
    @ActionProperty(required=true)
    @ActionPropertyDescription(value="If this param is 'false' the transition is showed and the action continues inmediatly")
    private boolean wait = true;
    @ActionProperty(required=true, defaultValue="NO_REPEAT")
    @ActionPropertyDescription(value="The repeat mode")
    private Tween.Type repeat = Tween.Type.NO_REPEAT;
    @ActionProperty
    @ActionPropertyDescription(value="The interpolation mode")
    private InterpolationMode interpolation;
    private World w;

    @Override
    public void init(World w) {
        this.w = w;
    }

    @Override
    public boolean run(VerbRunner cb) {
        SpriteActor a = (SpriteActor)this.w.getCurrentScene().getActor(this.actor, true);
        SpriteTintTween t = new SpriteTintTween();
        t.start(a, this.repeat, this.count, this.color, this.speed, this.interpolation, this.wait ? cb : null);
        a.addTween(t);
        return this.wait;
    }
}

