/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.anim;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.bladecoder.engine.actions.ActionCallback;
import com.bladecoder.engine.anim.Tween;
import com.bladecoder.engine.model.SceneCamera;
import com.bladecoder.engine.util.InterpolationMode;

public class CameraTween
extends Tween<SceneCamera> {
    private float startX;
    private float startY;
    private float startZoom;
    private float targetX;
    private float targetY;
    private float targetZoom;

    public void start(SceneCamera camera, Tween.Type repeatType, int count, float targetX, float targetY, float targetZoom, float duration, InterpolationMode interpolation, ActionCallback cb) {
        this.target = camera;
        Vector2 currentPos = camera.getPosition();
        this.startX = currentPos.x;
        this.startY = currentPos.y;
        this.startZoom = camera.getZoom();
        this.targetX = targetX;
        this.targetY = targetY;
        this.targetZoom = targetZoom;
        this.setDuration(duration);
        this.setType(repeatType);
        this.setCount(count);
        this.setInterpolation(interpolation);
        if (cb != null) {
            this.setCb(cb);
        }
    }

    @Override
    public void updateTarget() {
        ((SceneCamera)((Object)this.target)).setZoom(this.startZoom + this.getPercent() * (this.targetZoom - this.startZoom));
        ((SceneCamera)((Object)this.target)).setPosition(this.startX + this.getPercent() * (this.targetX - this.startX), this.startY + this.getPercent() * (this.targetY - this.startY));
    }

    @Override
    public void write(Json json) {
        super.write(json);
        json.writeValue("startX", (Object)Float.valueOf(this.startX));
        json.writeValue("startY", (Object)Float.valueOf(this.startY));
        json.writeValue("startZoom", (Object)Float.valueOf(this.startZoom));
        json.writeValue("targetX", (Object)Float.valueOf(this.targetX));
        json.writeValue("targetY", (Object)Float.valueOf(this.targetY));
        json.writeValue("targetZoom", (Object)Float.valueOf(this.targetZoom));
    }

    @Override
    public void read(Json json, JsonValue jsonData) {
        super.read(json, jsonData);
        this.startX = ((Float)json.readValue("startX", Float.class, jsonData)).floatValue();
        this.startY = ((Float)json.readValue("startY", Float.class, jsonData)).floatValue();
        this.startZoom = ((Float)json.readValue("startZoom", Float.class, jsonData)).floatValue();
        this.targetX = ((Float)json.readValue("targetX", Float.class, jsonData)).floatValue();
        this.targetY = ((Float)json.readValue("targetY", Float.class, jsonData)).floatValue();
        this.targetZoom = ((Float)json.readValue("targetZoom", Float.class, jsonData)).floatValue();
    }
}

