/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.anim;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.bladecoder.engine.actions.ActionCallback;
import com.bladecoder.engine.anim.Tween;
import com.bladecoder.engine.model.SpriteActor;
import com.bladecoder.engine.util.InterpolationMode;

public class SpriteAlphaTween
extends Tween<SpriteActor> {
    private float startAlpha;
    private float targetAlpha;

    public void start(SpriteActor target, Tween.Type repeatType, int count, float tAlpha, float duration, InterpolationMode interpolation, ActionCallback cb) {
        this.setTarget(target);
        if (target.getTint() == null) {
            target.setTint(Color.WHITE.cpy());
        } else {
            target.setTint(target.getTint());
        }
        this.startAlpha = target.getTint().a;
        this.targetAlpha = tAlpha;
        this.setDuration(duration);
        this.setType(repeatType);
        this.setCount(count);
        this.setInterpolation(interpolation);
        if (cb != null) {
            this.setCb(cb);
        }
        this.restart();
    }

    @Override
    public void updateTarget() {
        ((SpriteActor)this.target).getTint().a = this.startAlpha + this.getPercent() * (this.targetAlpha - this.startAlpha);
    }

    @Override
    public void write(Json json) {
        super.write(json);
        json.writeValue("startAlpha", (Object)Float.valueOf(this.startAlpha));
        json.writeValue("targetAlpha", (Object)Float.valueOf(this.targetAlpha));
    }

    @Override
    public void read(Json json, JsonValue jsonData) {
        super.read(json, jsonData);
        this.startAlpha = ((Float)json.readValue("startAlpha", Float.TYPE, (Object)Float.valueOf(1.0f), jsonData)).floatValue();
        this.targetAlpha = ((Float)json.readValue("targetAlpha", Float.TYPE, (Object)Float.valueOf(1.0f), jsonData)).floatValue();
    }
}

