/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.anim;

import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.bladecoder.engine.actions.ActionCallback;
import com.bladecoder.engine.anim.Tween;
import com.bladecoder.engine.model.SpriteActor;
import com.bladecoder.engine.util.InterpolationMode;

public class SpritePosTween
extends Tween<SpriteActor> {
    private float startX;
    private float startY;
    private float targetX;
    private float targetY;
    private InterpolationMode interpolationX;
    private InterpolationMode interpolationY;

    public void start(SpriteActor target, Tween.Type repeatType, int count, float tx, float ty, float duration, InterpolationMode interpolation, ActionCallback cb) {
        this.start(target, repeatType, count, tx, ty, duration, interpolation, interpolation, cb);
    }

    public void start(SpriteActor target, Tween.Type repeatType, int count, float tx, float ty, float duration, InterpolationMode interpolationX, InterpolationMode interpolationY, ActionCallback cb) {
        this.target = target;
        this.startX = target.getX();
        this.startY = target.getY();
        this.targetX = tx;
        this.targetY = ty;
        this.setDuration(duration);
        this.setType(repeatType);
        this.setCount(count);
        this.interpolationX = interpolationX;
        this.interpolationY = interpolationY;
        if (cb != null) {
            this.setCb(cb);
        }
        this.restart();
    }

    @Override
    public void updateTarget() {
        float percentX = this.getPercent(this.interpolationX);
        float percentY = this.getPercent(this.interpolationY);
        ((SpriteActor)this.target).setPosition(this.startX + percentX * (this.targetX - this.startX), this.startY + percentY * (this.targetY - this.startY));
    }

    @Override
    public void write(Json json) {
        super.write(json);
        json.writeValue("startX", (Object)Float.valueOf(this.startX));
        json.writeValue("startY", (Object)Float.valueOf(this.startY));
        json.writeValue("targetX", (Object)Float.valueOf(this.targetX));
        json.writeValue("targetY", (Object)Float.valueOf(this.targetY));
        json.writeValue("interpolationX", (Object)this.interpolationX);
        json.writeValue("interpolationY", (Object)this.interpolationY);
    }

    @Override
    public void read(Json json, JsonValue jsonData) {
        super.read(json, jsonData);
        this.startX = ((Float)json.readValue("startX", Float.class, jsonData)).floatValue();
        this.startY = ((Float)json.readValue("startY", Float.class, jsonData)).floatValue();
        this.targetX = ((Float)json.readValue("targetX", Float.class, jsonData)).floatValue();
        this.targetY = ((Float)json.readValue("targetY", Float.class, jsonData)).floatValue();
        this.interpolationX = (InterpolationMode)((Object)json.readValue("interpolationX", InterpolationMode.class, jsonData));
        this.interpolationY = (InterpolationMode)((Object)json.readValue("interpolationY", InterpolationMode.class, jsonData));
    }
}

