/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.anim;

import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.bladecoder.engine.actions.ActionCallback;
import com.bladecoder.engine.anim.Tween;
import com.bladecoder.engine.model.SpriteActor;
import com.bladecoder.engine.util.InterpolationMode;

public class SpriteRotateTween
extends Tween<SpriteActor> {
    private float startRot;
    private float targetRot;

    public void start(SpriteActor target, Tween.Type repeatType, int count, float tRot, float duration, InterpolationMode interpolation, ActionCallback cb) {
        this.target = target;
        this.startRot = target.getRot();
        this.targetRot = tRot;
        this.setDuration(duration);
        this.setType(repeatType);
        this.setCount(count);
        this.setInterpolation(interpolation);
        if (cb != null) {
            this.setCb(cb);
        }
        this.restart();
    }

    @Override
    public void updateTarget() {
        ((SpriteActor)this.target).setRot(this.startRot + this.getPercent() * (this.targetRot - this.startRot));
    }

    @Override
    public void write(Json json) {
        super.write(json);
        json.writeValue("startRot", (Object)Float.valueOf(this.startRot));
        json.writeValue("targetRot", (Object)Float.valueOf(this.targetRot));
    }

    @Override
    public void read(Json json, JsonValue jsonData) {
        super.read(json, jsonData);
        this.startRot = ((Float)json.readValue("startRot", Float.class, jsonData)).floatValue();
        this.targetRot = ((Float)json.readValue("targetRot", Float.class, jsonData)).floatValue();
    }
}

