/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.anim;

import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.bladecoder.engine.actions.ActionCallback;
import com.bladecoder.engine.anim.Tween;
import com.bladecoder.engine.model.SpriteActor;
import com.bladecoder.engine.util.InterpolationMode;

public class SpriteScaleTween
extends Tween<SpriteActor> {
    private float startSclX;
    private float startSclY;
    private float targetSclX;
    private float targetSclY;

    public void start(SpriteActor target, Tween.Type repeatType, int count, float tSclX, float tSclY, float duration, InterpolationMode interpolation, ActionCallback cb) {
        this.target = target;
        this.startSclX = target.getScaleX();
        this.startSclY = target.getScaleY();
        this.targetSclX = tSclX;
        this.targetSclY = tSclY;
        this.setDuration(duration);
        this.setType(repeatType);
        this.setCount(count);
        this.setInterpolation(interpolation);
        if (cb != null) {
            this.setCb(cb);
        }
        this.restart();
    }

    @Override
    public void updateTarget() {
        float percent = this.getPercent();
        ((SpriteActor)this.target).setScale(this.startSclX + percent * (this.targetSclX - this.startSclX), this.startSclY + percent * (this.targetSclY - this.startSclY));
    }

    @Override
    public void write(Json json) {
        super.write(json);
        json.writeValue("startSclX", (Object)Float.valueOf(this.startSclX));
        json.writeValue("startSclY", (Object)Float.valueOf(this.startSclY));
        json.writeValue("targetSclX", (Object)Float.valueOf(this.targetSclX));
        json.writeValue("targetSclY", (Object)Float.valueOf(this.targetSclY));
    }

    @Override
    public void read(Json json, JsonValue jsonData) {
        super.read(json, jsonData);
        this.startSclX = ((Float)json.readValue("startSclX", Float.class, jsonData)).floatValue();
        this.startSclY = ((Float)json.readValue("startSclY", Float.class, jsonData)).floatValue();
        this.targetSclX = ((Float)json.readValue("targetSclX", Float.class, jsonData)).floatValue();
        this.targetSclY = ((Float)json.readValue("targetSclY", Float.class, jsonData)).floatValue();
    }
}

