/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.anim;

import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.bladecoder.engine.actions.ActionCallback;
import com.bladecoder.engine.model.Scene;
import com.bladecoder.engine.model.World;
import com.bladecoder.engine.serialization.ActionCallbackSerializer;
import com.bladecoder.engine.serialization.BladeJson;
import com.bladecoder.engine.util.InterpolationMode;

public abstract class Tween<T>
implements Json.Serializable {
    public static final int INFINITY = -1;
    private float duration;
    private float time;
    private InterpolationMode interpolation;
    private boolean reverse;
    private boolean began;
    private boolean complete;
    private Type type;
    private int count;
    private ActionCallback cb;
    protected T target;

    public void update(float delta) {
        if (this.complete) {
            return;
        }
        if (!this.began) {
            this.began = true;
        }
        this.time += delta;
        if (this.time >= this.duration) {
            if (this.type == Type.NO_REPEAT || this.type == Type.REVERSE || this.count == 1) {
                this.complete = true;
            } else {
                --this.count;
                this.time = 1.0E-5f;
                if (this.type == Type.YOYO) {
                    this.reverse = !this.reverse;
                }
            }
        }
        this.updateTarget();
        if (this.complete) {
            this.callCb();
        }
    }

    protected abstract void updateTarget();

    private void callCb() {
        if (this.cb != null) {
            ActionCallback tmpcb = this.cb;
            this.cb = null;
            tmpcb.resume();
        }
    }

    public void setTarget(T t) {
        this.target = t;
    }

    public T getTarget() {
        return this.target;
    }

    public float getPercent() {
        return this.getPercent(this.interpolation);
    }

    public float getPercent(InterpolationMode i) {
        float percent;
        if (this.complete) {
            percent = 1.0f;
        } else {
            percent = this.time / this.duration;
            if (i != null) {
                percent = i.getInterpolation().apply(percent);
            }
        }
        return this.reverse ? 1.0f - percent : percent;
    }

    public void finish() {
        this.time = this.duration;
    }

    public void restart() {
        this.time = 0.0f;
        this.began = false;
        this.complete = false;
    }

    public void reset() {
        this.reverse = false;
        this.interpolation = null;
    }

    public float getTime() {
        return this.time;
    }

    public void setTime(float time) {
        this.time = time;
    }

    public float getDuration() {
        return this.duration;
    }

    public void setDuration(float duration) {
        this.duration = duration;
    }

    public void setInterpolation(InterpolationMode i) {
        this.interpolation = i;
    }

    public boolean isReverse() {
        return this.reverse;
    }

    public void setReverse(boolean reverse) {
        this.reverse = reverse;
    }

    public void setCb(ActionCallback cb) {
        this.cb = cb;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
        if (type == Type.REVERSE || type == Type.REVERSE_REPEAT) {
            this.reverse = true;
        }
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void write(Json json) {
        json.writeValue("duration", (Object)Float.valueOf(this.duration));
        json.writeValue("time", (Object)Float.valueOf(this.time));
        json.writeValue("reverse", (Object)this.reverse);
        json.writeValue("began", (Object)this.began);
        json.writeValue("complete", (Object)this.complete);
        json.writeValue("type", (Object)this.type);
        json.writeValue("count", (Object)this.count);
        json.writeValue("interpolation", (Object)this.interpolation);
        if (this.cb != null) {
            World w = ((BladeJson)json).getWorld();
            Scene s = ((BladeJson)json).getScene();
            json.writeValue("cb", (Object)ActionCallbackSerializer.serialize(w, s, this.cb));
        }
    }

    public void read(Json json, JsonValue jsonData) {
        this.duration = ((Float)json.readValue("duration", Float.class, jsonData)).floatValue();
        this.time = ((Float)json.readValue("time", Float.class, jsonData)).floatValue();
        this.reverse = (Boolean)json.readValue("reverse", Boolean.class, jsonData);
        this.began = (Boolean)json.readValue("began", Boolean.class, jsonData);
        this.complete = (Boolean)json.readValue("complete", Boolean.class, jsonData);
        this.type = (Type)((Object)json.readValue("type", Type.class, jsonData));
        this.count = (Integer)json.readValue("count", Integer.class, jsonData);
        this.interpolation = (InterpolationMode)((Object)json.readValue("interpolation", InterpolationMode.class, jsonData));
        BladeJson bjson = (BladeJson)json;
        this.cb = ActionCallbackSerializer.find(bjson.getWorld(), bjson.getScene(), (String)json.readValue("cb", String.class, jsonData));
    }

    public static enum Type {
        NO_REPEAT,
        REPEAT,
        YOYO,
        REVERSE,
        REVERSE_REPEAT,
        SPRITE_DEFINED;

    }
}

