/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.anim;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.bladecoder.engine.actions.ActionCallback;
import com.bladecoder.engine.anim.SpritePosTween;
import com.bladecoder.engine.anim.Tween;
import com.bladecoder.engine.assets.EngineAssetManager;
import com.bladecoder.engine.model.AnimationRenderer;
import com.bladecoder.engine.model.CharacterActor;
import com.bladecoder.engine.model.Scene;
import com.bladecoder.engine.model.World;
import com.bladecoder.engine.serialization.ActionCallbackSerializer;
import com.bladecoder.engine.serialization.BladeJson;
import com.bladecoder.engine.util.EngineLogger;
import com.bladecoder.engine.util.InterpolationMode;
import java.util.ArrayList;

public class WalkTween
extends SpritePosTween
implements Json.Serializable {
    private ArrayList<Vector2> walkingPath;
    private int currentStep = 0;
    private float speed = 0.0f;
    private ActionCallback walkCb;

    public void start(CharacterActor target, ArrayList<Vector2> walkingPath, float speed, ActionCallback cb) {
        this.target = target;
        this.walkingPath = walkingPath;
        this.speed = speed;
        this.currentStep = 0;
        if (cb != null) {
            this.walkCb = cb;
        }
        this.restart();
        this.walkToNextStep(target);
    }

    private void walkToNextStep(CharacterActor target) {
        float sdiff;
        Vector2 p0 = this.walkingPath.get(this.currentStep);
        Vector2 pf = this.walkingPath.get(this.currentStep + 1);
        float s0 = 1.0f;
        float sf = 1.0f;
        if (target.getFakeDepth()) {
            s0 = target.getScene().getFakeDepthScale(p0.y);
            sf = target.getScene().getFakeDepthScale(pf.y);
        }
        if ((sdiff = Math.abs(s0 - sf)) > 0.05f) {
            Vector2 pi = new Vector2((pf.x + p0.x) / 2.0f, (pf.y + p0.y) / 2.0f);
            if (EngineLogger.debugMode()) {
                String debugText = String.format("WalkTween insert point: sdiff=%.2f, p0=(%.0f,%.0f), pf=(%.0f,%.0f), pi=(%.0f,%.0f)", Float.valueOf(sdiff), Float.valueOf(p0.x), Float.valueOf(p0.y), Float.valueOf(pf.x), Float.valueOf(pf.y), Float.valueOf(pi.x), Float.valueOf(pi.y));
                EngineLogger.debug(debugText);
            }
            this.walkingPath.add(this.currentStep + 1, pi);
            this.walkToNextStep(target);
            return;
        }
        if (this.currentStep == 0 || ((AnimationRenderer)target.getRenderer()).changeDir(p0, pf)) {
            target.startWalkAnim(p0, pf);
        }
        float segmentDuration = p0.dst(pf) / (EngineAssetManager.getInstance().getScale() * this.speed * (s0 + sf) / 2.0f);
        this.start(target, Tween.Type.NO_REPEAT, 1, pf.x, pf.y, segmentDuration, InterpolationMode.LINEAR, InterpolationMode.LINEAR, this.currentStep == this.walkingPath.size() - 2 ? this.walkCb : null);
    }

    private void segmentEnded(CharacterActor target) {
        ++this.currentStep;
        if (this.currentStep < this.walkingPath.size() - 1) {
            this.walkToNextStep(target);
        } else {
            target.stand();
            if (this.walkCb == null && target == target.getScene().getCameraFollowActor()) {
                target.getScene().getCamera().startAnimation(target.getX(), target.getY(), target.getScene().getCamera().getZoom(), 1.0f, InterpolationMode.POW2OUT, null);
            }
        }
    }

    public void completeNow(CharacterActor target) {
        this.currentStep = this.walkingPath.size();
        Vector2 p = this.walkingPath.get(this.currentStep - 1);
        target.setPosition(p.x, p.y);
        target.stand();
        if (this.walkCb != null) {
            ActionCallback tmpcb = this.walkCb;
            this.walkCb = null;
            tmpcb.resume();
        }
    }

    @Override
    public void updateTarget() {
        super.updateTarget();
        if (this.isComplete()) {
            this.segmentEnded((CharacterActor)this.target);
        }
    }

    @Override
    public void write(Json json) {
        super.write(json);
        json.writeValue("path", this.walkingPath);
        json.writeValue("currentStep", (Object)this.currentStep);
        json.writeValue("speed", (Object)Float.valueOf(this.speed));
        if (this.walkCb != null) {
            World w = ((BladeJson)json).getWorld();
            Scene s = ((BladeJson)json).getScene();
            json.writeValue("walkCb", (Object)ActionCallbackSerializer.serialize(w, s, this.walkCb));
        }
    }

    @Override
    public void read(Json json, JsonValue jsonData) {
        super.read(json, jsonData);
        this.walkingPath = (ArrayList)json.readValue("path", ArrayList.class, Vector2.class, jsonData);
        this.currentStep = (Integer)json.readValue("currentStep", Integer.class, jsonData);
        this.speed = ((Float)json.readValue("speed", Float.class, jsonData)).floatValue();
        World w = ((BladeJson)json).getWorld();
        Scene s = ((BladeJson)json).getScene();
        this.walkCb = ActionCallbackSerializer.find(w, s, (String)json.readValue("walkCb", String.class, jsonData));
    }
}

