/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.i18n;

import com.bladecoder.engine.i18n.I18NControl;
import com.bladecoder.engine.util.EngineLogger;
import java.util.Locale;
import java.util.ResourceBundle;

public class I18N {
    public static final char PREFIX = '@';
    public static final String ENCODING = "UTF-8";
    private ResourceBundle i18nWorld;
    private ResourceBundle i18nChapter;
    private Locale locale = Locale.getDefault();
    private String i18nChapterFilename = null;
    private String i18nWorldFilename = null;

    public void loadChapter(String i18nChapterFilename) {
        try {
            this.i18nChapter = this.getBundle(i18nChapterFilename, false);
            this.i18nChapterFilename = i18nChapterFilename;
        }
        catch (Exception e) {
            EngineLogger.error("ERROR LOADING BUNDLE: " + i18nChapterFilename);
        }
    }

    public void loadWorld(String i18nWorldFilename) {
        try {
            this.i18nWorld = this.getBundle(i18nWorldFilename, true);
            this.i18nWorldFilename = i18nWorldFilename;
        }
        catch (Exception e) {
            EngineLogger.error("ERROR LOADING BUNDLE: " + i18nWorldFilename);
        }
    }

    public ResourceBundle getBundle(String filename, boolean clearCache) {
        ResourceBundle rb = null;
        try {
            if (clearCache) {
                ResourceBundle.clearCache();
            }
            rb = ResourceBundle.getBundle(filename, this.locale, new I18NControl(ENCODING));
        }
        catch (Exception e) {
            EngineLogger.error("ERROR LOADING BUNDLE: " + filename);
        }
        return rb;
    }

    public void setLocale(Locale l) {
        this.locale = l;
        if (this.i18nWorld != null) {
            this.loadWorld(this.i18nWorldFilename);
        }
        if (this.i18nChapter != null) {
            this.loadChapter(this.i18nChapterFilename);
        }
    }

    public String getString(String key) {
        try {
            return this.i18nChapter.getString(key);
        }
        catch (Exception e) {
            try {
                return this.i18nWorld.getString(key);
            }
            catch (Exception e2) {
                EngineLogger.error("MISSING TRANSLATION KEY: " + key);
                return key;
            }
        }
    }

    public Locale getCurrentLocale() {
        return this.locale;
    }
}

