/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.ink;

import com.bladecoder.engine.actions.SceneActorRef;
import com.bladecoder.engine.model.InteractiveActor;
import com.bladecoder.engine.model.Inventory;
import com.bladecoder.engine.model.Scene;
import com.bladecoder.engine.model.World;
import com.bladecoder.engine.util.EngineLogger;
import com.bladecoder.ink.runtime.Story;

public class ExternalFunctions {
    public static void bindExternalFunctions(final World w, Story story) throws Exception {
        story.bindExternalFunction("inInventory", (Story.ExternalFunction)new Story.ExternalFunction1<String, Boolean>(){

            public Boolean call(String actor) throws Exception {
                if (actor.charAt(0) == '>') {
                    actor = actor.substring(1);
                }
                return w.getInventory().get(actor) != null;
            }
        });
        story.bindExternalFunction("getActorState", (Story.ExternalFunction)new Story.ExternalFunction1<String, String>(){

            public String call(String act) throws Exception {
                String actorId;
                SceneActorRef actor;
                Scene s;
                InteractiveActor a;
                if (act.charAt(0) == '>') {
                    act = act.substring(1);
                }
                if ((a = (InteractiveActor)(s = (actor = new SceneActorRef(act)).getScene(w)).getActor(actorId = actor.getActorId(), true)) == null) {
                    EngineLogger.error("getActorState - Actor not found: " + actorId);
                    return "";
                }
                return a.getState() == null ? "" : a.getState();
            }
        });
        story.bindExternalFunction("getSceneState", (Story.ExternalFunction)new Story.ExternalFunction1<String, String>(){

            public String call(String scene) throws Exception {
                Scene s;
                if (scene.charAt(0) == '>') {
                    scene = scene.substring(1);
                }
                if ((s = w.getScene(scene)) == null) {
                    EngineLogger.error("getSceneState - Scene not found: " + scene);
                    return "";
                }
                return s.getState() == null ? "" : s.getState();
            }
        });
        story.bindExternalFunction("getPlayer", (Story.ExternalFunction)new Story.ExternalFunction0<String>(){

            public String call() throws Exception {
                return w.getCurrentScene().getPlayer().getId();
            }
        });
        story.bindExternalFunction("inInventory2", (Story.ExternalFunction)new Story.ExternalFunction2<String, String, Boolean>(){

            public Boolean call(String actor, String inventory) throws Exception {
                Inventory inv;
                if (actor.charAt(0) == '>') {
                    actor = actor.substring(1);
                }
                if ((inv = w.getInventories().get(inventory)) == null) {
                    EngineLogger.debug("InkExternalFunction::inInventory2: Inventory not found: " + inventory);
                    return false;
                }
                return inv.get(actor) != null;
            }
        });
        story.bindExternalFunction("getCurrentScene", (Story.ExternalFunction)new Story.ExternalFunction0<String>(){

            public String call() throws Exception {
                return w.getCurrentScene().getId();
            }
        });
        story.bindExternalFunction("isDebug", (Story.ExternalFunction)new Story.ExternalFunction0<Boolean>(){

            public Boolean call() throws Exception {
                return EngineLogger.debugMode();
            }
        });
        story.bindExternalFunction("getProperty", (Story.ExternalFunction)new Story.ExternalFunction1<String, String>(){

            public String call(String p) throws Exception {
                String v;
                if (p.charAt(0) == '>') {
                    p = p.substring(1);
                }
                return (v = w.getCustomProperty(p)) == null ? "" : v;
            }
        });
        story.bindExternalFunction("isVisible", (Story.ExternalFunction)new Story.ExternalFunction1<String, Boolean>(){

            public Boolean call(String act) throws Exception {
                String actorId;
                SceneActorRef actor;
                Scene s;
                InteractiveActor a;
                if (act.charAt(0) == '>') {
                    act = act.substring(1);
                }
                if ((a = (InteractiveActor)(s = (actor = new SceneActorRef(act)).getScene(w)).getActor(actorId = actor.getActorId(), true)) == null) {
                    EngineLogger.error("getActorState - Actor not found: " + actorId);
                    return false;
                }
                return a.isVisible();
            }
        });
    }
}

