/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.ink;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.reflect.ReflectionException;
import com.bladecoder.engine.actions.Action;
import com.bladecoder.engine.actions.ActionCallback;
import com.bladecoder.engine.actions.ActionFactory;
import com.bladecoder.engine.assets.EngineAssetManager;
import com.bladecoder.engine.ink.ExternalFunctions;
import com.bladecoder.engine.ink.InkVerbRunner;
import com.bladecoder.engine.model.Text;
import com.bladecoder.engine.model.World;
import com.bladecoder.engine.serialization.BladeJson;
import com.bladecoder.engine.util.ActionUtils;
import com.bladecoder.engine.util.EngineLogger;
import com.bladecoder.ink.runtime.Choice;
import com.bladecoder.ink.runtime.InkList;
import com.bladecoder.ink.runtime.ListDefinition;
import com.bladecoder.ink.runtime.Story;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;

public class InkManager
implements Json.Serializable {
    public static final int KEY_SIZE = 10;
    public static final char NAME_VALUE_TAG_SEPARATOR = ':';
    public static final char NAME_VALUE_PARAM_SEPARATOR = '=';
    private static final String PARAM_SEPARATOR = ",";
    public static final char COMMAND_MARK = '>';
    public static final char CHAR_SEPARATOR_MARK = ':';
    private ResourceBundle i18n;
    private Story story = null;
    private boolean wasInCutmode;
    private String storyName;
    private final World w;
    private Thread loaderThread;
    private final HashMap<String, InkVerbRunner> verbRunners = new HashMap();

    public InkManager(World w) {
        this.w = w;
    }

    public void init() {
        this.wasInCutmode = false;
        for (String flow : this.verbRunners.keySet()) {
            try {
                if (flow.equals("DEFAULT_FLOW")) continue;
                this.story.removeFlow(flow);
            }
            catch (Exception e) {
                EngineLogger.error("InkManager - Cannot remove flow: " + flow);
            }
        }
        this.verbRunners.clear();
    }

    public void newStory(String name) throws Exception {
        this.loadThreaded(name, null);
    }

    private void loadStory(String name) {
        try {
            FileHandle asset = EngineAssetManager.getInstance().getAsset("model/" + name + ".ink.json");
            long initTime = System.currentTimeMillis();
            String json = this.getJsonString(asset.read());
            this.story = new Story(json);
            ExternalFunctions.bindExternalFunctions(this.w, this.story);
            this.storyName = name;
            this.loadI18NBundle();
            EngineLogger.debug("INK STORY LOADING TIME (ms): " + (System.currentTimeMillis() - initTime));
        }
        catch (Exception e) {
            EngineLogger.error("Cannot load Ink Story: " + name + " " + e.getMessage());
            this.story = null;
            this.storyName = null;
        }
    }

    private void loadStoryState(String stateString) {
        try {
            long initTime = System.currentTimeMillis();
            this.story.getState().loadJson(stateString);
            EngineLogger.debug("INK *SAVED STATE* LOADING TIME (ms): " + (System.currentTimeMillis() - initTime));
        }
        catch (Exception e) {
            EngineLogger.error("Cannot load Ink Story State for: " + this.storyName + " " + e.getMessage());
        }
    }

    public void loadI18NBundle() {
        if (this.getStoryName() != null && EngineAssetManager.getInstance().getModelFile(this.storyName + "-ink.properties").exists()) {
            this.i18n = this.w.getI18N().getBundle("model/" + this.storyName + "-ink", true);
        }
    }

    public String translateLine(String line) {
        if (line.charAt(0) == '@') {
            String key = line.substring(1);
            String[] keys = key.split("@");
            String translated = "";
            for (String k : keys) {
                try {
                    String k2 = k.substring(0, 10);
                    translated = translated + this.i18n.getString(k2);
                    if (k.length() <= 10) continue;
                    String trailing = k.substring(10);
                    translated = translated + trailing;
                }
                catch (Exception e) {
                    EngineLogger.error("MISSING TRANSLATION KEY: " + key);
                    return key;
                }
            }
            translated = translated.replace('_', ' ');
            return translated;
        }
        return line;
    }

    public String getVariable(String name) {
        return this.story.getVariablesState().get(name).toString();
    }

    public boolean compareVariable(String name, String value) {
        this.waitIfNotLoaded();
        if (this.story.getVariablesState().get(name) instanceof InkList) {
            return ((InkList)this.story.getVariablesState().get(name)).ContainsItemNamed(value);
        }
        return this.story.getVariablesState().get(name).toString().equals(value == null ? "" : value);
    }

    public void setVariable(String name, String value) throws Exception {
        this.waitIfNotLoaded();
        if (this.story.getVariablesState().get(name) instanceof InkList) {
            List names;
            InkList oldList = (InkList)this.story.getVariablesState().get(name);
            InkList rawList = new InkList(oldList);
            if (rawList.getOrigins() == null && (names = rawList.getOriginNames()) != null) {
                ArrayList<ListDefinition> origins = new ArrayList<ListDefinition>();
                for (String n : names) {
                    ListDefinition def = this.story.getListDefinitions().getListDefinition(n);
                    if (origins.contains(def)) continue;
                    origins.add(def);
                }
                rawList.setOrigins(origins);
            }
            rawList.addItem(value);
            this.story.getVariablesState().set(name, (Object)rawList);
        } else {
            this.story.getVariablesState().set(name, (Object)value);
        }
    }

    public void continueMaximally(InkVerbRunner inkVerbRunner) {
        this.waitIfNotLoaded();
        String line = null;
        HashMap<String, String> currentLineParams = new HashMap<String, String>();
        if (this.story.canContinue()) {
            try {
                do {
                    if (!(line = this.story.Continue()).isEmpty()) {
                        line = line.substring(0, line.length() - 1);
                    }
                    if (!line.isEmpty()) continue;
                    EngineLogger.debug("INK EMPTY LINE!");
                } while (line.isEmpty() && this.story.canContinue());
                if (!line.isEmpty()) {
                    if (EngineLogger.debugMode()) {
                        EngineLogger.debug("INK LINE: " + this.translateLine(line));
                    }
                    this.processParams(this.story.getCurrentTags(), currentLineParams);
                    if (line.charAt(0) == '>') {
                        this.processCommand(inkVerbRunner, currentLineParams, line);
                    } else {
                        this.processTextLine(inkVerbRunner, currentLineParams, line);
                    }
                }
            }
            catch (Exception e) {
                EngineLogger.error(e.getMessage(), e);
            }
        }
        if (!inkVerbRunner.isFinish()) {
            inkVerbRunner.runCurrentAction();
        } else if (this.hasChoices()) {
            this.wasInCutmode = this.w.inCutMode();
            this.w.setCutMode(false);
            this.w.getListener().dialogOptions();
        } else {
            inkVerbRunner.callCb();
        }
    }

    private void processParams(List<String> input, HashMap<String, String> output) {
        for (String t : input) {
            String value;
            String key;
            int i = t.indexOf(58);
            if (i == -1) {
                i = t.indexOf(61);
            }
            if (i != -1) {
                key = t.substring(0, i).trim();
                value = t.substring(i + 1, t.length()).trim();
            } else {
                key = t.trim();
                value = null;
            }
            EngineLogger.debug("PARAM: " + key + " value: " + value);
            output.put(key, value);
        }
    }

    private void processCommand(InkVerbRunner inkVerbRunner, HashMap<String, String> params, String line) {
        String commandName;
        int i = line.indexOf(58);
        if (i == -1) {
            commandName = line.substring(1).trim();
        } else {
            commandName = line.substring(1, i).trim();
            String[] commandParams = line.substring(i + 1).split(PARAM_SEPARATOR);
            this.processParams(Arrays.asList(commandParams), params);
        }
        if ("LeaveNow".equals(commandName)) {
            boolean init = true;
            String initVerb = null;
            if (params.get("init") != null) {
                init = Boolean.parseBoolean(params.get("init"));
            }
            if (params.get("initVerb") != null) {
                initVerb = params.get("initVerb");
            }
            this.w.setCurrentScene(params.get("scene"), init, initVerb);
        } else if (commandName.length() > 0) {
            try {
                Class c = (Class)ActionFactory.getClassTags().get((Object)commandName);
                if (c == null && commandName.indexOf(46) == -1) {
                    commandName = "com.bladecoder.engine.actions." + commandName + "Action";
                }
                Action action = ActionFactory.create(commandName, params);
                action.init(this.w);
                inkVerbRunner.getActions().add(action);
            }
            catch (ReflectionException | ClassNotFoundException e) {
                EngineLogger.error(e.getMessage(), (Exception)e);
            }
        } else {
            EngineLogger.error("Ink command not found: " + commandName);
        }
    }

    private void processTextLine(InkVerbRunner inkVerbRunner, HashMap<String, String> params, String line) {
        if (!params.containsKey("actor")) {
            int idx = line.indexOf(62);
            if (idx == -1) {
                idx = line.indexOf(58);
            }
            if (idx != -1) {
                params.put("actor", line.substring(0, idx).trim());
                line = line.substring(idx + 1).trim();
            }
        }
        if (!params.containsKey("actor") && this.w.getCurrentScene().getPlayer() != null) {
            if (!params.containsKey("type")) {
                params.put("type", Text.Type.SUBTITLE.toString());
            }
        } else if (params.containsKey("actor") && !params.containsKey("type")) {
            params.put("type", Text.Type.TALK.toString());
        } else if (!params.containsKey("type")) {
            params.put("type", Text.Type.SUBTITLE.toString());
        }
        params.put("text", this.translateLine(line));
        try {
            Action action = null;
            action = !params.containsKey("actor") ? ActionFactory.create("Text", params) : ActionFactory.create("Say", params);
            action.init(this.w);
            inkVerbRunner.getActions().add(action);
        }
        catch (ReflectionException | ClassNotFoundException e) {
            EngineLogger.error(e.getMessage(), (Exception)e);
        }
    }

    public Story getStory() {
        this.waitIfNotLoaded();
        return this.story;
    }

    public void runPath(String path, Object[] params, String flow, ActionCallback cb) throws Exception {
        this.waitIfNotLoaded();
        if (this.story == null) {
            EngineLogger.error("Ink Story not loaded!");
            return;
        }
        if (flow == null) {
            this.story.switchToDefaultFlow();
        } else {
            this.story.switchFlow(flow);
        }
        this.story.choosePathString(path, true, params);
        InkVerbRunner verbRunner = this.createVerbRunner(cb);
        this.continueMaximally(verbRunner);
    }

    private InkVerbRunner createVerbRunner(ActionCallback cb) {
        String f = this.story.getCurrentFlowName();
        InkVerbRunner prev = this.verbRunners.put(this.story.getCurrentFlowName(), new InkVerbRunner(this.w, this, f, cb, null));
        if (prev != null) {
            prev.cancel();
        }
        return this.verbRunners.get(f);
    }

    public boolean hasChoices() {
        this.waitIfNotLoaded();
        if (this.story == null) {
            return false;
        }
        try {
            this.story.switchToDefaultFlow();
        }
        catch (Exception e) {
            EngineLogger.error("InkManager: " + e.getMessage());
            return false;
        }
        return (!this.verbRunners.containsKey("DEFAULT_FLOW") || this.verbRunners.get("DEFAULT_FLOW").isFinish()) && this.story.getCurrentChoices().size() > 0;
    }

    public List<String> getChoices() {
        List options = this.story.getCurrentChoices();
        ArrayList<String> choices = new ArrayList<String>(options.size());
        for (Choice o : options) {
            String line = o.getText();
            if (line.isEmpty()) continue;
            int idx = line.indexOf(62);
            if (idx == -1) {
                idx = line.indexOf(58);
            }
            if (idx != -1) {
                line = line.substring(idx + 1).trim();
            }
            choices.add(this.translateLine(line));
        }
        return choices;
    }

    private String getJsonString(InputStream is) throws IOException {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
            StringBuilder sb = new StringBuilder();
            String line = br.readLine();
            if (line != null) {
                line = line.replace('\ufeff', ' ');
            }
            while (line != null) {
                sb.append(line);
                sb.append("\n");
                line = br.readLine();
            }
            String string = sb.toString();
            return string;
        }
    }

    public void selectChoice(int i) {
        this.w.setCutMode(this.wasInCutmode);
        try {
            this.story.switchToDefaultFlow();
            this.story.chooseChoiceIndex(i);
            this.continueMaximally(this.verbRunners.get("DEFAULT_FLOW"));
        }
        catch (Exception e) {
            EngineLogger.error(e.getMessage(), e);
        }
    }

    public String getStoryName() {
        return this.storyName;
    }

    public void setStoryName(String storyName) {
        this.storyName = storyName;
    }

    private void waitIfNotLoaded() {
        if (this.loaderThread != null && this.loaderThread.isAlive()) {
            EngineLogger.debug(">>> Loader thread not finished. Waiting for it!!!");
            try {
                this.loaderThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void loadThreaded(final String name, final String state) {
        EngineLogger.debug("LOADING INK STORY: " + name + (state == null ? "" : " WITH SAVED STATE."));
        this.loaderThread = new Thread(){

            @Override
            public void run() {
                if (name != null) {
                    InkManager.this.loadStory(name);
                }
                if (state != null) {
                    InkManager.this.loadStoryState(state);
                }
            }
        };
        this.loaderThread.start();
    }

    public HashMap<String, InkVerbRunner> getVerbRunners() {
        return this.verbRunners;
    }

    public InkVerbRunner getDefaultVerbRunner() {
        return this.verbRunners.get("DEFAULT_FLOW");
    }

    public void write(Json json) {
        BladeJson bjson = (BladeJson)json;
        json.writeValue("storyName", (Object)this.storyName);
        if (bjson.getMode() == BladeJson.Mode.STATE) {
            json.writeValue("wasInCutmode", (Object)this.wasInCutmode);
            if (this.story != null) {
                try {
                    json.writeValue("story", (Object)this.story.getState().toJson());
                }
                catch (Exception e) {
                    EngineLogger.error("Error saving Ink state", e);
                }
                json.writeValue("verbRunners", this.verbRunners, this.verbRunners.getClass(), InkVerbRunner.class);
            }
        }
    }

    public void read(Json json, JsonValue jsonData) {
        block7: {
            String name;
            World w;
            block8: {
                BladeJson bjson = (BladeJson)json;
                w = bjson.getWorld();
                name = (String)json.readValue("storyName", String.class, jsonData);
                if (bjson.getMode() != BladeJson.Mode.MODEL) break block8;
                this.story = null;
                this.storyName = name;
                if (!bjson.getInit()) break block7;
                this.loadThreaded(name, null);
                break block7;
            }
            this.wasInCutmode = (Boolean)json.readValue("wasInCutmode", Boolean.class, jsonData);
            String storyString = (String)json.readValue("story", String.class, jsonData);
            if (storyString != null) {
                this.loadThreaded(name, storyString);
            }
            if (jsonData.has("actions")) {
                int i;
                String sCb = (String)json.readValue("cb", String.class, jsonData);
                JsonValue actionsValue = jsonData.get("actions");
                InkVerbRunner inkVerbRunner = new InkVerbRunner(w, this, "DEFAULT_FLOW", null, sCb);
                this.verbRunners.put("DEFAULT_FLOW", inkVerbRunner);
                for (i = 0; i < actionsValue.size; ++i) {
                    JsonValue aValue = actionsValue.get(i);
                    Action a = ActionUtils.readJson(w, json, aValue);
                    inkVerbRunner.getActions().add(a);
                }
                inkVerbRunner.setIP((Integer)json.readValue("ip", Integer.class, jsonData));
                actionsValue = jsonData.get("actionsSer");
                i = 0;
                for (Action a : inkVerbRunner.getActions()) {
                    if (!(a instanceof Json.Serializable) || i >= actionsValue.size) continue;
                    if (actionsValue.get(i) != null) {
                        ((Json.Serializable)a).read(json, actionsValue.get(i));
                        ++i;
                        continue;
                    }
                    break;
                }
            } else {
                for (int i = 0; i < jsonData.get((String)"verbRunners").size; ++i) {
                    JsonValue jRunner = jsonData.get("verbRunners").get(i);
                    InkVerbRunner inkVerbRunner = new InkVerbRunner(w, this, jRunner.name, null, null);
                    this.verbRunners.put(jRunner.name, inkVerbRunner);
                    inkVerbRunner.read(json, jRunner);
                }
            }
        }
    }
}

