/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.ink;

import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.bladecoder.engine.actions.Action;
import com.bladecoder.engine.actions.ActionCallback;
import com.bladecoder.engine.ink.InkManager;
import com.bladecoder.engine.model.VerbRunner;
import com.bladecoder.engine.model.World;
import com.bladecoder.engine.serialization.ActionCallbackSerializer;
import com.bladecoder.engine.serialization.BladeJson;
import com.bladecoder.engine.util.ActionUtils;
import com.bladecoder.engine.util.EngineLogger;
import java.util.ArrayList;

public class InkVerbRunner
implements VerbRunner,
Json.Serializable {
    private final ArrayList<Action> actions = new ArrayList(1);
    private int ip = 0;
    private boolean cancelled = false;
    private String flow;
    private ActionCallback cb;
    private String sCb;
    private final InkManager inkManager;
    private final World w;

    public InkVerbRunner(World w, InkManager inkManager, String flow, ActionCallback cb, String sCb) {
        this.flow = flow;
        this.cb = cb;
        this.sCb = sCb;
        this.inkManager = inkManager;
        this.w = w;
    }

    public String getFlow() {
        return this.flow;
    }

    public boolean isFinish() {
        return this.actions.isEmpty() || this.ip >= this.actions.size() || this.cancelled;
    }

    @Override
    public void resume() {
        if (this.cancelled) {
            return;
        }
        if (this.actions.get(this.ip) instanceof ActionCallback) {
            ++this.ip;
        } else {
            this.actions.remove(this.ip);
        }
        this.nextStep();
    }

    @Override
    public ArrayList<Action> getActions() {
        return this.actions;
    }

    @Override
    public void run(String currentTarget, ActionCallback cb) {
        this.ip = 0;
        this.nextStep();
    }

    public void runCurrentAction() {
        this.nextStep();
    }

    @Override
    public int getIP() {
        return this.ip;
    }

    @Override
    public void setIP(int ip) {
        this.ip = ip;
    }

    @Override
    public void cancel() {
        this.cancelled = true;
        this.ip = this.actions.size();
        this.cb = null;
        this.sCb = null;
    }

    @Override
    public String getCurrentTarget() {
        return null;
    }

    public void callCb() {
        if (this.cb != null || this.sCb != null) {
            if (this.cb == null) {
                this.cb = ActionCallbackSerializer.find(this.w, this.w.getCurrentScene(), this.sCb);
            }
            ActionCallback tmpcb = this.cb;
            this.cb = null;
            this.sCb = null;
            tmpcb.resume();
        }
    }

    private void nextStep() {
        if (this.cancelled) {
            return;
        }
        try {
            this.inkManager.getStory().switchFlow(this.flow);
        }
        catch (Exception e1) {
            EngineLogger.error("InkManager: " + e1.getMessage());
            return;
        }
        boolean stop = false;
        while (this.ip < this.actions.size() && !stop && !this.cancelled) {
            Action a = this.actions.get(this.ip);
            try {
                if (a.run(this)) {
                    stop = true;
                    continue;
                }
                if (a instanceof ActionCallback) {
                    ++this.ip;
                    continue;
                }
                this.actions.remove(this.ip);
            }
            catch (Exception e) {
                EngineLogger.error("EXCEPTION EXECUTING ACTION: InkManager - " + this.ip + " - " + a.getClass().getSimpleName() + " - " + e.getMessage(), e);
                ++this.ip;
            }
        }
        if (this.ip >= this.actions.size() && !stop) {
            this.inkManager.continueMaximally(this);
        }
    }

    public void write(Json json) {
        BladeJson bjson = (BladeJson)json;
        World w = bjson.getWorld();
        if (this.cb == null && this.sCb != null) {
            this.cb = ActionCallbackSerializer.find(w, w.getCurrentScene(), this.sCb);
        }
        if (this.cb != null) {
            json.writeValue("cb", (Object)ActionCallbackSerializer.serialize(w, w.getCurrentScene(), this.cb));
        }
        json.writeArrayStart("actions");
        for (Action a : this.getActions()) {
            ActionUtils.writeJson(a, json);
        }
        json.writeArrayEnd();
        json.writeValue("ip", (Object)this.getIP());
        json.writeArrayStart("actionsSer");
        for (Action a : this.getActions()) {
            if (!(a instanceof Json.Serializable)) continue;
            json.writeObjectStart();
            ((Json.Serializable)a).write(json);
            json.writeObjectEnd();
        }
        json.writeArrayEnd();
    }

    public void read(Json json, JsonValue jsonData) {
        int i;
        BladeJson bjson = (BladeJson)json;
        World w = bjson.getWorld();
        this.sCb = (String)json.readValue("cb", String.class, jsonData);
        JsonValue actionsValue = jsonData.get("actions");
        for (i = 0; i < actionsValue.size; ++i) {
            JsonValue aValue = actionsValue.get(i);
            Action a = ActionUtils.readJson(w, json, aValue);
            this.getActions().add(a);
        }
        this.setIP((Integer)json.readValue("ip", Integer.class, jsonData));
        actionsValue = jsonData.get("actionsSer");
        i = 0;
        for (Action a : this.getActions()) {
            if (!(a instanceof Json.Serializable) || i >= actionsValue.size) continue;
            if (actionsValue.get(i) == null) break;
            ((Json.Serializable)a).read(json, actionsValue.get(i));
            ++i;
        }
    }
}

