/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.model;

import com.badlogic.gdx.math.Polygon;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.bladecoder.engine.assets.EngineAssetManager;
import com.bladecoder.engine.model.DirtyProps;
import com.bladecoder.engine.model.Scene;
import com.bladecoder.engine.serialization.BladeJson;

public abstract class BaseActor
implements Json.Serializable {
    protected String id;
    protected Scene scene = null;
    private boolean visible = true;
    private final Polygon bbox = new Polygon();
    private String initScene;
    protected long dirtyProps = 0L;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Polygon getBBox() {
        return this.bbox;
    }

    public boolean hit(float x, float y) {
        return this.getBBox().contains(x, y);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        this.setDirtyProp(DirtyProps.VISIBLE);
    }

    public void setScene(Scene s) {
        this.scene = s;
    }

    public Scene getScene() {
        return this.scene;
    }

    public abstract void update(float var1);

    protected void setDirtyProp(DirtyProps dp) {
        this.dirtyProps |= 1L << dp.ordinal();
    }

    protected boolean isDirty(DirtyProps dp) {
        return (this.dirtyProps & 1L << dp.ordinal()) != 0L;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\nObject: ").append(this.id);
        sb.append("\n  Visible: ").append(this.visible);
        sb.append("\n  Pos: ").append(this.getBBox().getX() + " , " + this.getBBox().getY());
        sb.append("\n  Scale: ").append(this.getBBox().getScaleX());
        sb.append("\n");
        return sb.toString();
    }

    public float getX() {
        return this.bbox.getX();
    }

    public float getY() {
        return this.bbox.getY();
    }

    public void setPosition(float x, float y) {
        if (x != this.bbox.getX() || y != this.bbox.getY()) {
            this.bbox.setPosition(x, y);
            this.setDirtyProp(DirtyProps.POS);
        }
    }

    public String getInitScene() {
        return this.initScene;
    }

    public void setInitScene(String initScene) {
        this.initScene = initScene;
    }

    public void write(Json json) {
        BladeJson bjson = (BladeJson)json;
        if (bjson.getMode() == BladeJson.Mode.MODEL) {
            json.writeValue("id", (Object)this.id);
            json.writeValue("bbox", (Object)this.bbox.getVertices());
        } else if (this.dirtyProps != 0L) {
            json.writeValue("dirtyProps", (Object)this.dirtyProps);
        }
        if (bjson.getMode() == BladeJson.Mode.MODEL || this.isDirty(DirtyProps.POS)) {
            float worldScale = EngineAssetManager.getInstance().getScale();
            Vector2 scaledPos = new Vector2(this.bbox.getX() / worldScale, this.bbox.getY() / worldScale);
            json.writeValue("pos", (Object)scaledPos);
        }
        if (bjson.getMode() == BladeJson.Mode.MODEL || this.isDirty(DirtyProps.VISIBLE)) {
            json.writeValue("visible", (Object)this.visible);
        }
    }

    public void read(Json json, JsonValue jsonData) {
        Vector2 pos;
        BladeJson bjson = (BladeJson)json;
        if (bjson.getMode() == BladeJson.Mode.MODEL) {
            this.id = (String)json.readValue("id", String.class, jsonData);
            float[] verts = (float[])json.readValue("bbox", float[].class, jsonData);
            if (verts.length > 0) {
                this.bbox.setVertices(verts);
            }
        }
        if ((pos = (Vector2)json.readValue("pos", Vector2.class, jsonData)) != null) {
            float worldScale = EngineAssetManager.getInstance().getScale();
            this.bbox.setPosition(pos.x * worldScale, pos.y * worldScale);
            this.bbox.setScale(worldScale, worldScale);
        }
        this.visible = (Boolean)json.readValue("visible", Boolean.TYPE, (Object)this.visible, jsonData);
        this.dirtyProps = (Long)json.readValue("dirtyProps", Long.TYPE, (Object)0L, jsonData);
    }
}

