/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.model;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.bladecoder.engine.actions.ActionCallback;
import com.bladecoder.engine.anim.SpritePosTween;
import com.bladecoder.engine.anim.Tween;
import com.bladecoder.engine.anim.WalkTween;
import com.bladecoder.engine.assets.EngineAssetManager;
import com.bladecoder.engine.model.AnimationRenderer;
import com.bladecoder.engine.model.Dialog;
import com.bladecoder.engine.model.DirtyProps;
import com.bladecoder.engine.model.SpriteActor;
import com.bladecoder.engine.serialization.BladeJson;
import com.bladecoder.engine.util.EngineLogger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;

public class CharacterActor
extends SpriteActor {
    public static final float DEFAULT_WALKING_SPEED = 1000.0f;
    public static final String DEFAULT_STAND_ANIM = "stand";
    public static final String DEFAULT_WALK_ANIM = "walk";
    public static final String DEFAULT_TALK_ANIM = "talk";
    private float walkingSpeed = 1000.0f;
    private Color textColor;
    private String textStyle;
    private Vector2 talkingTextPos;
    private String standAnim = "stand";
    private String walkAnim = "walk";
    private String talkAnim = "talk";
    private HashMap<String, Dialog> dialogs;

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
        this.setDirtyProp(DirtyProps.TEXT_COLOR);
    }

    public String getTextStyle() {
        return this.textStyle;
    }

    public void setTextStyle(String textStyle) {
        this.textStyle = textStyle;
        this.setDirtyProp(DirtyProps.TEXT_STYLE);
    }

    public String getStandAnim() {
        return this.standAnim;
    }

    public void setStandAnim(String standAnim) {
        this.standAnim = standAnim;
    }

    public String getWalkAnim() {
        return this.walkAnim;
    }

    public void setWalkAnim(String walkAnim) {
        this.walkAnim = walkAnim;
    }

    public String getTalkAnim() {
        return this.talkAnim;
    }

    public void setTalkAnim(String talkAnim) {
        this.talkAnim = talkAnim;
    }

    public Dialog getDialog(String dialog) {
        return this.dialogs.get(dialog);
    }

    public void addDialog(Dialog d) {
        if (this.dialogs == null) {
            this.dialogs = new HashMap();
        }
        this.dialogs.put(d.getId(), d);
    }

    public void setWalkingSpeed(float s) {
        this.walkingSpeed = s;
        this.setDirtyProp(DirtyProps.WALKING_SPEED);
    }

    public float getWalkingSpeed() {
        return this.walkingSpeed;
    }

    public Vector2 getTalkingTextPos() {
        return this.talkingTextPos;
    }

    public void setTalkingTextPos(Vector2 talkingTextPos) {
        this.talkingTextPos = talkingTextPos;
        this.setDirtyProp(DirtyProps.TALKING_TEXT_POS);
    }

    public void lookat(Vector2 p) {
        if (!(this.renderer instanceof AnimationRenderer)) {
            return;
        }
        this.inAnim();
        this.removeTween(SpritePosTween.class);
        ((AnimationRenderer)this.renderer).startAnimation(this.standAnim, Tween.Type.SPRITE_DEFINED, -1, null, new Vector2(this.getBBox().getX(), this.getBBox().getY()), p);
        this.outAnim(Tween.Type.SPRITE_DEFINED);
    }

    public void lookat(String direction) {
        if (!(this.renderer instanceof AnimationRenderer)) {
            return;
        }
        this.inAnim();
        this.removeTween(SpritePosTween.class);
        ((AnimationRenderer)this.renderer).startAnimation(this.standAnim, Tween.Type.SPRITE_DEFINED, -1, null, direction);
        this.outAnim(Tween.Type.SPRITE_DEFINED);
    }

    public void stand() {
        if (!(this.renderer instanceof AnimationRenderer)) {
            return;
        }
        this.inAnim();
        this.removeTween(SpritePosTween.class);
        ((AnimationRenderer)this.renderer).startAnimation(this.standAnim, Tween.Type.SPRITE_DEFINED, -1, null, null);
        this.outAnim(Tween.Type.SPRITE_DEFINED);
    }

    public void talk() {
        if (!(this.renderer instanceof AnimationRenderer)) {
            return;
        }
        this.inAnim();
        this.removeTween(SpritePosTween.class);
        ((AnimationRenderer)this.renderer).startAnimation(this.talkAnim, Tween.Type.SPRITE_DEFINED, -1, null, null);
        this.outAnim(Tween.Type.SPRITE_DEFINED);
    }

    public void startWalkAnim(Vector2 p0, Vector2 pf) {
        if (!(this.renderer instanceof AnimationRenderer)) {
            return;
        }
        this.inAnim();
        ((AnimationRenderer)this.renderer).startAnimation(this.walkAnim, Tween.Type.SPRITE_DEFINED, -1, null, p0, pf);
        this.outAnim(Tween.Type.SPRITE_DEFINED);
    }

    public void goTo(Vector2 pf, ActionCallback cb, boolean ignoreWalkZone) {
        ArrayList<Object> walkingPath;
        EngineLogger.debug(MessageFormat.format("GOTO {0},{1}", Float.valueOf(pf.x), Float.valueOf(pf.y)));
        Vector2 p0 = new Vector2(this.getBBox().getX(), this.getBBox().getY());
        if (this.tweens.size() > 0) {
            this.removeTween(SpritePosTween.class);
            this.stand();
        }
        if (p0.dst(pf) < 2.0f) {
            this.setPosition(pf.x, pf.y);
            if (cb != null) {
                cb.resume();
            }
            return;
        }
        if (this.scene.getWalkZone() != null && !ignoreWalkZone) {
            walkingPath = this.scene.getPolygonalNavGraph().findPath(p0.x, p0.y, pf.x, pf.y);
        } else {
            walkingPath = new ArrayList<Vector2>(2);
            walkingPath.add(p0);
            walkingPath.add(new Vector2(pf));
        }
        if (walkingPath == null || walkingPath.size() == 0) {
            if (cb != null) {
                cb.resume();
            }
            return;
        }
        WalkTween t = new WalkTween();
        t.start(this, walkingPath, this.walkingSpeed, cb);
        this.addTween(t);
    }

    public void fastWalk() {
        for (Tween t : this.tweens) {
            if (!(t instanceof WalkTween)) continue;
            WalkTween wt = (WalkTween)t;
            wt.completeNow(this);
            break;
        }
    }

    public HashMap<String, Dialog> getDialogs() {
        return this.dialogs;
    }

    @Override
    public String toString() {
        return super.toString() + "  Walking Speed: " + this.walkingSpeed + "\nText Color: " + this.textColor;
    }

    @Override
    public void write(Json json) {
        BladeJson bjson;
        super.write(json);
        if (this.dialogs != null) {
            json.writeValue("dialogs", this.dialogs, HashMap.class, Dialog.class);
        }
        if ((bjson = (BladeJson)json).getMode() == BladeJson.Mode.MODEL) {
            if (this.textStyle != null) {
                json.writeValue("textStyle", (Object)this.textStyle);
            }
            if (this.textColor != null) {
                json.writeValue("textColor", (Object)this.textColor);
            }
            if (this.talkingTextPos != null) {
                float worldScale = EngineAssetManager.getInstance().getScale();
                json.writeValue("talkingTextPos", (Object)new Vector2(this.talkingTextPos.x / worldScale, this.talkingTextPos.y / worldScale));
            }
        } else {
            if (!DEFAULT_STAND_ANIM.equals(this.standAnim)) {
                json.writeValue("standAnim", (Object)this.standAnim);
            }
            if (!DEFAULT_WALK_ANIM.equals(this.walkAnim)) {
                json.writeValue("walkAnim", (Object)this.walkAnim);
            }
            if (!DEFAULT_TALK_ANIM.equals(this.talkAnim)) {
                json.writeValue("talkAnim", (Object)this.talkAnim);
            }
            if (this.isDirty(DirtyProps.TEXT_STYLE)) {
                json.writeValue("textStyle", (Object)this.textStyle);
            }
            if (this.isDirty(DirtyProps.TEXT_COLOR)) {
                json.writeValue("textColor", (Object)this.textColor);
            }
            if (this.isDirty(DirtyProps.TALKING_TEXT_POS)) {
                float worldScale = EngineAssetManager.getInstance().getScale();
                json.writeValue("talkingTextPos", (Object)new Vector2(this.talkingTextPos.x / worldScale, this.talkingTextPos.y / worldScale));
            }
        }
        if (bjson.getMode() == BladeJson.Mode.MODEL || this.isDirty(DirtyProps.WALKING_SPEED)) {
            json.writeValue("walkingSpeed", (Object)Float.valueOf(this.walkingSpeed));
        }
    }

    @Override
    public void read(Json json, JsonValue jsonData) {
        super.read(json, jsonData);
        BladeJson bjson = (BladeJson)json;
        if (bjson.getMode() == BladeJson.Mode.MODEL) {
            this.dialogs = (HashMap)json.readValue("dialogs", HashMap.class, Dialog.class, jsonData);
            if (this.dialogs != null) {
                for (Dialog d : this.dialogs.values()) {
                    d.setActor(this);
                }
            }
        } else {
            if (this.dialogs != null) {
                JsonValue dialogsValue = jsonData.get("dialogs");
                for (Dialog d : this.dialogs.values()) {
                    String id = d.getId();
                    JsonValue dValue = dialogsValue.get(id);
                    if (dValue == null) continue;
                    d.read(json, dValue);
                }
            }
            this.standAnim = (String)json.readValue("standAnim", String.class, (Object)DEFAULT_STAND_ANIM, jsonData);
            this.walkAnim = (String)json.readValue("walkAnim", String.class, (Object)DEFAULT_WALK_ANIM, jsonData);
            this.talkAnim = (String)json.readValue("talkAnim", String.class, (Object)DEFAULT_TALK_ANIM, jsonData);
        }
        this.textStyle = (String)json.readValue("textStyle", String.class, (Object)this.textStyle, jsonData);
        this.walkingSpeed = ((Float)json.readValue("walkingSpeed", Float.TYPE, (Object)Float.valueOf(this.walkingSpeed), jsonData)).floatValue();
        this.textColor = (Color)json.readValue("textColor", Color.class, (Object)this.textColor, jsonData);
        this.talkingTextPos = (Vector2)json.readValue("talkingTextPos", Vector2.class, (Object)this.talkingTextPos, jsonData);
        if (this.talkingTextPos != null) {
            float worldScale = EngineAssetManager.getInstance().getScale();
            this.talkingTextPos.x *= worldScale;
            this.talkingTextPos.y *= worldScale;
        }
    }
}

