/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.model;

import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.bladecoder.engine.model.CharacterActor;
import com.bladecoder.engine.model.DialogOption;
import com.bladecoder.engine.serialization.BladeJson;
import java.util.ArrayList;
import java.util.List;

public class Dialog
implements Json.Serializable {
    public static final String DEFAULT_DIALOG_VERB = "dialog";
    private ArrayList<DialogOption> options = new ArrayList();
    private int currentOption = -1;
    private String id;
    private CharacterActor actor;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public CharacterActor getActor() {
        return this.actor;
    }

    public void setActor(CharacterActor actor) {
        this.actor = actor;
    }

    public Dialog selectOption(int i) {
        return this.selectOption(this.getVisibleOptions().get(i));
    }

    public List<String> getChoices() {
        ArrayList<DialogOption> options = this.getVisibleOptions();
        ArrayList<String> choices = new ArrayList<String>(options.size());
        for (DialogOption o : options) {
            choices.add(o.getText());
        }
        return choices;
    }

    public Dialog selectOption(DialogOption o) {
        this.currentOption = this.options.indexOf(o);
        String v = o.getVerbId();
        if (v == null) {
            v = DEFAULT_DIALOG_VERB;
        }
        this.actor.runVerb(v);
        if (o.isOnce()) {
            o.setVisible(false);
        }
        this.currentOption = -1;
        if (o.getNext() != null) {
            String next = o.getNext();
            if (next.equals("this")) {
                return this;
            }
            return this.actor.getDialog(next);
        }
        return null;
    }

    public void addOption(DialogOption o) {
        this.options.add(o);
    }

    public ArrayList<DialogOption> getOptions() {
        return this.options;
    }

    private ArrayList<DialogOption> getVisibleOptions() {
        ArrayList<DialogOption> visible = new ArrayList<DialogOption>();
        for (DialogOption o : this.options) {
            if (!o.isVisible()) continue;
            visible.add(o);
        }
        return visible;
    }

    public void reset() {
        this.currentOption = -1;
    }

    public int getNumVisibleOptions() {
        int num = 0;
        for (DialogOption o : this.getOptions()) {
            if (!o.isVisible()) continue;
            ++num;
        }
        return num;
    }

    public DialogOption getCurrentOption() {
        return this.currentOption == -1 ? null : this.options.get(this.currentOption);
    }

    public void write(Json json) {
        BladeJson bjson = (BladeJson)json;
        if (bjson.getMode() == BladeJson.Mode.MODEL) {
            json.writeValue("id", (Object)this.id);
        } else {
            json.writeValue("currentOption", (Object)this.currentOption);
        }
        json.writeValue("options", this.options, DialogOption.class, DialogOption.class);
    }

    public void read(Json json, JsonValue jsonData) {
        BladeJson bjson = (BladeJson)json;
        if (bjson.getMode() == BladeJson.Mode.MODEL) {
            this.id = (String)json.readValue("id", String.class, jsonData);
            this.options = (ArrayList)json.readValue("options", ArrayList.class, DialogOption.class, jsonData);
        } else {
            JsonValue optionsValue = jsonData.get("options");
            int i = 0;
            for (DialogOption o : this.options) {
                JsonValue jsonValue = optionsValue.get(i);
                if (jsonValue == null) break;
                o.read(json, jsonValue);
                ++i;
            }
            this.currentOption = (Integer)json.readValue("currentOption", Integer.TYPE, jsonData);
        }
    }
}

