/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.model;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Polygon;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.bladecoder.engine.actions.ActionCallback;
import com.bladecoder.engine.actions.SceneActorRef;
import com.bladecoder.engine.anim.Timers;
import com.bladecoder.engine.assets.AssetConsumer;
import com.bladecoder.engine.assets.EngineAssetManager;
import com.bladecoder.engine.model.AnchorActor;
import com.bladecoder.engine.model.BaseActor;
import com.bladecoder.engine.model.CharacterActor;
import com.bladecoder.engine.model.InteractiveActor;
import com.bladecoder.engine.model.Inventory;
import com.bladecoder.engine.model.MusicDesc;
import com.bladecoder.engine.model.ObstacleActor;
import com.bladecoder.engine.model.SceneCamera;
import com.bladecoder.engine.model.SceneLayer;
import com.bladecoder.engine.model.SceneSoundManager;
import com.bladecoder.engine.model.SpriteActor;
import com.bladecoder.engine.model.TextManager;
import com.bladecoder.engine.model.Verb;
import com.bladecoder.engine.model.VerbManager;
import com.bladecoder.engine.model.WalkZoneActor;
import com.bladecoder.engine.model.World;
import com.bladecoder.engine.polygonalpathfinder.NavNodePolygonal;
import com.bladecoder.engine.polygonalpathfinder.PolygonalNavGraph;
import com.bladecoder.engine.serialization.BladeJson;
import com.bladecoder.engine.util.EngineLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;

public class Scene
implements Json.Serializable,
AssetConsumer {
    public static final Color ACTOR_BBOX_COLOR = new Color(0.2f, 0.2f, 0.8f, 1.0f);
    public static final Color WALKZONE_COLOR = Color.GREEN;
    public static final Color OBSTACLE_COLOR = Color.RED;
    public static final Color ANCHOR_COLOR = Color.RED;
    public static final float ANCHOR_RADIUS = 14.0f;
    public static final String VAR_PLAYER = "$PLAYER";
    public static final String VAR_PLAYER_2 = "$P";
    private Map<String, BaseActor> actors = new ConcurrentHashMap<String, BaseActor>();
    private List<SceneLayer> layers = new ArrayList<SceneLayer>();
    private Timers timers = new Timers();
    private SceneCamera camera = new SceneCamera();
    private Array<TextureAtlas.AtlasRegion> background;
    private String backgroundAtlas;
    private String backgroundRegionId;
    private final PolygonalNavGraph polygonalNavGraph = new PolygonalNavGraph();
    private Vector2 depthVector;
    private String player;
    private SpriteActor followActor;
    private MusicDesc musicDesc;
    private Vector2 sceneSize;
    private String id;
    private String state;
    private final VerbManager verbs = new VerbManager();
    private final SceneSoundManager soundManager;
    private final TextManager textManager;
    private final World w;
    private String walkZone;
    private final Rectangle tmpToleranceRect = new Rectangle();

    public Scene(World w) {
        this.w = w;
        this.textManager = new TextManager(this);
        this.soundManager = new SceneSoundManager(w);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String s) {
        this.state = s;
    }

    public List<SceneLayer> getLayers() {
        return this.layers;
    }

    public SceneLayer getLayer(String name) {
        for (SceneLayer l : this.layers) {
            if (!name.equals(l.getName())) continue;
            return l;
        }
        return null;
    }

    public void addLayer(SceneLayer layer) {
        this.layers.add(layer);
    }

    public TextManager getTextManager() {
        return this.textManager;
    }

    public World getWorld() {
        return this.w;
    }

    public Timers getTimers() {
        return this.timers;
    }

    public void addTimer(float time, ActionCallback cb) {
        this.timers.addTimer(time, cb);
    }

    public MusicDesc getMusicDesc() {
        return this.musicDesc;
    }

    public void setMusicDesc(MusicDesc musicDesc) {
        this.musicDesc = musicDesc;
    }

    public float getFakeDepthScale(float y) {
        if (this.depthVector == null) {
            return 1.0f;
        }
        float worldScale = EngineAssetManager.getInstance().getScale();
        return Math.max(0.0f, (y - this.depthVector.x * worldScale) / ((this.depthVector.y - this.depthVector.x) * worldScale));
    }

    public void init() {
        this.timers.clear();
        this.textManager.reset();
    }

    public VerbManager getVerbManager() {
        return this.verbs;
    }

    public Verb getVerb(String id) {
        return this.verbs.getVerb(id, this.state, null);
    }

    public void runVerb(String id) {
        this.verbs.runVerb(id, this.state, null, null);
    }

    public void update(float delta) {
        this.camera.update(delta);
        if (this.followActor != null) {
            this.camera.updatePos(this.followActor);
        }
        this.timers.update(delta);
        this.textManager.update(delta);
        for (BaseActor a : this.actors.values()) {
            if (this.w.getCurrentScene() != this) break;
            a.update(delta);
        }
        for (SceneLayer layer : this.layers) {
            layer.update();
        }
    }

    public void draw(SpriteBatch batch) {
        if (this.background != null) {
            batch.disableBlending();
            batch.setProjectionMatrix(this.camera.calculateParallaxMatrix(1.0f, 1.0f));
            batch.begin();
            float x = 0.0f;
            for (TextureAtlas.AtlasRegion tile : this.background) {
                batch.draw((TextureRegion)tile, x, 0.0f);
                x += (float)tile.getRegionWidth();
            }
            batch.end();
            batch.enableBlending();
        }
        for (int i = this.layers.size() - 1; i >= 0; --i) {
            SceneLayer layer = this.layers.get(i);
            batch.setProjectionMatrix(this.camera.calculateParallaxMatrix(layer.getParallaxMultiplier(), 1.0f));
            batch.begin();
            layer.draw(batch);
            batch.end();
        }
    }

    public void drawBBoxLines(ShapeRenderer renderer) {
        renderer.begin(ShapeRenderer.ShapeType.Line);
        for (BaseActor a : this.actors.values()) {
            Polygon p = a.getBBox();
            if (p == null) {
                EngineLogger.error("ERROR DRAWING BBOX FOR: " + a.getId());
            }
            if (a instanceof ObstacleActor) {
                renderer.setColor(OBSTACLE_COLOR);
                renderer.polygon(p.getTransformedVertices());
                continue;
            }
            if (a instanceof AnchorActor) {
                renderer.setColor(ANCHOR_COLOR);
                renderer.line(p.getX() - 14.0f, p.getY(), p.getX() + 14.0f, p.getY());
                renderer.line(p.getX(), p.getY() - 14.0f, p.getX(), p.getY() + 14.0f);
                continue;
            }
            renderer.setColor(ACTOR_BBOX_COLOR);
            renderer.polygon(p.getTransformedVertices());
        }
        if (this.walkZone != null) {
            renderer.setColor(WALKZONE_COLOR);
            renderer.polygon(this.polygonalNavGraph.getWalkZone().getTransformedVertices());
            renderer.setColor(Color.WHITE);
            ArrayList<NavNodePolygonal> nodes = this.polygonalNavGraph.getGraphNodes();
            for (NavNodePolygonal n : nodes) {
                for (NavNodePolygonal n2 : n.neighbors) {
                    renderer.line(n.x, n.y, n2.x, n2.y);
                }
            }
        }
        renderer.end();
    }

    public BaseActor getActor(String id, boolean searchInventory) {
        BaseActor a;
        if ((VAR_PLAYER.equals(id) || VAR_PLAYER_2.equals(id)) && this.player != null) {
            return this.actors.get(this.player);
        }
        BaseActor baseActor = a = id == null ? null : this.actors.get(id);
        if (a == null && searchInventory) {
            for (Inventory i : this.w.getInventories().values()) {
                a = i.get(id);
                if (a == null) continue;
                return a;
            }
            a = this.w.getUIActors().get(id);
        }
        return a;
    }

    public Map<String, BaseActor> getActors() {
        return this.actors;
    }

    public void addActor(BaseActor actor) {
        BaseActor prev = this.actors.put(actor.getId(), actor);
        if (prev != null) {
            EngineLogger.error("Actor '" + actor.getId() + "' already exists in scene '" + this.id + "'.");
        }
        actor.setScene(this);
        if (actor instanceof InteractiveActor) {
            InteractiveActor ia = (InteractiveActor)actor;
            SceneLayer layer = this.getLayer(ia.getLayer());
            if (layer == null) {
                layer = new SceneLayer();
                layer.setName(ia.getLayer());
                this.layers.add(layer);
            }
            layer.add(ia);
        }
    }

    public void setBackground(String bgAtlas, String bgId, String lightMapAtlas, String lightMapId) {
        this.backgroundAtlas = bgAtlas;
        this.backgroundRegionId = bgId;
    }

    public InteractiveActor getInteractiveActorAt(float x, float y) {
        for (SceneLayer layer : this.layers) {
            if (!layer.isVisible()) continue;
            for (int i = layer.getActors().size() - 1; i >= 0; --i) {
                BaseActor a = layer.getActors().get(i);
                if (!(a instanceof InteractiveActor) || !((InteractiveActor)a).canInteract() || !a.hit(x, y)) continue;
                return (InteractiveActor)a;
            }
        }
        return null;
    }

    public InteractiveActor getInteractiveActorAt(float x, float y, float tolerance) {
        if (tolerance <= 0.0f) {
            return this.getInteractiveActorAt(x, y);
        }
        List<SceneLayer> layers = this.getLayers();
        this.tmpToleranceRect.x = x - tolerance / 2.0f;
        this.tmpToleranceRect.y = y - tolerance / 2.0f;
        this.tmpToleranceRect.width = tolerance;
        this.tmpToleranceRect.height = tolerance;
        for (SceneLayer layer : layers) {
            if (!layer.isVisible()) continue;
            for (int l = layer.getActors().size() - 1; l >= 0; --l) {
                BaseActor a = layer.getActors().get(l);
                if (!(a instanceof InteractiveActor) || !((InteractiveActor)a).canInteract()) continue;
                if (a.hit(x, y) || a.hit(this.tmpToleranceRect.x, this.tmpToleranceRect.y) || a.hit(this.tmpToleranceRect.x + this.tmpToleranceRect.width, this.tmpToleranceRect.y) || a.hit(this.tmpToleranceRect.x, this.tmpToleranceRect.y + this.tmpToleranceRect.height) || a.hit(this.tmpToleranceRect.x + this.tmpToleranceRect.width, this.tmpToleranceRect.y + this.tmpToleranceRect.height)) {
                    return (InteractiveActor)a;
                }
                float[] verts = a.getBBox().getTransformedVertices();
                for (int i = 0; i < verts.length; i += 2) {
                    float vx = verts[i];
                    float vy = verts[i + 1];
                    if (!this.tmpToleranceRect.contains(vx, vy)) continue;
                    return (InteractiveActor)a;
                }
            }
        }
        return null;
    }

    public BaseActor getActorAt(float x, float y) {
        for (BaseActor a : this.actors.values()) {
            float dst;
            if (!(a instanceof AnchorActor) || !((dst = Vector2.dst((float)x, (float)y, (float)a.getX(), (float)a.getY())) < 14.0f)) continue;
            return a;
        }
        for (SceneLayer layer : this.layers) {
            if (!layer.isVisible()) continue;
            for (int i = layer.getActors().size() - 1; i >= 0; --i) {
                BaseActor a = layer.getActors().get(i);
                if (!a.hit(x, y)) continue;
                return a;
            }
        }
        for (BaseActor a : this.actors.values()) {
            if (!(a instanceof ObstacleActor) || !a.hit(x, y)) continue;
            return a;
        }
        for (BaseActor a : this.actors.values()) {
            if (!(a instanceof WalkZoneActor) || !a.hit(x, y)) continue;
            return a;
        }
        return null;
    }

    public void setPlayer(CharacterActor a) {
        if (a != null) {
            this.player = a.getId();
            a.setInteraction(false);
        } else {
            this.player = null;
        }
    }

    public CharacterActor getPlayer() {
        if (this.player == null) {
            return null;
        }
        return (CharacterActor)this.actors.get(this.player);
    }

    public String getWalkZone() {
        return this.walkZone;
    }

    public void setWalkZone(String walkZone) {
        this.walkZone = walkZone;
    }

    public Vector2 getDepthVector() {
        return this.depthVector;
    }

    public void setDepthVector(Vector2 v) {
        this.depthVector = v;
    }

    public String getBackgroundAtlas() {
        return this.backgroundAtlas;
    }

    public void setBackgroundAtlas(String backgroundAtlas) {
        this.backgroundAtlas = backgroundAtlas;
    }

    public String getBackgroundRegionId() {
        return this.backgroundRegionId;
    }

    public void setBackgroundRegionId(String backgroundRegionId) {
        this.backgroundRegionId = backgroundRegionId;
    }

    public void removeActor(BaseActor a) {
        BaseActor r;
        if (a.getId().equals(this.player)) {
            this.player = null;
        }
        if ((r = this.actors.remove(a.getId())) == null) {
            EngineLogger.error("Removing actor from scene: Actor not found");
            return;
        }
        if (a instanceof InteractiveActor) {
            InteractiveActor ia = (InteractiveActor)a;
            SceneLayer layer = this.getLayer(ia.getLayer());
            layer.getActors().remove(ia);
        }
        if (a instanceof ObstacleActor && this.walkZone != null) {
            this.polygonalNavGraph.removeDinamicObstacle(a.getBBox());
        }
        a.setScene(null);
    }

    public Array<TextureAtlas.AtlasRegion> getBackground() {
        return this.background;
    }

    public SceneCamera getCamera() {
        return this.camera;
    }

    public void resetCamera(float worldWidth, float worldHeight) {
        this.camera.create(worldWidth, worldHeight);
        if (this.getPlayer() != null) {
            this.setCameraFollowActor(this.getPlayer());
        }
    }

    public void setCameraFollowActor(SpriteActor a) {
        this.followActor = a;
        if (a != null) {
            this.camera.updatePos(a);
        }
    }

    public SpriteActor getCameraFollowActor() {
        return this.followActor;
    }

    public SceneSoundManager getSoundManager() {
        return this.soundManager;
    }

    public void calcWalkzone() {
        if (this.walkZone != null) {
            this.polygonalNavGraph.createInitialGraph(this.actors.get(this.walkZone), this.actors.values());
        }
    }

    @Override
    public void loadAssets() {
        this.soundManager.loadAssets();
        this.textManager.getVoiceManager().loadAssets();
        if (this.backgroundAtlas != null && !this.backgroundAtlas.isEmpty()) {
            EngineAssetManager.getInstance().loadAtlas(this.backgroundAtlas);
        }
        for (BaseActor a : this.actors.values()) {
            if (!(a instanceof AssetConsumer)) continue;
            ((AssetConsumer)((Object)a)).loadAssets();
        }
        this.calcWalkzone();
    }

    @Override
    public void retrieveAssets() {
        if (this.backgroundAtlas != null && !this.backgroundAtlas.isEmpty()) {
            this.background = EngineAssetManager.getInstance().getRegions(this.backgroundAtlas, this.backgroundRegionId);
            int width = 0;
            for (int i = 0; i < this.background.size; ++i) {
                width += ((TextureAtlas.AtlasRegion)this.background.get(i)).getRegionWidth();
            }
            int height = ((TextureAtlas.AtlasRegion)this.background.get(0)).getRegionHeight();
            if (this.sceneSize == null) {
                this.camera.setScrollingDimensions(width, height);
            }
        }
        if (this.sceneSize != null) {
            float scale = EngineAssetManager.getInstance().getScale();
            this.camera.setScrollingDimensions(this.sceneSize.x * scale, this.sceneSize.y * scale);
        }
        this.soundManager.retrieveAssets();
        this.textManager.getVoiceManager().retrieveAssets();
        for (BaseActor a : this.actors.values()) {
            if (!(a instanceof AssetConsumer)) continue;
            ((AssetConsumer)((Object)a)).retrieveAssets();
        }
        if (this.getWorld().getListener() != null) {
            this.getWorld().getListener().text(this.textManager.getCurrentText());
        }
    }

    public void dispose() {
        if (this.backgroundAtlas != null && !this.backgroundAtlas.isEmpty()) {
            EngineAssetManager.getInstance().disposeAtlas(this.backgroundAtlas);
        }
        for (BaseActor a : this.actors.values()) {
            if (!(a instanceof AssetConsumer)) continue;
            ((AssetConsumer)((Object)a)).dispose();
        }
        this.soundManager.dispose();
        this.getTextManager().getVoiceManager().dispose();
    }

    public Vector2 getSceneSize() {
        return this.sceneSize;
    }

    public void setSceneSize(Vector2 sceneSize) {
        this.sceneSize = sceneSize;
    }

    public void orderLayersByZIndex() {
        for (SceneLayer l : this.layers) {
            l.orderByZIndex();
        }
    }

    public PolygonalNavGraph getPolygonalNavGraph() {
        return this.polygonalNavGraph;
    }

    public void write(Json json) {
        BladeJson bjson = (BladeJson)json;
        bjson.setScene(this);
        if (bjson.getMode() == BladeJson.Mode.MODEL) {
            json.writeValue("id", (Object)this.id);
            json.writeValue("layers", this.layers, this.layers.getClass(), SceneLayer.class);
            TreeMap<String, BaseActor> sortedActors = new TreeMap<String, BaseActor>(this.actors);
            json.writeValue("actors", sortedActors);
            if (this.backgroundAtlas != null) {
                json.writeValue("backgroundAtlas", (Object)this.backgroundAtlas);
                json.writeValue("backgroundRegionId", (Object)this.backgroundRegionId);
            }
            json.writeValue("musicDesc", (Object)this.musicDesc);
            if (this.depthVector != null) {
                json.writeValue("depthVector", (Object)this.depthVector);
            }
            if (this.sceneSize != null) {
                json.writeValue("sceneSize", (Object)this.sceneSize);
            }
        } else {
            json.writeObjectStart("actors");
            TreeMap<String, BaseActor> sortedActors = new TreeMap<String, BaseActor>(this.actors);
            for (BaseActor a : sortedActors.values()) {
                SceneActorRef actorRef = new SceneActorRef(a.getInitScene(), a.getId());
                json.writeValue(actorRef.toString(), (Object)a);
            }
            json.writeObjectEnd();
            json.writeValue("camera", (Object)this.camera);
            if (this.followActor != null) {
                json.writeValue("followActor", (Object)this.followActor.getId());
            }
            this.soundManager.write(json);
            if (!this.timers.isEmpty()) {
                json.writeValue("timers", (Object)this.timers);
            }
            if (this.textManager.getCurrentText() != null) {
                json.writeValue("textmanager", (Object)this.textManager);
            }
        }
        this.verbs.write(json);
        if (this.state != null) {
            json.writeValue("state", (Object)this.state);
        }
        if (this.player != null) {
            json.writeValue("player", (Object)this.player);
        }
        json.writeValue("walkZone", (Object)this.walkZone);
        bjson.setScene(null);
    }

    public void read(Json json, JsonValue jsonData) {
        BladeJson bjson = (BladeJson)json;
        bjson.setScene(this);
        if (bjson.getMode() == BladeJson.Mode.MODEL) {
            this.id = (String)json.readValue("id", String.class, jsonData);
            this.layers = (List)json.readValue("layers", ArrayList.class, SceneLayer.class, jsonData);
            this.actors = (Map)json.readValue("actors", ConcurrentHashMap.class, BaseActor.class, jsonData);
            for (BaseActor actor : this.actors.values()) {
                actor.setScene(this);
                actor.setInitScene(this.id);
                if (!(actor instanceof InteractiveActor)) continue;
                InteractiveActor ia = (InteractiveActor)actor;
                SceneLayer layer = this.getLayer(ia.getLayer());
                layer.add(ia);
            }
            this.orderLayersByZIndex();
            this.backgroundAtlas = (String)json.readValue("backgroundAtlas", String.class, jsonData);
            this.backgroundRegionId = (String)json.readValue("backgroundRegionId", String.class, jsonData);
            this.musicDesc = (MusicDesc)json.readValue("musicDesc", MusicDesc.class, jsonData);
            this.depthVector = (Vector2)json.readValue("depthVector", Vector2.class, jsonData);
            this.sceneSize = (Vector2)json.readValue("sceneSize", Vector2.class, jsonData);
            if (jsonData.get("polygonalNavGraph") != null) {
                JsonValue jsonValuePNG = jsonData.get("polygonalNavGraph");
                float worldScale = EngineAssetManager.getInstance().getScale();
                Polygon walkZonePol = (Polygon)json.readValue("walkZone", Polygon.class, jsonValuePNG);
                walkZonePol.setScale(worldScale, worldScale);
                walkZonePol.setPosition(walkZonePol.getX() * worldScale, walkZonePol.getY() * worldScale);
                WalkZoneActor wz = new WalkZoneActor();
                wz.setId("walkzone");
                wz.getBBox().setVertices(walkZonePol.getVertices());
                wz.getBBox().setScale(walkZonePol.getScaleX(), walkZonePol.getScaleY());
                wz.getBBox().setPosition(walkZonePol.getX(), walkZonePol.getY());
                wz.setScene(this);
                wz.setInitScene(this.id);
                this.actors.put(wz.getId(), wz);
                this.walkZone = wz.getId();
            }
        } else {
            SceneActorRef actorRef;
            JsonValue jsonValueAct;
            int i;
            JsonValue jsonValueActors = jsonData.get("actors");
            for (i = 0; i < jsonValueActors.size; ++i) {
                jsonValueAct = jsonValueActors.get(i);
                actorRef = new SceneActorRef(jsonValueAct.name);
                Scene sourceScn = this.w.getScene(actorRef.getSceneId());
                if (sourceScn == this) continue;
                BaseActor actor = sourceScn.getActor(actorRef.getActorId(), false);
                sourceScn.removeActor(actor);
                this.addActor(actor);
            }
            for (i = 0; i < jsonValueActors.size; ++i) {
                jsonValueAct = jsonValueActors.get(i);
                actorRef = new SceneActorRef(jsonValueAct.name);
                BaseActor actor = this.getActor(actorRef.getActorId(), false);
                if (actor != null) {
                    actor.read(json, jsonValueAct);
                    continue;
                }
                EngineLogger.debug("Actor not found: " + actorRef);
            }
            this.orderLayersByZIndex();
            this.camera = (SceneCamera)((Object)json.readValue("camera", SceneCamera.class, jsonData));
            String followActorId = (String)json.readValue("followActor", String.class, jsonData);
            if (followActorId != null) {
                this.setCameraFollowActor((SpriteActor)this.actors.get(followActorId));
            } else {
                this.setCameraFollowActor(null);
            }
            this.soundManager.read(json, jsonData);
            if (jsonData.get("timers") != null) {
                this.timers = (Timers)json.readValue("timers", Timers.class, jsonData);
            }
            if (jsonData.get("textmanager") != null) {
                this.textManager.read(json, jsonData.get("textmanager"));
            }
        }
        this.verbs.read(json, jsonData);
        this.state = (String)json.readValue("state", String.class, jsonData);
        this.player = (String)json.readValue("player", String.class, jsonData);
        if (jsonData.get("walkZone") != null) {
            this.walkZone = (String)json.readValue("walkZone", String.class, jsonData);
        }
        bjson.setScene(null);
    }
}

