/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.model;

import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.bladecoder.engine.assets.AssetConsumer;
import com.bladecoder.engine.assets.EngineAssetManager;
import com.bladecoder.engine.model.SoundDesc;
import com.bladecoder.engine.model.World;
import com.bladecoder.engine.util.EngineLogger;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Map;

public class SceneSoundManager
implements Json.Serializable,
AssetConsumer {
    private HashMap<String, LoadedSound> loadedSounds = new HashMap(0);
    private final World w;
    public static float VOLUME_MULTIPLIER = 1.0f;

    public SceneSoundManager(World w) {
        this.w = w;
    }

    public void addSoundToLoad(SoundDesc s) {
        this.loadedSounds.put(s.getId(), new LoadedSound(s));
    }

    public void playSound(String id) {
        SoundDesc sd;
        LoadedSound s = this.loadedSounds.get(id);
        if (s == null && (sd = this.w.getSounds().get(id)) != null) {
            this.addSoundToLoad(sd);
            s = this.loadedSounds.get(id);
            EngineLogger.debug("LOADING SOUND: " + s.desc.getId() + " - " + s.desc.getFilename());
            try {
                EngineAssetManager.getInstance().loadSound(s.desc.getFilename());
            }
            catch (FileNotFoundException e) {
                EngineLogger.error("Sound file not found:" + e.getMessage());
                return;
            }
            EngineAssetManager.getInstance().finishLoading();
            s.sound = EngineAssetManager.getInstance().getSound(s.desc.getFilename());
        }
        if (s != null && s.sound != null) {
            if (s.desc.getLoop()) {
                s.sound.loop(s.desc.getVolume() * VOLUME_MULTIPLIER, s.desc.getPitch(), s.desc.getPan());
            } else {
                s.sound.play(s.desc.getVolume() * VOLUME_MULTIPLIER, s.desc.getPitch(), s.desc.getPan());
            }
            s.playing = true;
        } else {
            EngineLogger.error("Sound Not Found: " + id);
        }
    }

    public void stopCurrentSound(String actor) {
        for (LoadedSound s : this.loadedSounds.values()) {
            String start = actor + "_";
            if (!s.desc.getId().startsWith(start) || !s.playing) continue;
            this.stopSound(s.desc.getId());
        }
    }

    public void stopSound(String id) {
        LoadedSound s = this.loadedSounds.get(id);
        if (s != null) {
            s.sound.stop();
            s.playing = false;
        } else {
            EngineLogger.debug("Sound Not Found: " + id);
        }
    }

    public void stop() {
        for (LoadedSound s : this.loadedSounds.values()) {
            if (!s.playing || s.sound == null) continue;
            this.stopSound(s.desc.getId());
        }
    }

    public void resume() {
        for (LoadedSound s : this.loadedSounds.values()) {
            if (!s.playing || s.sound == null) continue;
            s.sound.resume();
        }
    }

    public void pause() {
        for (LoadedSound s : this.loadedSounds.values()) {
            if (!s.playing || s.sound == null) continue;
            s.sound.pause();
        }
    }

    public void dispose() {
        for (LoadedSound s : this.loadedSounds.values()) {
            if (s.playing) {
                s.sound.stop();
            }
            EngineAssetManager.getInstance().disposeSound(s.desc.getFilename());
        }
    }

    @Override
    public void loadAssets() {
        for (LoadedSound s : this.loadedSounds.values()) {
            try {
                EngineAssetManager.getInstance().loadSound(s.desc.getFilename());
            }
            catch (FileNotFoundException e) {
                this.loadedSounds.remove(s.desc.getId());
                EngineLogger.error("Sound file not found:" + e.getMessage());
            }
        }
    }

    @Override
    public void retrieveAssets() {
        for (LoadedSound s : this.loadedSounds.values()) {
            s.sound = EngineAssetManager.getInstance().getSound(s.desc.getFilename());
            if (!s.playing) continue;
            s.playing = false;
            if (!s.desc.getLoop()) continue;
            this.playSound(s.desc.getId());
        }
    }

    public void write(Json json) {
        json.writeValue("loadedSounds", this.loadedSounds, this.loadedSounds.getClass(), LoadedSound.class);
    }

    public void read(Json json, JsonValue jsonData) {
        this.loadedSounds = (HashMap)json.readValue("loadedSounds", HashMap.class, LoadedSound.class, jsonData);
        if (this.loadedSounds == null) {
            this.loadedSounds = new HashMap(0);
        }
        for (Map.Entry<String, LoadedSound> e : this.loadedSounds.entrySet()) {
            e.getValue().desc = this.w.getSounds().get(e.getKey());
        }
    }

    public static class LoadedSound {
        transient SoundDesc desc;
        transient Sound sound;
        boolean playing = false;

        public LoadedSound(SoundDesc s) {
            this.desc = s;
        }

        public LoadedSound() {
        }
    }
}

