/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.model;

import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.freetype.FreetypeFontLoader;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Polygon;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.bladecoder.engine.assets.EngineAssetManager;
import com.bladecoder.engine.model.ActorRenderer;
import com.bladecoder.engine.model.World;
import com.bladecoder.engine.serialization.BladeJson;
import com.bladecoder.engine.util.RectangleRenderer;

public class TextRenderer
implements ActorRenderer {
    private static final float DEFAULT_DIM = 200.0f;
    private Polygon bbox;
    private BitmapFont font;
    private final GlyphLayout layout = new GlyphLayout();
    private int fontSize = 10;
    private String text;
    private String fontName;
    private int borderWidth = 0;
    private Color borderColor = Color.BLACK;
    private boolean borderStraight = false;
    private int shadowOffsetX = 0;
    private int shadowOffsetY = 0;
    private Color shadowColor = Color.BLACK;
    private int textAlign = 8;
    private int orgAlign = 4;
    private int maxWidth = 0;
    private final Color color = new Color(Color.WHITE);
    private transient String editorTranslatedText;
    private World world;
    private static final Matrix4 tmp = new Matrix4();

    @Override
    public int getOrgAlign() {
        return this.orgAlign;
    }

    @Override
    public void setOrgAlign(int align) {
        this.orgAlign = align;
    }

    @Override
    public void update(float delta) {
    }

    @Override
    public void draw(SpriteBatch batch, float x, float y, float scaleX, float scaleY, float rotation, Color tint) {
        float dx = TextRenderer.getAlignDx(this.getWidth(), this.orgAlign);
        float dy = TextRenderer.getAlignDy(this.getHeight(), this.orgAlign);
        if (this.font != null && this.text != null) {
            if (tint != null && !tint.equals((Object)this.color)) {
                this.color.set(tint);
                String tt = this.text;
                if (tt.charAt(0) == '@') {
                    tt = this.world.getI18N().getString(tt.substring(1));
                }
                if (this.editorTranslatedText != null) {
                    tt = this.editorTranslatedText;
                }
                this.layout.setText(this.font, (CharSequence)tt, this.color, (float)this.maxWidth, this.textAlign, this.maxWidth > 0);
            }
            Matrix4 tm = batch.getTransformMatrix();
            tmp.set(tm);
            float originX = dx;
            float originY = this.layout.height + dy;
            if (this.textAlign == 16) {
                originX += this.getWidth();
            } else if (this.textAlign == 1) {
                originX += this.getWidth() / 2.0f;
            }
            tm.translate(x, y, 0.0f).rotate(0.0f, 0.0f, 1.0f, rotation).scale(scaleX, scaleY, 1.0f).translate(originX, originY, 0.0f);
            batch.setTransformMatrix(tm);
            this.font.draw((Batch)batch, this.layout, 0.0f, 0.0f);
            batch.setTransformMatrix(tmp);
        } else {
            RectangleRenderer.draw((Batch)batch, x + dx * scaleX, y + dy * scaleY, this.getWidth() * scaleX, this.getHeight() * scaleY, Color.RED);
        }
    }

    @Override
    public float getWidth() {
        if (this.font == null) {
            return 200.0f;
        }
        return this.layout.width;
    }

    @Override
    public float getHeight() {
        if (this.font == null) {
            return 200.0f;
        }
        return this.layout.height;
    }

    @Override
    public void updateBboxFromRenderer(Polygon bbox) {
        this.bbox = bbox;
        this.computeBbox();
    }

    private void computeBbox() {
        if (this.bbox == null) {
            return;
        }
        if (this.bbox.getVertices() == null || this.bbox.getVertices().length != 8) {
            this.bbox.setVertices(new float[8]);
        }
        float dx = TextRenderer.getAlignDx(this.getWidth(), this.orgAlign);
        float dy = TextRenderer.getAlignDy(this.getHeight(), this.orgAlign);
        float[] verts = this.bbox.getVertices();
        verts[0] = dx;
        verts[1] = dy;
        verts[2] = dx;
        verts[3] = this.getHeight() + dy;
        verts[4] = this.getWidth() + dx;
        verts[5] = this.getHeight() + dy;
        verts[6] = this.getWidth() + dx;
        verts[7] = dy;
        this.bbox.dirty();
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.setText(text, text);
    }

    public void setText(String text, String translatedText) {
        this.text = text;
        this.editorTranslatedText = translatedText;
        this.updateLayout();
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(int borderWidth) {
        this.borderWidth = borderWidth;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    public boolean isBorderStraight() {
        return this.borderStraight;
    }

    public void setBorderStraight(boolean borderStraight) {
        this.borderStraight = borderStraight;
    }

    public int getShadowOffsetX() {
        return this.shadowOffsetX;
    }

    public void setShadowOffsetX(int shadowOffsetX) {
        this.shadowOffsetX = shadowOffsetX;
    }

    public int getShadowOffsetY() {
        return this.shadowOffsetY;
    }

    public void setShadowOffsetY(int shadowOffsetY) {
        this.shadowOffsetY = shadowOffsetY;
    }

    public Color getShadowColor() {
        return this.shadowColor;
    }

    public void setShadowColor(Color shadowColor) {
        this.shadowColor = shadowColor;
    }

    public int getAlign() {
        return this.textAlign;
    }

    public void setAlign(int align) {
        this.textAlign = align;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public void setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
    }

    public static float getAlignDx(float width, int align) {
        if ((align & 8) != 0) {
            return 0.0f;
        }
        if ((align & 0x10) != 0) {
            return -width;
        }
        if ((align & 1) != 0) {
            return -width / 2.0f;
        }
        return -width / 2.0f;
    }

    public static float getAlignDy(float height, int align) {
        if ((align & 4) != 0) {
            return 0.0f;
        }
        if ((align & 2) != 0) {
            return -height;
        }
        if ((align & 1) != 0) {
            return -height / 2.0f;
        }
        return 0.0f;
    }

    @Override
    public void loadAssets() {
        FreetypeFontLoader.FreeTypeFontLoaderParameter params = new FreetypeFontLoader.FreeTypeFontLoaderParameter();
        float scale = EngineAssetManager.getInstance().getScale();
        params.fontFileName = "ui/fonts/" + this.fontName + ".ttf";
        params.fontParameters.size = (int)((float)this.fontSize * scale);
        params.fontParameters.borderWidth = (int)((float)this.borderWidth * scale);
        params.fontParameters.borderColor = this.borderColor;
        params.fontParameters.borderStraight = this.borderStraight;
        params.fontParameters.shadowOffsetX = (int)((float)this.shadowOffsetX * scale);
        params.fontParameters.shadowOffsetY = (int)((float)this.shadowOffsetY * scale);
        params.fontParameters.shadowColor = this.shadowColor;
        params.fontParameters.characters = "";
        params.fontParameters.incremental = true;
        params.fontParameters.magFilter = Texture.TextureFilter.Linear;
        params.fontParameters.minFilter = Texture.TextureFilter.Linear;
        EngineAssetManager.getInstance().load(this.fontName + this.getFontSize() + ".ttf", BitmapFont.class, (AssetLoaderParameters)params);
    }

    private void updateLayout() {
        if (this.font == null) {
            return;
        }
        String tt = this.editorTranslatedText;
        if (tt == null) {
            tt = this.text;
        }
        if (tt.charAt(0) == '@') {
            tt = this.world.getI18N().getString(tt.substring(1));
        }
        this.layout.setText(this.font, (CharSequence)tt, this.color, (float)this.maxWidth, this.textAlign, this.maxWidth > 0);
        this.computeBbox();
    }

    @Override
    public void retrieveAssets() {
        if (!EngineAssetManager.getInstance().isLoaded(this.fontName + this.getFontSize() + ".ttf")) {
            this.loadAssets();
            EngineAssetManager.getInstance().finishLoading();
        }
        this.font = (BitmapFont)EngineAssetManager.getInstance().get(this.fontName + this.getFontSize() + ".ttf", BitmapFont.class);
        this.updateLayout();
    }

    public void dispose() {
        if (EngineAssetManager.getInstance().isLoaded(this.fontName + this.getFontSize() + ".ttf")) {
            EngineAssetManager.getInstance().unload(this.fontName + this.getFontSize() + ".ttf");
        }
        this.font = null;
    }

    public void write(Json json) {
        BladeJson bjson = (BladeJson)json;
        if (bjson.getMode() == BladeJson.Mode.MODEL) {
            json.writeValue("text", (Object)this.text);
            json.writeValue("fontName", (Object)this.fontName);
            json.writeValue("fontSize", (Object)this.fontSize);
            json.writeValue("borderWidth", (Object)this.borderWidth);
            json.writeValue("borderColor", (Object)this.borderColor);
            json.writeValue("borderStraight", (Object)this.borderStraight);
            json.writeValue("shadowOffsetX", (Object)this.shadowOffsetX);
            json.writeValue("shadowOffsetY", (Object)this.shadowOffsetY);
            json.writeValue("shadowColor", (Object)this.shadowColor);
            json.writeValue("align", (Object)this.textAlign);
            json.writeValue("orgAlign", (Object)this.orgAlign);
            json.writeValue("maxWidth", (Object)this.maxWidth);
        }
    }

    public void read(Json json, JsonValue jsonData) {
        BladeJson bjson = (BladeJson)json;
        if (bjson.getMode() == BladeJson.Mode.MODEL) {
            this.text = (String)json.readValue("text", String.class, jsonData);
            this.fontName = (String)json.readValue("fontName", String.class, jsonData);
            this.fontSize = (Integer)json.readValue("fontSize", Integer.TYPE, jsonData);
            this.borderWidth = (Integer)json.readValue("borderWidth", Integer.TYPE, jsonData);
            this.borderColor = (Color)json.readValue("borderColor", Color.class, jsonData);
            this.borderStraight = (Boolean)json.readValue("borderStraight", Boolean.TYPE, jsonData);
            this.shadowOffsetX = (Integer)json.readValue("shadowOffsetX", Integer.TYPE, jsonData);
            this.shadowOffsetY = (Integer)json.readValue("shadowOffsetY", Integer.TYPE, jsonData);
            this.shadowColor = (Color)json.readValue("shadowColor", Color.class, jsonData);
            this.textAlign = (Integer)json.readValue("align", Integer.TYPE, (Object)8, jsonData);
            this.orgAlign = (Integer)json.readValue("orgAlign", Integer.TYPE, (Object)4, jsonData);
            this.maxWidth = (Integer)json.readValue("maxWidth", Integer.TYPE, (Object)0, jsonData);
        }
    }

    @Override
    public void setWorld(World world) {
        this.world = world;
    }
}

