/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.model;

import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.bladecoder.engine.actions.ActionCallback;
import com.bladecoder.engine.model.Verb;
import com.bladecoder.engine.model.World;
import com.bladecoder.engine.serialization.BladeJson;
import com.bladecoder.engine.util.EngineLogger;
import java.text.MessageFormat;
import java.util.HashMap;

public class VerbManager
implements Json.Serializable {
    protected HashMap<String, Verb> verbs = new HashMap();
    private World w;
    private StringBuilder tmpsb = new StringBuilder();

    public void addVerb(Verb v) {
        this.verbs.put(v.getHashKey(), v);
    }

    public Verb getVerb(String id, String state, String target) {
        Verb v = null;
        if (target != null) {
            this.tmpsb.setLength(0);
            if (state != null) {
                this.tmpsb.append(id).append(".").append(target).append(".").append(state);
                v = this.verbs.get(this.tmpsb.toString());
            }
            if (v == null) {
                this.tmpsb.setLength(0);
                this.tmpsb.append(id).append(".").append(target);
                v = this.verbs.get(this.tmpsb.toString());
            }
        }
        if (v == null && state != null) {
            this.tmpsb.setLength(0);
            this.tmpsb.append(id).append(".").append(state);
            v = this.verbs.get(this.tmpsb.toString());
        }
        if (v == null) {
            v = this.verbs.get(id);
        }
        return v;
    }

    public HashMap<String, Verb> getVerbs() {
        return this.verbs;
    }

    public void runVerb(String verb, String state, String target, ActionCallback cb) {
        Verb v = null;
        EngineLogger.debug(MessageFormat.format("Run Verb:{0} State: {1} Target: {2}", verb, state, target));
        v = this.getVerb(verb, state, target);
        if (v == null) {
            v = this.w.getVerbManager().getVerb(verb, null, null);
        }
        if (v != null) {
            v.run(target, cb);
        } else {
            EngineLogger.error(MessageFormat.format("Verb ''{0}'' not found for target ''{1}''", verb, target));
        }
    }

    public void cancelVerb(String verb, String state, String target) {
        Verb v = null;
        v = this.getVerb(verb, state, target);
        if (v == null) {
            v = this.w.getVerbManager().getVerb(verb, null, null);
        }
        if (v != null) {
            v.cancel();
        } else {
            EngineLogger.error(MessageFormat.format("Verb ''{0}'' not found for target ''{1}''", verb, target));
        }
    }

    public void write(Json json) {
        json.writeValue("verbs", this.verbs, this.verbs.getClass(), Verb.class);
    }

    public void read(Json json, JsonValue jsonData) {
        BladeJson bjson = (BladeJson)json;
        if (bjson.getMode() == BladeJson.Mode.MODEL) {
            this.w = bjson.getWorld();
            this.verbs = (HashMap)json.readValue("verbs", HashMap.class, Verb.class, jsonData);
        } else {
            for (String v : this.verbs.keySet()) {
                Verb verb = this.verbs.get(v);
                JsonValue jsonValue = jsonData.get("verbs").get(v);
                if (jsonValue != null) {
                    verb.read(json, jsonValue);
                    continue;
                }
                EngineLogger.debug("LOAD WARNING: Verb not found in saved game: " + jsonData.name + "." + v);
            }
        }
    }
}

