/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.model;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.PixmapIO;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.BufferUtils;
import com.badlogic.gdx.utils.ScreenUtils;
import com.badlogic.gdx.utils.viewport.Viewport;
import com.bladecoder.engine.assets.AssetConsumer;
import com.bladecoder.engine.assets.EngineAssetManager;
import com.bladecoder.engine.i18n.I18N;
import com.bladecoder.engine.ink.InkManager;
import com.bladecoder.engine.model.Dialog;
import com.bladecoder.engine.model.InteractiveActor;
import com.bladecoder.engine.model.Inventory;
import com.bladecoder.engine.model.MusicManager;
import com.bladecoder.engine.model.Scene;
import com.bladecoder.engine.model.SceneCamera;
import com.bladecoder.engine.model.SoundDesc;
import com.bladecoder.engine.model.Transition;
import com.bladecoder.engine.model.UIActors;
import com.bladecoder.engine.model.VerbManager;
import com.bladecoder.engine.model.WorldListener;
import com.bladecoder.engine.serialization.WorldSerialization;
import com.bladecoder.engine.util.EngineLogger;
import com.bladecoder.engine.util.FileUtils;
import java.io.IOException;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class World
implements AssetConsumer {
    private static final String GAMESTATE_FILENAME = "default.gamestate.v14";
    private static final String DEFAULT_INVENTORY = "DEFAULT";
    private static final boolean CACHE_ENABLED = true;
    private int width;
    private int height;
    private String initScene;
    private final HashMap<String, SoundDesc> sounds = new HashMap();
    private final HashMap<String, Scene> scenes = new HashMap();
    private final VerbManager verbs = new VerbManager();
    private final I18N i18n = new I18N();
    private Scene currentScene;
    private Dialog currentDialog;
    private final Map<String, Inventory> inventories = new HashMap<String, Inventory>();
    private String currentInventory;
    private UIActors uiActors;
    private boolean paused;
    private boolean cutMode;
    private long timeOfGame;
    private final HashMap<String, String> customProperties = new HashMap();
    private String initChapter;
    private String currentChapter;
    private Transition transition;
    private MusicManager musicManager;
    private WorldListener listener;
    private InkManager inkManager;
    private AssetState assetState;
    private transient SpriteBatch spriteBatch;
    private long initLoadingTime;
    private transient Scene cachedScene;
    private String testScene;
    private boolean initGame;
    private String initVerb;
    private final WorldSerialization serialization = new WorldSerialization(this);
    private final Vector3 unprojectTmp = new Vector3();

    public World() {
        this.init();
    }

    private void init() {
        this.inventories.clear();
        this.inventories.put(DEFAULT_INVENTORY, new Inventory());
        this.setCurrentInventory(DEFAULT_INVENTORY);
        this.scenes.clear();
        this.sounds.clear();
        this.uiActors = new UIActors(this);
        this.cutMode = false;
        this.currentChapter = null;
        this.cachedScene = null;
        this.customProperties.clear();
        this.spriteBatch = new SpriteBatch();
        this.transition = new Transition();
        this.musicManager = new MusicManager();
        this.paused = false;
        this.initGame = true;
    }

    public void setListener(WorldListener l) {
        this.listener = l;
    }

    public WorldListener getListener() {
        return this.listener;
    }

    public WorldSerialization getSerializer() {
        return this.serialization;
    }

    public InkManager getInkManager() {
        if (this.inkManager == null) {
            try {
                Class.forName("com.bladecoder.ink.runtime.Story");
                this.inkManager = new InkManager(this);
            }
            catch (ClassNotFoundException e) {
                EngineLogger.debug("WARNING: Blade Ink Library not found.");
            }
        }
        return this.inkManager;
    }

    public Scene getCachedScene(String id) {
        if (this.cachedScene != null && this.cachedScene.getId().equals(id)) {
            return this.cachedScene;
        }
        return null;
    }

    public String getCustomProperty(String name) {
        return this.customProperties.get(name);
    }

    public void setCustomProperty(String name, String value) {
        if (value == null) {
            this.customProperties.remove(name);
        } else {
            this.customProperties.put(name, value);
        }
    }

    public VerbManager getVerbManager() {
        return this.verbs;
    }

    public MusicManager getMusicManager() {
        return this.musicManager;
    }

    public HashMap<String, SoundDesc> getSounds() {
        return this.sounds;
    }

    public void draw() {
        if (this.assetState == AssetState.LOADED) {
            this.getCurrentScene().draw(this.spriteBatch);
            this.uiActors.draw(this.spriteBatch);
        }
    }

    public void update(float delta) {
        if (this.assetState == AssetState.LOAD_ASSETS || this.assetState == AssetState.LOAD_ASSETS_AND_INIT_SCENE) {
            this.loadAssets();
            this.assetState = this.assetState == AssetState.LOAD_ASSETS ? AssetState.LOADING : AssetState.LOADING_AND_INIT_SCENE;
        }
        if (!(this.assetState != AssetState.LOADING && this.assetState != AssetState.LOADING_AND_INIT_SCENE || EngineAssetManager.getInstance().isLoading())) {
            this.retrieveAssets();
            this.paused = false;
            boolean init = this.assetState == AssetState.LOADING_AND_INIT_SCENE;
            this.assetState = AssetState.LOADED;
            EngineLogger.debug("ASSETS LOADING TIME (ms): " + (System.currentTimeMillis() - this.initLoadingTime));
            if (this.initGame) {
                this.initGame = false;
                if (this.customProperties.get(WorldProperties.SAVED_GAME_VERSION.toString()) == null && this.verbs.getVerb("initNewGame", null, null) != null) {
                    this.verbs.runVerb("initNewGame", null, null, null);
                } else if (this.customProperties.get(WorldProperties.SAVED_GAME_VERSION.toString()) != null && this.verbs.getVerb("initSavedGame", null, null) != null) {
                    this.verbs.runVerb("initSavedGame", null, null, null);
                }
            }
            this.startScene(init);
        }
        if (this.paused || this.assetState != AssetState.LOADED) {
            return;
        }
        this.timeOfGame = (long)((float)this.timeOfGame + delta * 1000.0f);
        this.getCurrentScene().update(delta);
        this.uiActors.update(delta);
        this.getInventory().update(delta);
        this.transition.update(delta);
        this.musicManager.update(delta);
    }

    private void startScene(boolean initScene) {
        if (initScene) {
            this.currentScene.init();
            if (this.inkManager != null) {
                this.inkManager.init();
            }
            this.setCutMode(false);
            if (this.testScene != null && this.testScene.equals(this.currentScene.getId()) && this.currentScene.getVerb("test") != null) {
                this.initVerb = "test";
                this.testScene = null;
            }
            if (this.initVerb == null) {
                this.initVerb = "init";
            }
        }
        if (this.initVerb != null && (this.currentScene.getVerb(this.initVerb) != null || this.getVerbManager().getVerb(this.initVerb, null, null) != null)) {
            this.currentScene.runVerb(this.initVerb);
        }
        this.initVerb = null;
    }

    @Override
    public void loadAssets() {
        this.currentScene.loadAssets();
        if (this.getInventory().isDisposed()) {
            this.getInventory().loadAssets();
        }
        if (this.uiActors.isDisposed()) {
            this.uiActors.loadAssets();
        }
        this.musicManager.loadAssets();
    }

    @Override
    public void retrieveAssets() {
        if (this.getInventory().isDisposed()) {
            this.getInventory().retrieveAssets();
        }
        if (this.uiActors.isDisposed()) {
            this.uiActors.retrieveAssets();
        }
        this.getCurrentScene().retrieveAssets();
        if (EngineLogger.debugMode()) {
            Array assetNames = EngineAssetManager.getInstance().getAssetNames();
            assetNames.sort();
            EngineLogger.debug("Assets loaded for SCENE: " + this.currentScene.getId());
            for (String n : assetNames) {
                EngineLogger.debug("\t" + n);
            }
        }
        this.musicManager.retrieveAssets();
    }

    public Transition getTransition() {
        return this.transition;
    }

    public long getTimeOfGame() {
        return this.timeOfGame;
    }

    public void setTimeOfGame(long t) {
        this.timeOfGame = t;
    }

    public AssetState getAssetState() {
        return this.assetState;
    }

    public I18N getI18N() {
        return this.i18n;
    }

    public Dialog getCurrentDialog() {
        return this.currentDialog;
    }

    public Scene getCurrentScene() {
        return this.currentScene;
    }

    public String getInitScene() {
        return this.initScene;
    }

    public String getCurrentChapter() {
        return this.currentChapter;
    }

    public void setInitScene(String initScene) {
        this.initScene = initScene;
    }

    public void setCurrentScene(Scene scene, boolean init, String initVerb) {
        this.initLoadingTime = System.currentTimeMillis();
        if (this.cachedScene == scene || this.currentScene == scene) {
            this.assetState = init ? AssetState.LOADING_AND_INIT_SCENE : AssetState.LOADING;
        } else {
            if (this.cachedScene != null) {
                this.cachedScene.dispose();
                this.cachedScene = null;
            }
            this.assetState = init ? AssetState.LOAD_ASSETS_AND_INIT_SCENE : AssetState.LOAD_ASSETS;
        }
        if (this.currentScene != null) {
            this.currentDialog = null;
            this.currentScene.getSoundManager().stop();
            this.customProperties.put(WorldProperties.PREVIOUS_SCENE.toString(), this.currentScene.getId());
            if (this.currentScene != scene) {
                this.cachedScene = this.currentScene;
            }
            this.transition.reset();
        }
        this.currentScene = scene;
        this.initVerb = initVerb;
        this.musicManager.leaveScene(this.currentScene.getMusicDesc());
    }

    public Inventory getInventory() {
        return this.inventories.get(this.currentInventory);
    }

    public HashMap<String, String> getCustomProperties() {
        return this.customProperties;
    }

    public Map<String, Inventory> getInventories() {
        return this.inventories;
    }

    public UIActors getUIActors() {
        return this.uiActors;
    }

    public void addScene(Scene scene) {
        this.scenes.put(scene.getId(), scene);
    }

    public Scene getScene(String id) {
        return this.scenes.get(id);
    }

    public Map<String, Scene> getScenes() {
        return this.scenes;
    }

    public void setCutMode(boolean v) {
        this.cutMode = v;
        if (this.listener != null) {
            this.listener.cutMode(this.cutMode);
        }
    }

    public void setCurrentScene(String id, boolean init, String initVerb) {
        Scene s;
        if (id.equals("$" + (Object)((Object)WorldProperties.PREVIOUS_SCENE))) {
            id = this.getCustomProperty(WorldProperties.PREVIOUS_SCENE.toString());
        }
        if ((s = this.scenes.get(id)) != null) {
            this.setCurrentScene(s, init, initVerb);
        } else {
            EngineLogger.error("SetCurrentScene - COULD NOT FIND SCENE: " + id);
        }
    }

    public void setCurrentDialog(Dialog dialog) {
        this.currentDialog = dialog;
        if (dialog != null) {
            dialog.reset();
            int visibleOptions = dialog.getNumVisibleOptions();
            if (visibleOptions == 0) {
                this.currentDialog = null;
            }
        }
        if (this.listener != null) {
            this.listener.dialogOptions();
        }
    }

    public void setInventory(String inventory) {
        Inventory i = this.inventories.get(inventory);
        if (i == null) {
            i = new Inventory();
            this.inventories.put(inventory, i);
        }
        this.setCurrentInventory(inventory);
    }

    public boolean hasDialogOptions() {
        return this.currentDialog != null || this.inkManager != null && this.inkManager.hasChoices();
    }

    public void selectDialogOption(int i) {
        if (this.currentDialog != null) {
            this.setCurrentDialog(this.currentDialog.selectOption(i));
        } else if (this.inkManager != null) {
            this.getInkManager().selectChoice(i);
        }
    }

    public List<String> getDialogOptions() {
        List<String> choices = this.getCurrentDialog() != null ? this.getCurrentDialog().getChoices() : this.getInkManager().getChoices();
        return choices;
    }

    public InteractiveActor getInteractiveActorAtInput(Viewport v, float tolerance) {
        this.getSceneCamera().getInputUnProject(v, this.unprojectTmp);
        InteractiveActor a = this.uiActors.getActorAtInput(v);
        if (a != null) {
            return a;
        }
        return this.currentScene.getInteractiveActorAt(this.unprojectTmp.x, this.unprojectTmp.y, tolerance);
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void showInventory(boolean b) {
        this.getInventory().setVisible(b);
        if (this.listener != null) {
            this.listener.inventoryEnabled(b);
        }
    }

    public String getCurrentInventory() {
        return this.currentInventory;
    }

    public void setCurrentInventory(String currentInventory) {
        this.currentInventory = currentInventory;
    }

    public boolean isDisposed() {
        return this.currentScene == null;
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        try {
            this.currentDialog = null;
            this.transition.reset();
            if (this.currentScene != null) {
                this.musicManager.stopMusic();
                this.currentScene.getTextManager().reset();
                this.currentScene.dispose();
                this.currentScene = null;
            }
            if (this.cachedScene != null) {
                this.cachedScene.dispose();
                this.cachedScene = null;
            }
            this.getInventory().dispose();
            this.uiActors.dispose();
            this.spriteBatch.dispose();
            this.assetState = null;
            this.musicManager.dispose();
            this.inkManager = null;
        }
        catch (Exception e) {
            EngineLogger.error(e.getMessage());
        }
        this.init();
    }

    public SceneCamera getSceneCamera() {
        return this.currentScene.getCamera();
    }

    public void resize(float viewportWidth, float viewportHeight) {
        if (this.currentScene != null) {
            this.currentScene.getCamera().viewportWidth = viewportWidth;
            this.currentScene.getCamera().viewportHeight = viewportHeight;
            if (this.currentScene.getCameraFollowActor() != null) {
                this.currentScene.getCamera().updatePos(this.currentScene.getCameraFollowActor());
            }
            this.currentScene.getCamera().update();
            this.uiActors.resize(viewportWidth, viewportHeight);
        }
    }

    public void setChapter(String chapter) {
        this.currentChapter = chapter;
    }

    public String getInitChapter() {
        return this.initChapter;
    }

    public void setInitChapter(String initChapter) {
        this.initChapter = initChapter;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public boolean inCutMode() {
        return this.cutMode;
    }

    public void pause() {
        this.paused = true;
        if (this.currentScene != null) {
            if (this.assetState == AssetState.LOADED) {
                this.musicManager.pauseMusic();
                this.currentScene.getTextManager().getVoiceManager().pause();
            }
            this.currentScene.getSoundManager().pause();
        }
        if (this.listener != null) {
            this.listener.pause(true);
        }
    }

    public void resume() {
        this.paused = false;
        if (this.assetState == AssetState.LOADED && this.currentScene != null) {
            this.musicManager.resumeMusic();
            this.currentScene.getTextManager().getVoiceManager().resume();
            this.currentScene.getSoundManager().resume();
        }
        if (this.listener != null) {
            this.listener.pause(false);
        }
    }

    public void newGame() throws Exception {
        this.timeOfGame = 0L;
        this.serialization.loadChapter();
    }

    public void endGame() {
        this.dispose();
        if (EngineAssetManager.getInstance().getUserFile(GAMESTATE_FILENAME).exists()) {
            EngineAssetManager.getInstance().getUserFile(GAMESTATE_FILENAME).delete();
        }
    }

    public void saveGameState() throws IOException {
        boolean takeScreenshot = Gdx.app.getType() == Application.ApplicationType.Desktop;
        this.serialization.saveGameState(GAMESTATE_FILENAME, takeScreenshot);
    }

    public void removeGameState(String filename) throws IOException {
        EngineAssetManager.getInstance().getUserFile(filename).delete();
        EngineAssetManager.getInstance().getUserFile(filename + ".png").delete();
    }

    public void load() throws Exception {
        if (EngineAssetManager.getInstance().getUserFile(GAMESTATE_FILENAME).exists()) {
            try {
                this.loadGameState();
            }
            catch (Exception e) {
                EngineLogger.error("ERROR LOADING SAVED GAME", e);
                this.serialization.loadChapter();
            }
        } else {
            this.serialization.loadChapter();
        }
    }

    public void loadChapter(String chapter, String scene, boolean test) throws Exception {
        if (test) {
            this.testScene = scene;
        }
        this.serialization.loadChapter(chapter, scene, true);
    }

    public void setTestScene(String s) {
        this.testScene = s;
    }

    public void loadWorldDesc() throws IOException {
        this.serialization.loadWorldDesc();
    }

    public void saveWorldDesc(FileHandle file) throws IOException {
        this.serialization.saveWorldDesc(file);
    }

    public boolean savedGameExists() {
        return this.savedGameExists(GAMESTATE_FILENAME);
    }

    public boolean savedGameExists(String filename) {
        return EngineAssetManager.getInstance().getUserFile(filename).exists() || FileUtils.exists(EngineAssetManager.getInstance().getAsset("tests/" + filename));
    }

    public void loadGameState() throws IOException {
        long initTime = System.currentTimeMillis();
        this.loadGameState(GAMESTATE_FILENAME);
        EngineLogger.debug("GAME STATE LOADING TIME (ms): " + (System.currentTimeMillis() - initTime));
    }

    public void loadGameState(String filename) throws IOException {
        FileHandle savedFile = EngineAssetManager.getInstance().getUserFile(filename).exists() ? EngineAssetManager.getInstance().getUserFile(filename) : EngineAssetManager.getInstance().getAsset("tests/" + filename);
        this.serialization.loadGameState(savedFile);
        this.assetState = AssetState.LOAD_ASSETS;
    }

    public void takeScreenshot(String filename, int w) {
        IntBuffer results = BufferUtils.newIntBuffer((int)16);
        Gdx.gl20.glGetIntegerv(2978, results);
        int h = (int)((float)w * this.getSceneCamera().viewportHeight / this.getSceneCamera().viewportWidth);
        FrameBuffer fbo = new FrameBuffer(Pixmap.Format.RGB565, w, h, false);
        fbo.begin();
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.draw();
        Pixmap pixmap = ScreenUtils.getFrameBufferPixmap((int)0, (int)0, (int)w, (int)h);
        fbo.end(results.get(0), results.get(1), results.get(2), results.get(3));
        PixmapIO.writePNG((FileHandle)EngineAssetManager.getInstance().getUserFile(filename), (Pixmap)pixmap, (int)-1, (boolean)true);
        fbo.dispose();
    }

    public static enum AssetState {
        LOADED,
        LOADING,
        LOADING_AND_INIT_SCENE,
        LOAD_ASSETS,
        LOAD_ASSETS_AND_INIT_SCENE;

    }

    public static enum WorldProperties {
        SAVED_GAME_VERSION,
        PREVIOUS_SCENE,
        CURRENT_CHAPTER,
        PLATFORM;

    }
}

