/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.pathfinder;

import com.badlogic.gdx.utils.BinaryHeap;
import com.bladecoder.engine.pathfinder.NavContext;
import com.bladecoder.engine.pathfinder.NavGraph;
import com.bladecoder.engine.pathfinder.NavNode;
import com.bladecoder.engine.pathfinder.NavPath;
import com.bladecoder.engine.pathfinder.PathFinder;

public class AStarPathFinder<N extends NavNode<N>>
implements NavContext<N>,
PathFinder<N> {
    private final BinaryHeap<AStarAlgoData> openList = new BinaryHeap();
    private final NavGraph<N> graph;
    private final int maxSearchDistance;
    private final AStarHeuristicCalculator<N> heuristicCalculator;
    private Object mover;
    private int distance;
    private int checkedID;
    private N sourceNodeInContext;

    public AStarPathFinder(NavGraph<N> graph, int maxSearchDistance, AStarHeuristicCalculator<N> heuristic) {
        this.heuristicCalculator = heuristic;
        this.graph = graph;
        this.maxSearchDistance = maxSearchDistance;
    }

    @Override
    public boolean findPath(Object mover, N startNode, N targetNode, NavPath<N> out) {
        boolean pathFound;
        this.mover = mover;
        this.distance = 0;
        if (this.isBlocked(targetNode, targetNode)) {
            return false;
        }
        ++this.checkedID;
        if (this.checkedID < 0) {
            this.checkedID = 1;
        }
        BinaryHeap<AStarAlgoData> openList = this.openList;
        AStarHeuristicCalculator<NavNode> heuristicCalculator = this.heuristicCalculator;
        int maxSearchDistance = this.maxSearchDistance;
        openList.clear();
        this.addToOpenList(this.getAlgoData(startNode));
        this.getAlgoData(targetNode);
        AStarAlgoData currentData = null;
        int maxDepth = 0;
        while (maxDepth < maxSearchDistance && openList.size != 0) {
            AStarAlgoData lastData = currentData;
            currentData = (AStarAlgoData)openList.pop();
            currentData.open = false;
            this.distance = currentData.depth;
            currentData.closed = true;
            if (currentData.node == targetNode && lastData != null && !this.isBlocked(lastData.node, targetNode)) break;
            float currentCost = currentData.cost;
            for (NavNode neighborNode : ((NavNode)currentData.node).neighbors) {
                AStarAlgoData neighborData = this.getAlgoData(neighborNode);
                if (this.isBlocked(currentData.node, neighborNode)) continue;
                this.sourceNodeInContext = startNode;
                float nextStepCost = currentCost + this.graph.getCost(this, neighborNode);
                if (nextStepCost < neighborData.cost) {
                    if (neighborData.open) {
                        openList.remove((BinaryHeap.Node)neighborData);
                        neighborData.open = false;
                    }
                    neighborData.closed = false;
                }
                if (neighborData.open || neighborData.closed) continue;
                neighborData.cost = nextStepCost;
                neighborData.heuristic = heuristicCalculator.getCost(this, mover, neighborNode, (NavNode)targetNode);
                neighborData.depth = currentData.depth + 1;
                neighborNode.parent = currentData.node;
                maxDepth = Math.max(maxDepth, neighborData.depth);
                this.addToOpenList(neighborData);
            }
        }
        boolean bl = pathFound = ((NavNode)targetNode).parent != null;
        if (pathFound) {
            out.fill(startNode, targetNode);
        }
        return pathFound;
    }

    private AStarAlgoData getAlgoData(N node) {
        AStarAlgoData ad = (AStarAlgoData)((Object)((NavNode)node).algoData);
        if (((NavNode)node).algoData == null) {
            ad = new AStarAlgoData(this, node);
            ((NavNode)node).algoData = ad;
        }
        if (ad.checkedID != this.checkedID) {
            ad.reset();
            ad.checkedID = this.checkedID;
        }
        return ad;
    }

    private boolean isBlocked(N startNode, N targetNode) {
        this.sourceNodeInContext = startNode;
        return this.graph.blocked(this, targetNode);
    }

    private void addToOpenList(AStarAlgoData node) {
        this.openList.add((BinaryHeap.Node)node, node.cost + node.heuristic);
        node.open = true;
    }

    @Override
    public Object getMover() {
        return this.mover;
    }

    @Override
    public float getSearchDistance() {
        return this.distance;
    }

    @Override
    public N getSourceNode() {
        return this.sourceNodeInContext;
    }

    public static interface AStarHeuristicCalculator<N extends NavNode<N>> {
        public float getCost(NavContext<N> var1, Object var2, N var3, N var4);
    }

    static class AStarAlgoData
    extends BinaryHeap.Node {
        final N node;
        float heuristic;
        int depth;
        int checkedID;
        float cost;
        boolean open;
        boolean closed;
        final /* synthetic */ AStarPathFinder this$0;

        public AStarAlgoData(N node) {
            this.this$0 = this$0;
            super(0.0f);
            this.node = node;
        }

        void reset() {
            this.closed = false;
            this.open = false;
            this.cost = 0.0f;
            this.depth = 0;
            ((NavNode)this.node).parent = null;
        }
    }
}

