/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.polygonalpathfinder;

import com.badlogic.gdx.math.Polygon;
import com.badlogic.gdx.math.Vector2;
import com.bladecoder.engine.model.BaseActor;
import com.bladecoder.engine.model.ObstacleActor;
import com.bladecoder.engine.pathfinder.AStarPathFinder;
import com.bladecoder.engine.pathfinder.NavContext;
import com.bladecoder.engine.pathfinder.NavGraph;
import com.bladecoder.engine.pathfinder.PathFinder;
import com.bladecoder.engine.polygonalpathfinder.ManhattanDistance;
import com.bladecoder.engine.polygonalpathfinder.NavNodePolygonal;
import com.bladecoder.engine.polygonalpathfinder.NavPathPolygonal;
import com.bladecoder.engine.util.EngineLogger;
import com.bladecoder.engine.util.PolygonUtils;
import java.util.ArrayList;
import java.util.Collection;

public class PolygonalNavGraph
implements NavGraph<NavNodePolygonal> {
    private static final int MAX_PATHFINDER_SEARCH_DISTANCE = 50;
    private static final Vector2 tmp = new Vector2();
    private static final Vector2 tmp2 = new Vector2();
    private Polygon walkZone;
    private final ArrayList<Polygon> obstacles = new ArrayList();
    private final PathFinder<NavNodePolygonal> pathfinder = new AStarPathFinder<NavNodePolygonal>(this, 50, new ManhattanDistance());
    private final NavNodePolygonal startNode = new NavNodePolygonal();
    private final NavNodePolygonal targetNode = new NavNodePolygonal();
    private final ArrayList<NavNodePolygonal> graphNodes = new ArrayList();

    public ArrayList<Vector2> findPath(float sx, float sy, float tx, float ty) {
        NavPathPolygonal resultPath = new NavPathPolygonal();
        Vector2 source = new Vector2(sx, sy);
        Vector2 target = new Vector2(tx, ty);
        if (!PolygonUtils.isPointInside(this.walkZone, sx, sy, true)) {
            EngineLogger.debug("PolygonalPathFinder: Source not in polygon!");
            PolygonUtils.getClampedPoint(this.walkZone, sx, sy, source);
            if (!PolygonUtils.isPointInside(this.walkZone, source.x, source.y, true)) {
                EngineLogger.debug("PolygonalPathFinder: CLAMPED FAILED!!");
                return resultPath.getPath();
            }
        }
        if (!PolygonUtils.isPointInside(this.walkZone, tx, ty, true)) {
            PolygonUtils.getClampedPoint(this.walkZone, tx, ty, target);
            if (!PolygonUtils.isPointInside(this.walkZone, target.x, target.y, true)) {
                EngineLogger.debug("PolygonalPathFinder: CLAMPED FAILED!!");
                return resultPath.getPath();
            }
        }
        for (Polygon o : this.obstacles) {
            if (!PolygonUtils.isPointInside(o, target.x, target.y, false)) continue;
            PolygonUtils.getClampedPoint(o, target.x, target.y, target);
            if (PolygonUtils.isPointInside(this.walkZone, target.x, target.y, true)) continue;
            this.getFirstVertexInsideWalkzone(o, target);
            break;
        }
        if (this.inLineOfSight(source.x, source.y, target.x, target.y)) {
            EngineLogger.debug("PolygonalPathFinder: Direct path found");
            resultPath.getPath().add(source);
            resultPath.getPath().add(target);
            return resultPath.getPath();
        }
        this.addStartEndNodes(source.x, source.y, target.x, target.y);
        this.pathfinder.findPath(null, this.startNode, this.targetNode, resultPath);
        return resultPath.getPath();
    }

    private void getFirstVertexInsideWalkzone(Polygon p, Vector2 target) {
        float[] verts = p.getTransformedVertices();
        for (int i = 0; i < verts.length; i += 2) {
            if (!PolygonUtils.isPointInside(this.walkZone, verts[i], verts[i + 1], true)) continue;
            target.x = verts[i];
            target.y = verts[i + 1];
            return;
        }
    }

    public void createInitialGraph(BaseActor wz, Collection<BaseActor> actors) {
        this.graphNodes.clear();
        if (wz == null) {
            this.walkZone = null;
            return;
        }
        this.walkZone = wz.getBBox();
        float[] verts = this.walkZone.getTransformedVertices();
        for (int i = 0; i < verts.length; i += 2) {
            if (PolygonUtils.isVertexConcave(this.walkZone, i)) continue;
            this.graphNodes.add(new NavNodePolygonal(verts[i], verts[i + 1]));
        }
        this.obstacles.clear();
        for (BaseActor a : actors) {
            if (!(a instanceof ObstacleActor) || !a.isVisible()) continue;
            this.obstacles.add(a.getBBox());
        }
        for (Polygon o : this.obstacles) {
            verts = o.getTransformedVertices();
            for (int i = 0; i < verts.length; i += 2) {
                if (!PolygonUtils.isVertexConcave(o, i) || !PolygonUtils.isPointInside(this.walkZone, verts[i], verts[i + 1], false)) continue;
                this.graphNodes.add(new NavNodePolygonal(verts[i], verts[i + 1]));
            }
        }
        for (int i = 0; i < this.graphNodes.size() - 1; ++i) {
            NavNodePolygonal n1 = this.graphNodes.get(i);
            for (int j = i + 1; j < this.graphNodes.size(); ++j) {
                NavNodePolygonal n2 = this.graphNodes.get(j);
                if (!this.inLineOfSight(n1.x, n1.y, n2.x, n2.y)) continue;
                n1.neighbors.add((Object)n2);
                n2.neighbors.add((Object)n1);
            }
        }
    }

    private boolean inLineOfSight(float p1X, float p1Y, float p2X, float p2Y) {
        tmp.set(p1X, p1Y);
        tmp2.set(p2X, p2Y);
        if (!PolygonUtils.inLineOfSight(tmp, tmp2, this.walkZone, false)) {
            return false;
        }
        for (Polygon o : this.obstacles) {
            if (PolygonUtils.inLineOfSight(tmp, tmp2, o, true)) continue;
            return false;
        }
        return true;
    }

    private void addStartEndNodes(float sx, float sy, float tx, float ty) {
        this.startNode.x = sx;
        this.startNode.y = sy;
        this.targetNode.x = tx;
        this.targetNode.y = ty;
        this.startNode.neighbors.clear();
        for (NavNodePolygonal n : this.graphNodes) {
            n.neighbors.removeValue((Object)this.targetNode, true);
            if (this.inLineOfSight(this.startNode.x, this.startNode.y, n.x, n.y)) {
                this.startNode.neighbors.add((Object)n);
            }
            if (!this.inLineOfSight(this.targetNode.x, this.targetNode.y, n.x, n.y)) continue;
            n.neighbors.add((Object)this.targetNode);
        }
    }

    public Polygon getWalkZone() {
        return this.walkZone;
    }

    public void setWalkZone(Polygon walkZone) {
        this.walkZone = walkZone;
    }

    public ArrayList<NavNodePolygonal> getGraphNodes() {
        return this.graphNodes;
    }

    @Override
    public boolean blocked(NavContext<NavNodePolygonal> context, NavNodePolygonal targetNode) {
        return false;
    }

    @Override
    public float getCost(NavContext<NavNodePolygonal> context, NavNodePolygonal targetNode) {
        return 1.0f;
    }

    private void addObstacleToGrapth(Polygon poly) {
        float[] verts = poly.getTransformedVertices();
        for (int i = 0; i < verts.length; i += 2) {
            if (!PolygonUtils.isVertexConcave(poly, i) || !PolygonUtils.isPointInside(this.walkZone, verts[i], verts[i + 1], false)) continue;
            NavNodePolygonal n1 = new NavNodePolygonal(verts[i], verts[i + 1]);
            for (int j = 0; j < this.graphNodes.size(); ++j) {
                NavNodePolygonal n2 = this.graphNodes.get(j);
                if (!this.inLineOfSight(n1.x, n1.y, n2.x, n2.y)) continue;
                n1.neighbors.add((Object)n2);
                n2.neighbors.add((Object)n1);
            }
            this.graphNodes.add(n1);
        }
    }

    public void addDinamicObstacle(Polygon poly) {
        int idx = this.obstacles.indexOf(poly);
        if (idx == -1 && this.walkZone != null) {
            this.obstacles.add(poly);
            this.addObstacleToGrapth(poly);
        }
    }

    public boolean removeDinamicObstacle(Polygon poly) {
        boolean exists = this.obstacles.remove(poly);
        if (!exists) {
            return false;
        }
        float[] verts = poly.getTransformedVertices();
        for (int i = 0; i < verts.length; i += 2) {
            if (!PolygonUtils.isVertexConcave(poly, i) || !PolygonUtils.isPointInside(this.walkZone, verts[i], verts[i + 1], false)) continue;
            for (int j = 0; j < this.graphNodes.size(); ++j) {
                NavNodePolygonal n = this.graphNodes.get(j);
                if (n.x != verts[i] || n.y != verts[i + 1]) continue;
                this.graphNodes.remove(n);
                --j;
                for (NavNodePolygonal n2 : this.graphNodes) {
                    n2.neighbors.removeValue((Object)n, true);
                }
            }
        }
        return true;
    }
}

