/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.serialization;

import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.ObjectMap;
import com.bladecoder.engine.actions.Action;
import com.bladecoder.engine.actions.ActionFactory;
import com.bladecoder.engine.anim.AtlasAnimationDesc;
import com.bladecoder.engine.anim.SpineAnimationDesc;
import com.bladecoder.engine.model.AnchorActor;
import com.bladecoder.engine.model.AtlasRenderer;
import com.bladecoder.engine.model.CharacterActor;
import com.bladecoder.engine.model.ImageRenderer;
import com.bladecoder.engine.model.InteractiveActor;
import com.bladecoder.engine.model.ObstacleActor;
import com.bladecoder.engine.model.ParticleRenderer;
import com.bladecoder.engine.model.Scene;
import com.bladecoder.engine.model.SpriteActor;
import com.bladecoder.engine.model.TextRenderer;
import com.bladecoder.engine.model.WalkZoneActor;
import com.bladecoder.engine.model.World;

public class BladeJson
extends Json {
    private final World w;
    private final Mode mode;
    private boolean init;
    private Scene scene;

    public BladeJson(World w, Mode mode, boolean init) {
        this.w = w;
        this.mode = mode;
        this.init = init;
        this.addClassTag(SpineAnimationDesc.class);
        this.addClassTag(AtlasAnimationDesc.class);
        this.addClassTag(CharacterActor.class);
        this.addClassTag(AnchorActor.class);
        this.addClassTag(ObstacleActor.class);
        this.addClassTag(InteractiveActor.class);
        this.addClassTag(SpriteActor.class);
        this.addClassTag(WalkZoneActor.class);
        this.addClassTag(AtlasRenderer.class);
        this.addClassTag(ImageRenderer.class);
        this.addClassTag(ParticleRenderer.class);
        this.addClassTag(TextRenderer.class);
        ObjectMap<String, Class<? extends Action>> classTags = ActionFactory.getClassTags();
        for (ObjectMap.Entry e : classTags.entries()) {
            this.addClassTag((String)e.key, (Class)e.value);
        }
    }

    public BladeJson(World w, Mode mode) {
        this(w, mode, true);
    }

    public World getWorld() {
        return this.w;
    }

    public Mode getMode() {
        return this.mode;
    }

    public boolean getInit() {
        return this.init;
    }

    public void setInit(boolean init) {
        this.init = init;
    }

    public Scene getScene() {
        return this.scene == null ? this.w.getCurrentScene() : this.scene;
    }

    public void setScene(Scene scene) {
        this.scene = scene;
    }

    public void addClassTag(Class<?> tag) {
        this.addClassTag(tag.getSimpleName(), tag);
    }

    public static enum Mode {
        MODEL,
        STATE;

    }
}

