/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.serialization;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonReader;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.JsonWriter;
import com.badlogic.gdx.utils.reflect.ReflectionException;
import com.bladecoder.engine.actions.Action;
import com.bladecoder.engine.actions.ActionFactory;
import com.bladecoder.engine.actions.PlaySoundAction;
import com.bladecoder.engine.actions.SoundAction;
import com.bladecoder.engine.anim.AnimationDesc;
import com.bladecoder.engine.assets.EngineAssetManager;
import com.bladecoder.engine.model.AnimationRenderer;
import com.bladecoder.engine.model.BaseActor;
import com.bladecoder.engine.model.CharacterActor;
import com.bladecoder.engine.model.InteractiveActor;
import com.bladecoder.engine.model.Inventory;
import com.bladecoder.engine.model.Scene;
import com.bladecoder.engine.model.SoundDesc;
import com.bladecoder.engine.model.SpriteActor;
import com.bladecoder.engine.model.Verb;
import com.bladecoder.engine.model.World;
import com.bladecoder.engine.serialization.BladeJson;
import com.bladecoder.engine.util.ActionUtils;
import com.bladecoder.engine.util.Config;
import com.bladecoder.engine.util.EngineLogger;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class WorldSerialization
implements Json.Serializable {
    public static final String GAMESTATE_EXT = ".gamestate.v14";
    private static final int SCREENSHOT_DEFAULT_WIDTH = 300;
    private final World w;

    public WorldSerialization(World w) {
        this.w = w;
    }

    public void loadWorldDesc() throws IOException {
        String worldFilename = "world";
        if (!EngineAssetManager.getInstance().getModelFile(worldFilename).exists()) {
            worldFilename = "world.json";
            if (!EngineAssetManager.getInstance().getModelFile(worldFilename).exists()) {
                EngineLogger.error("ERROR LOADING WORLD: world file not found.");
                this.w.dispose();
                throw new IOException("ERROR LOADING WORLD: world file not found.");
            }
        }
        JsonValue root = new JsonReader().parse(EngineAssetManager.getInstance().getModelFile(worldFilename).reader("UTF-8"));
        BladeJson json = new BladeJson(this.w, BladeJson.Mode.MODEL);
        json.setIgnoreUnknownFields(true);
        int width = (Integer)json.readValue("width", Integer.class, root);
        int height = (Integer)json.readValue("height", Integer.class, root);
        EngineAssetManager.getInstance().setScale(width, height);
        float scale = EngineAssetManager.getInstance().getScale();
        this.w.setWidth((int)((float)width * scale));
        this.w.setHeight((int)((float)height * scale));
        this.w.setInitChapter((String)json.readValue("initChapter", String.class, root));
        this.w.getVerbManager().read(json, root);
        this.w.getI18N().loadWorld("model/world");
    }

    public void saveWorldDesc(FileHandle file) throws IOException {
        float scale = EngineAssetManager.getInstance().getScale();
        BladeJson json = new BladeJson(this.w, BladeJson.Mode.MODEL);
        json.setOutputType(JsonWriter.OutputType.javascript);
        json.setWriter(new StringWriter());
        json.writeObjectStart();
        json.writeValue("width", Float.valueOf((float)this.w.getWidth() / scale));
        json.writeValue("height", Float.valueOf((float)this.w.getHeight() / scale));
        json.writeValue("initChapter", this.w.getInitChapter());
        this.w.getVerbManager().write(json);
        json.writeObjectEnd();
        String s = null;
        s = EngineLogger.debugMode() ? json.prettyPrint(json.getWriter().getWriter().toString()) : json.getWriter().getWriter().toString();
        Writer w = file.writer(false, "UTF-8");
        w.write(s);
        w.close();
    }

    public void loadChapter() throws IOException {
        this.loadChapter(null, null, true);
    }

    public void loadChapter(String chapterName, String scene, boolean initScene) throws IOException {
        if (!this.w.isDisposed()) {
            this.w.dispose();
        }
        long initTime = System.currentTimeMillis();
        if (chapterName == null) {
            chapterName = this.w.getInitChapter();
        }
        this.w.setChapter(chapterName);
        if (EngineAssetManager.getInstance().getModelFile(chapterName + ".chapter.json").exists()) {
            JsonValue root = new JsonReader().parse(EngineAssetManager.getInstance().getModelFile(chapterName + ".chapter.json").reader("UTF-8"));
            BladeJson json = new BladeJson(this.w, BladeJson.Mode.MODEL, initScene);
            json.setIgnoreUnknownFields(true);
            this.read(json, root);
            if (scene == null) {
                this.w.setCurrentScene(this.w.getScenes().get(this.w.getInitScene()), initScene, null);
            } else {
                this.w.setCurrentScene(this.w.getScenes().get(scene), initScene, null);
            }
        } else {
            EngineLogger.error("ERROR LOADING CHAPTER: " + chapterName + ".chapter.json" + " doesn't exists.");
            this.w.dispose();
            throw new IOException("ERROR LOADING CHAPTER: " + chapterName + ".chapter.json" + " doesn't exists.");
        }
        this.w.getI18N().loadChapter("model/" + chapterName);
        this.w.getCustomProperties().put(World.WorldProperties.CURRENT_CHAPTER.toString(), chapterName);
        this.w.getCustomProperties().put(World.WorldProperties.PLATFORM.toString(), Gdx.app.getType().toString());
        EngineLogger.debug("MODEL LOADING TIME (ms): " + (System.currentTimeMillis() - initTime));
    }

    public void saveModel(String chapterId) throws IOException {
        EngineLogger.debug("SAVING GAME MODEL");
        if (this.w.isDisposed()) {
            return;
        }
        BladeJson json = new BladeJson(this.w, BladeJson.Mode.MODEL);
        json.setOutputType(JsonWriter.OutputType.javascript);
        String s = null;
        s = EngineLogger.debugMode() ? json.prettyPrint(this) : json.toJson(this);
        try (Writer w = EngineAssetManager.getInstance().getModelFile(chapterId + ".chapter.json").writer(false, "UTF-8");){
            w.write(s);
            w.flush();
        }
    }

    public void loadGameState(FileHandle savedFile) throws IOException {
        EngineLogger.debug("LOADING GAME STATE");
        if (!savedFile.exists()) {
            throw new IOException("LOADGAMESTATE: no saved game exists");
        }
        JsonValue root = new JsonReader().parse(savedFile.reader("UTF-8"));
        BladeJson json = new BladeJson(this.w, BladeJson.Mode.STATE);
        json.setIgnoreUnknownFields(true);
        this.read(json, root);
    }

    public void saveGameState(String filename, boolean screenshot) throws IOException {
        EngineLogger.debug("SAVING GAME STATE");
        if (this.w.isDisposed()) {
            return;
        }
        BladeJson json = new BladeJson(this.w, BladeJson.Mode.STATE);
        json.setOutputType(JsonWriter.OutputType.javascript);
        json.setSortFields(true);
        String s = null;
        s = EngineLogger.debugMode() ? json.prettyPrint(this) : json.toJson(this);
        try (Writer writer = EngineAssetManager.getInstance().getUserFile(filename).writer(false, "UTF-8");){
            writer.write(s);
            writer.flush();
        }
        if (screenshot) {
            this.w.takeScreenshot(filename + ".png", 300);
        }
    }

    public void write(Json json) {
        BladeJson bjson = (BladeJson)json;
        json.writeValue("bladeEngineVersion", (Object)Config.getInstance().getProperty("bladeEngineVersion", null));
        if (bjson.getMode() == BladeJson.Mode.MODEL) {
            TreeMap<String, SoundDesc> sortedSounds = new TreeMap<String, SoundDesc>();
            sortedSounds.putAll(this.w.getSounds());
            json.writeValue("sounds", sortedSounds, sortedSounds.getClass(), SoundDesc.class);
            TreeMap<String, Scene> sortedScenes = new TreeMap<String, Scene>();
            sortedScenes.putAll(this.w.getScenes());
            json.writeValue("scenes", sortedScenes, sortedScenes.getClass(), Scene.class);
            json.writeValue("initScene", (Object)this.w.getInitScene());
        } else {
            json.writeValue("version", (Object)Config.getInstance().getProperty("version", null));
            TreeMap<String, Scene> sortedScenes = new TreeMap<String, Scene>();
            sortedScenes.putAll(this.w.getScenes());
            json.writeValue("scenes", sortedScenes, sortedScenes.getClass(), Scene.class);
            json.writeValue("currentScene", (Object)this.w.getCurrentScene().getId());
            json.writeValue("inventories", this.w.getInventories());
            json.writeValue("currentInventory", (Object)this.w.getCurrentInventory());
            json.writeValue("timeOfGame", (Object)this.w.getTimeOfGame());
            json.writeValue("cutmode", (Object)this.w.inCutMode());
            this.w.getVerbManager().write(json);
            json.writeValue("customProperties", this.w.getCustomProperties(), this.w.getCustomProperties().getClass(), String.class);
            if (this.w.getCurrentDialog() != null) {
                json.writeValue("dialogActor", (Object)this.w.getCurrentDialog().getActor().getId());
                json.writeValue("currentDialog", (Object)this.w.getCurrentDialog().getId());
            }
            if (this.w.getTransition() != null) {
                json.writeValue("transition", (Object)this.w.getTransition());
            }
            json.writeValue("chapter", (Object)this.w.getCurrentChapter());
            json.writeValue("musicEngine", (Object)this.w.getMusicManager());
            if (!this.w.getUIActors().getActors().isEmpty()) {
                json.writeValue("uiActors", (Object)this.w.getUIActors());
            }
        }
        if (this.w.getInkManager() != null && this.w.getInkManager().getStoryName() != null) {
            json.writeValue("inkManager", (Object)this.w.getInkManager());
        }
    }

    public void read(Json json, JsonValue jsonData) {
        String bladeVersion = (String)json.readValue("bladeEngineVersion", String.class, jsonData);
        BladeJson bjson = (BladeJson)json;
        if (bjson.getMode() == BladeJson.Mode.MODEL) {
            if (bladeVersion != null && !bladeVersion.equals(Config.getInstance().getProperty("bladeEngineVersion", ""))) {
                EngineLogger.debug("Model Engine Version v" + bladeVersion + " differs from Current Engine Version v" + Config.getInstance().getProperty("bladeEngineVersion", ""));
            }
            JsonValue jsonSounds = jsonData.get("sounds");
            HashMap<String, SoundDesc> sounds = this.w.getSounds();
            if (jsonSounds != null) {
                for (int i = 0; i < jsonSounds.size; ++i) {
                    JsonValue jsonValue = jsonSounds.get(i);
                    SoundDesc s = (SoundDesc)json.readValue(SoundDesc.class, jsonValue);
                    sounds.put(jsonValue.name, s);
                }
            }
            JsonValue jsonScenes = jsonData.get("scenes");
            Map<String, Scene> scenes = this.w.getScenes();
            for (int i = 0; i < jsonScenes.size; ++i) {
                JsonValue jsonValue = jsonScenes.get(i);
                Scene s = new Scene(this.w);
                scenes.put(jsonValue.name, s);
                s.read(json, jsonValue);
            }
            this.w.setInitScene((String)json.readValue("initScene", String.class, jsonData));
            if (this.w.getInitScene() == null && this.w.getScenes().size() > 0) {
                this.w.setInitScene(this.w.getScenes().keySet().toArray(new String[0])[0]);
            }
            for (Scene s : this.w.getScenes().values()) {
                s.resetCamera(this.w.getWidth(), this.w.getHeight());
            }
            if (jsonData.get("inkManager") != null) {
                this.w.getInkManager().read(json, jsonData.get("inkManager"));
            }
            this.cacheSounds();
        } else {
            if (bladeVersion != null && !bladeVersion.equals(Config.getInstance().getProperty("bladeEngineVersion", ""))) {
                EngineLogger.debug("Saved Game Engine Version v" + bladeVersion + " differs from Current Engine Version v" + Config.getInstance().getProperty("bladeEngineVersion", ""));
            }
            String currentChapter = (String)json.readValue("chapter", String.class, jsonData);
            String currentScene = (String)json.readValue("currentScene", String.class, jsonData);
            try {
                this.loadChapter(currentChapter, currentScene, false);
            }
            catch (IOException e1) {
                EngineLogger.error("Error Loading Chapter");
                return;
            }
            if (jsonData.get("inkManager") != null) {
                this.w.getInkManager().read(json, jsonData.get("inkManager"));
            }
            this.w.setCurrentInventory((String)json.readValue("currentInventory", String.class, jsonData));
            JsonValue jsonInventories = jsonData.get("inventories");
            for (int i = 0; i < jsonInventories.size; ++i) {
                JsonValue jsonValue = jsonInventories.get(i);
                Inventory inv = new Inventory();
                this.w.getInventories().put(jsonValue.name, inv);
                inv.read(json, jsonValue);
            }
            if (jsonData.get("uiActors") != null) {
                this.w.getUIActors().read(json, jsonData.get("uiActors"));
            }
            for (Scene s : this.w.getScenes().values()) {
                JsonValue jsonValue = jsonData.get("scenes").get(s.getId());
                if (jsonValue != null) {
                    s.read(json, jsonValue);
                    continue;
                }
                EngineLogger.debug("LOAD WARNING: Scene not found in saved game: " + s.getId());
            }
            this.w.setTimeOfGame((Long)json.readValue("timeOfGame", Long.TYPE, (Object)0L, jsonData));
            this.w.setCutMode((Boolean)json.readValue("cutmode", Boolean.TYPE, (Object)false, jsonData));
            this.w.getVerbManager().read(json, jsonData);
            JsonValue jsonProperties = jsonData.get("customProperties");
            HashMap<String, String> props = this.w.getCustomProperties();
            for (int i = 0; i < jsonProperties.size; ++i) {
                JsonValue jsonValue = jsonProperties.get(i);
                props.put(jsonValue.name, jsonValue.asString());
            }
            String version = (String)json.readValue("version", String.class, jsonData);
            if (version == null) {
                version = "TEST";
            }
            props.put(World.WorldProperties.SAVED_GAME_VERSION.toString(), version);
            String actorId = (String)json.readValue("dialogActor", String.class, jsonData);
            String dialogId = (String)json.readValue("currentDialog", String.class, jsonData);
            if (dialogId != null) {
                CharacterActor actor = (CharacterActor)this.w.getCurrentScene().getActor(actorId, false);
                this.w.setCurrentDialog(actor.getDialog(dialogId));
            }
            this.w.getTransition().read(json, jsonData.get("transition"));
            this.w.getMusicManager().read(json, jsonData.get("musicEngine"));
            this.w.getI18N().loadChapter("model/" + this.w.getCurrentChapter());
        }
    }

    private void cacheSounds() {
        for (Scene s : this.w.getScenes().values()) {
            HashMap<String, Verb> verbs = s.getVerbManager().getVerbs();
            for (Verb v : verbs.values()) {
                ArrayList<Action> actions = v.getActions();
                for (int i = 0; i < actions.size(); ++i) {
                    Action act = actions.get(i);
                    try {
                        if (act instanceof SoundAction) {
                            String actor = ActionUtils.getStringValue(act, "actor");
                            String play = ActionUtils.getStringValue(act, "play");
                            if (play != null) {
                                SoundDesc sd;
                                if (actor.equals("$PLAYER")) {
                                    actor = s.getPlayer().getId();
                                }
                                if ((sd = this.w.getSounds().get(actor + "_" + play)) == null) {
                                    EngineLogger.error("Reference to sound not found: " + s.getId() + "." + actor + "." + play);
                                    continue;
                                }
                                s.getSoundManager().addSoundToLoad(sd);
                                HashMap<String, String> params = new HashMap<String, String>();
                                params.put("sound", sd.getId());
                                try {
                                    Action a2 = ActionFactory.create(PlaySoundAction.class.getName(), params);
                                    actions.set(i, a2);
                                    a2.init(this.w);
                                }
                                catch (ReflectionException | ClassNotFoundException e) {
                                    e.printStackTrace();
                                }
                                EngineLogger.debug("Converting SoundAction:" + s.getId() + "." + v.getId());
                                continue;
                            }
                            EngineLogger.debug("WARNING: Cannot convert SoundAction:" + s.getId() + "." + v.getId());
                            continue;
                        }
                        if (!(act instanceof PlaySoundAction)) continue;
                        String sound = ActionUtils.getStringValue(act, "sound");
                        SoundDesc sd = this.w.getSounds().get(sound);
                        if (sd == null || !sd.isPreload()) continue;
                        s.getSoundManager().addSoundToLoad(sd);
                        continue;
                    }
                    catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException sound) {
                        // empty catch block
                    }
                }
            }
            for (BaseActor a : s.getActors().values()) {
                if (a instanceof InteractiveActor) {
                    HashMap<String, Verb> actorVerbs = ((InteractiveActor)a).getVerbManager().getVerbs();
                    for (Verb v : actorVerbs.values()) {
                        ArrayList<Action> actions = v.getActions();
                        for (int i = 0; i < actions.size(); ++i) {
                            Action act = actions.get(i);
                            try {
                                if (act instanceof SoundAction) {
                                    String actor = ActionUtils.getStringValue(act, "actor");
                                    String play = ActionUtils.getStringValue(act, "play");
                                    if (play != null) {
                                        SoundDesc sd;
                                        if ("$PLAYER".equals(actor)) {
                                            actor = s.getPlayer().getId();
                                        }
                                        if ((sd = this.w.getSounds().get(actor + "_" + play)) == null) {
                                            EngineLogger.error("Reference to sound not found: " + s.getId() + "." + actor + "." + play);
                                            continue;
                                        }
                                        s.getSoundManager().addSoundToLoad(sd);
                                        HashMap<String, String> params = new HashMap<String, String>();
                                        params.put("sound", sd.getId());
                                        try {
                                            Action a2 = ActionFactory.create(PlaySoundAction.class.getName(), params);
                                            actions.set(i, a2);
                                            a2.init(this.w);
                                        }
                                        catch (ReflectionException | ClassNotFoundException e) {
                                            e.printStackTrace();
                                        }
                                        EngineLogger.debug("Converting SoundAction in:" + s.getId() + "." + a.getId() + "." + v.getId());
                                        continue;
                                    }
                                    EngineLogger.debug("WARNING: Cannot convert SoundAction:" + s.getId() + "." + a.getId() + "." + v.getId());
                                    continue;
                                }
                                if (!(act instanceof PlaySoundAction)) continue;
                                String sound = ActionUtils.getStringValue(act, "sound");
                                SoundDesc sd = this.w.getSounds().get(sound);
                                if (sd == null || !sd.isPreload()) continue;
                                s.getSoundManager().addSoundToLoad(sd);
                                continue;
                            }
                            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException exception) {
                                // empty catch block
                            }
                        }
                    }
                }
                if (!(a instanceof SpriteActor) || !(((SpriteActor)a).getRenderer() instanceof AnimationRenderer)) continue;
                HashMap<String, AnimationDesc> anims = ((AnimationRenderer)((SpriteActor)a).getRenderer()).getAnimations();
                for (AnimationDesc ad : anims.values()) {
                    if (ad.sound == null) continue;
                    String sid = ad.sound;
                    SoundDesc sd = this.w.getSounds().get(sid);
                    if (sd == null) {
                        sid = a.getId() + "_" + sid;
                    }
                    if ((sd = this.w.getSounds().get(sid)) != null) {
                        if (!sd.isPreload()) continue;
                        s.getSoundManager().addSoundToLoad(sd);
                        continue;
                    }
                    EngineLogger.error(a.getId() + ": SOUND not found: " + ad.sound + " in animation: " + ad.id);
                }
            }
        }
    }
}

