/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.ui;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGenerator;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.utils.BaseDrawable;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.SerializationException;
import com.badlogic.gdx.utils.reflect.ClassReflection;
import com.badlogic.gdx.utils.reflect.ReflectionException;
import com.bladecoder.engine.ui.AnimationDrawable;
import com.bladecoder.engine.util.DPIUtils;
import com.bladecoder.engine.util.EngineLogger;
import com.bladecoder.engine.util.FileUtils;
import com.bladecoder.engine.util.MultiFontBitmapFontData;
import java.util.ArrayList;
import java.util.List;

public class BladeSkin
extends Skin {
    private List<FreeTypeFontGenerator> fontGenerators;

    public BladeSkin(FileHandle skinFile) {
        super(skinFile);
    }

    public BladeSkin(FileHandle skinFile, TextureAtlas atlas) {
        super(skinFile, atlas);
    }

    public BladeSkin(TextureAtlas atlas) {
        super(atlas);
    }

    protected Json getJsonLoader(final FileHandle skinFile) {
        Json json = super.getJsonLoader(skinFile);
        final BladeSkin skin = this;
        json.setSerializer(Skin.class, (Json.Serializer)new Json.ReadOnlySerializer<Skin>(){

            public Skin read(Json json, JsonValue typeToValueMap, Class ignored) {
                JsonValue valueMap = typeToValueMap.child;
                while (valueMap != null) {
                    try {
                        Class type = json.getClass(valueMap.name());
                        if (type == null) {
                            type = ClassReflection.forName((String)valueMap.name());
                        }
                        this.readNamedObjects(json, type, valueMap);
                    }
                    catch (ReflectionException ex) {
                        throw new SerializationException((Throwable)ex);
                    }
                    valueMap = valueMap.next;
                }
                return skin;
            }

            private void readNamedObjects(Json json, Class<?> type, JsonValue valueMap) {
                Class addType = type == Skin.TintedDrawable.class ? Drawable.class : type;
                JsonValue valueEntry = valueMap.child;
                while (valueEntry != null) {
                    Object object = json.readValue(type, valueEntry);
                    if (object != null) {
                        try {
                            BladeSkin.this.add(valueEntry.name, object, addType);
                            if (addType != Drawable.class && ClassReflection.isAssignableFrom(Drawable.class, addType)) {
                                BladeSkin.this.add(valueEntry.name, object, Drawable.class);
                            }
                        }
                        catch (Exception ex) {
                            throw new SerializationException("Error reading " + ClassReflection.getSimpleName(type) + ": " + valueEntry.name, (Throwable)ex);
                        }
                    }
                    valueEntry = valueEntry.next;
                }
            }
        });
        json.setSerializer(BitmapFont.class, (Json.Serializer)new Json.ReadOnlySerializer<BitmapFont>(){

            public BitmapFont read(Json json, JsonValue jsonData, Class type) {
                BitmapFont font;
                String path = (String)json.readValue("file", String.class, jsonData);
                int scaledSize = (Integer)json.readValue("scaledSize", Integer.TYPE, (Object)-1, jsonData);
                Boolean flip = (Boolean)json.readValue("flip", Boolean.class, (Object)false, jsonData);
                int size = (Integer)json.readValue("size", Integer.TYPE, (Object)-1, jsonData);
                FileHandle fontFile = skinFile.parent().child(path);
                if (!FileUtils.exists(fontFile)) {
                    fontFile = Gdx.files.internal(path);
                }
                if (!FileUtils.exists(fontFile)) {
                    throw new SerializationException("Font file not found: " + fontFile);
                }
                if (fontFile.extension().equalsIgnoreCase("ttf")) {
                    ArrayList fallbacksFonts;
                    if (size == -1) {
                        throw new SerializationException("'size' mandatory parameter for .ttf fonts");
                    }
                    long initTime = System.currentTimeMillis();
                    FreeTypeFontGenerator generator = new FreeTypeFontGenerator(fontFile);
                    FreeTypeFontGenerator.FreeTypeFontParameter parameter = new FreeTypeFontGenerator.FreeTypeFontParameter();
                    parameter.size = (int)((float)DPIUtils.dpToPixels(size) * DPIUtils.getSizeMultiplier());
                    parameter.color = (Color)json.readValue("color", Color.class, (Object)Color.WHITE, jsonData);
                    parameter.incremental = (Boolean)json.readValue("incremental", Boolean.TYPE, (Object)true, jsonData);
                    parameter.borderWidth = ((Integer)json.readValue("borderWidth", Integer.TYPE, (Object)0, jsonData)).intValue();
                    parameter.borderColor = (Color)json.readValue("borderColor", Color.class, (Object)Color.BLACK, jsonData);
                    parameter.borderStraight = (Boolean)json.readValue("borderStraight", Boolean.TYPE, (Object)false, jsonData);
                    parameter.shadowOffsetX = (Integer)json.readValue("shadowOffsetX", Integer.TYPE, (Object)0, jsonData);
                    parameter.shadowOffsetY = (Integer)json.readValue("shadowOffsetY", Integer.TYPE, (Object)0, jsonData);
                    parameter.shadowColor = (Color)json.readValue("shadowColor", Color.class, (Object)Color.BLACK, jsonData);
                    if (parameter.incremental) {
                        parameter.characters = "";
                    }
                    if ((fallbacksFonts = (ArrayList)json.readValue("fallbacks", ArrayList.class, String.class, jsonData)) == null) {
                        font = generator.generateFont(parameter);
                    } else {
                        MultiFontBitmapFontData data = new MultiFontBitmapFontData();
                        data.createPacker(parameter);
                        font = generator.generateFont(parameter, (FreeTypeFontGenerator.FreeTypeBitmapFontData)data);
                        FreeTypeFontGenerator.FreeTypeFontParameter parameterFB = new FreeTypeFontGenerator.FreeTypeFontParameter();
                        parameterFB.size = parameter.size;
                        parameterFB.color = parameter.color;
                        parameterFB.incremental = true;
                        parameterFB.borderWidth = parameter.borderWidth;
                        parameterFB.borderColor = parameter.borderColor;
                        parameterFB.borderStraight = parameter.borderStraight;
                        parameterFB.shadowOffsetX = parameter.shadowOffsetX;
                        parameterFB.shadowOffsetY = parameter.shadowOffsetY;
                        parameterFB.shadowColor = parameter.shadowColor;
                        parameterFB.characters = "";
                        for (String filename : fallbacksFonts) {
                            FileHandle file = skinFile.parent().child(filename);
                            if (!FileUtils.exists(file)) {
                                file = Gdx.files.internal(path);
                            }
                            if (!FileUtils.exists(file)) {
                                throw new SerializationException("Font file not found: " + file);
                            }
                            data.addFallBackFont(file, parameterFB);
                        }
                    }
                    EngineLogger.debug(path + " TIME (ms): " + (System.currentTimeMillis() - initTime));
                    if (BladeSkin.this.fontGenerators == null) {
                        BladeSkin.this.fontGenerators = new ArrayList();
                    }
                    BladeSkin.this.fontGenerators.add(generator);
                } else {
                    String regionName = fontFile.nameWithoutExtension();
                    try {
                        FileHandle imageFile;
                        TextureRegion region = (TextureRegion)skin.optional(regionName, TextureRegion.class);
                        font = region != null ? new BitmapFont(fontFile, region, flip.booleanValue()) : (FileUtils.exists(imageFile = fontFile.parent().child(regionName + ".png")) ? new BitmapFont(fontFile, imageFile, flip.booleanValue()) : new BitmapFont(fontFile, flip.booleanValue()));
                        if (scaledSize != -1) {
                            font.getData().setScale((float)scaledSize / font.getCapHeight());
                        } else if (size != -1) {
                            font.getData().setScale((float)DPIUtils.dpToPixels(size) * DPIUtils.getSizeMultiplier() / font.getCapHeight());
                        }
                    }
                    catch (RuntimeException ex) {
                        throw new SerializationException("Error loading bitmap font: " + fontFile, (Throwable)ex);
                    }
                }
                font.getData().markupEnabled = true;
                return font;
            }
        });
        json.setSerializer(AnimationDrawable.class, (Json.Serializer)new Json.ReadOnlySerializer<AnimationDrawable>(){

            public AnimationDrawable read(Json json, JsonValue jsonData, Class type) {
                String name = (String)json.readValue("name", String.class, jsonData);
                float duration = ((Float)json.readValue("duration", Float.class, (Object)Float.valueOf(1.0f), jsonData)).floatValue();
                Animation.PlayMode playMode = (Animation.PlayMode)json.readValue("play_mode", Animation.PlayMode.class, (Object)Animation.PlayMode.LOOP, jsonData);
                Array regions = BladeSkin.this.getAtlas().findRegions(name);
                if (regions.size == 0) {
                    throw new SerializationException("AnimationDrawable not found: " + name);
                }
                Animation a = new Animation(duration / (float)regions.size, regions, playMode);
                AnimationDrawable drawable = new AnimationDrawable((Animation<TextureAtlas.AtlasRegion>)a);
                if (drawable instanceof BaseDrawable) {
                    AnimationDrawable named = drawable;
                    named.setName(jsonData.name + " (" + name + ", " + duration + ")");
                }
                return drawable;
            }
        });
        json.addClassTag("AnimationDrawable", AnimationDrawable.class);
        return json;
    }

    public void addStyleTag(Class<?> tag) {
        this.getJsonClassTags().put((Object)tag.getSimpleName(), tag);
    }

    public Drawable newDrawable(Drawable drawable) {
        if (drawable instanceof AnimationDrawable) {
            return new AnimationDrawable((AnimationDrawable)drawable);
        }
        return super.newDrawable(drawable);
    }

    public Drawable newDrawable(Drawable drawable, Color tint) {
        if (drawable instanceof AnimationDrawable) {
            Drawable newDrawable = ((AnimationDrawable)drawable).tint(tint);
            ((BaseDrawable)newDrawable).setName(((BaseDrawable)drawable).getName() + " (" + tint + ")");
            return newDrawable;
        }
        return super.newDrawable(drawable, tint);
    }

    public void dispose() {
        super.dispose();
        if (this.fontGenerators == null) {
            return;
        }
        for (FreeTypeFontGenerator generator : this.fontGenerators) {
            generator.dispose();
        }
        this.fontGenerators.clear();
    }
}

