/*
 * Decompiled with CFR 0.152.
 */
package com.bladecoder.engine.ui;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputAdapter;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.ScreenAdapter;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.controllers.Controller;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.viewport.ScreenViewport;
import com.badlogic.gdx.utils.viewport.Viewport;
import com.bladecoder.engine.assets.EngineAssetManager;
import com.bladecoder.engine.ui.BladeScreen;
import com.bladecoder.engine.ui.UI;
import com.bladecoder.engine.ui.defaults.ScreenControllerHandler;
import com.bladecoder.engine.util.DPIUtils;
import com.bladecoder.engine.util.EngineLogger;
import java.io.BufferedReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class CreditsScreen
extends ScreenAdapter
implements BladeScreen {
    private static final String CREDITS_FILENAME = "ui/credits";
    private static final float SPEED = 10.0f * DPIUtils.getSpacing();
    private final List<String> credits = new ArrayList<String>();
    private CreditScreenStyle style;
    private int stringHead = 0;
    private float scrollY = 0.0f;
    private UI ui;
    private Music music;
    private final Map<String, Texture> images = new HashMap<String, Texture>();
    private Viewport viewport;
    private final GlyphLayout layout = new GlyphLayout();
    private ScreenControllerHandler controller;
    private final InputProcessor inputProcessor = new InputAdapter(){

        public boolean keyUp(int keycode) {
            if (keycode == 111 || keycode == 4) {
                CreditsScreen.this.ui.setCurrentScreen(UI.Screens.MENU_SCREEN);
            }
            return true;
        }

        public boolean touchUp(int screenX, int screenY, int pointer, int button) {
            CreditsScreen.this.ui.setCurrentScreen(UI.Screens.MENU_SCREEN);
            return true;
        }
    };

    public void render(float delta) {
        SpriteBatch batch = this.ui.getBatch();
        int width = (int)this.viewport.getWorldWidth();
        int height = (int)this.viewport.getWorldHeight();
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        batch.setProjectionMatrix(this.viewport.getCamera().combined);
        batch.begin();
        if (this.style.background != null) {
            this.style.background.draw((Batch)batch, 0.0f, 0.0f, (float)width, (float)height);
        }
        this.scrollY += delta * SPEED * EngineAssetManager.getInstance().getScale();
        float y = this.scrollY;
        if (this.stringHead >= this.credits.size()) {
            this.ui.setCurrentScreen(UI.Screens.MENU_SCREEN);
        }
        for (int i = this.stringHead; i < this.credits.size(); ++i) {
            String s = this.credits.get(i);
            int type = 99;
            if (s.indexOf(35) != -1) {
                type = s.charAt(0);
                s = s.substring(2);
            }
            switch (type) {
                case 116: {
                    y = this.processCreditTitle(batch, width, height, y, i, s);
                    break;
                }
                case 105: {
                    y = this.processCreditImage(batch, width, height, y, i, s);
                    break;
                }
                case 115: {
                    y = this.processCreditSpace(height, y, i, s);
                    break;
                }
                case 109: {
                    this.processCreditMusic(s);
                    this.credits.remove(i);
                    --i;
                    break;
                }
                default: {
                    y = this.processCreditDefault(batch, width, height, y, i, s);
                }
            }
            if (y < 0.0f) break;
        }
        batch.end();
        this.controller.update(delta);
    }

    private float processCreditTitle(SpriteBatch batch, int width, int height, float y, int i, String s) {
        float lineHeight = this.style.titleFont.getLineHeight();
        this.drawCenteredScreenX(batch, this.style.titleFont, s, y -= lineHeight * 2.0f, width);
        y -= lineHeight;
        if (y > (float)height + lineHeight) {
            this.stringHead = i + 1;
            this.scrollY -= lineHeight;
            this.scrollY -= lineHeight * 2.0f;
        }
        return y;
    }

    private float processCreditImage(SpriteBatch batch, int width, int height, float y, int i, String s) {
        Texture img = this.images.get(s);
        int lineHeight = img.getHeight();
        batch.draw(img, (float)((width - img.getWidth()) / 2), y - (float)lineHeight);
        y -= (float)lineHeight;
        if (y > (float)height) {
            this.stringHead = i + 1;
            this.scrollY -= (float)lineHeight;
        }
        return y;
    }

    private float processCreditSpace(int height, float y, int i, String s) {
        int lineHeight = (int)((float)Integer.valueOf(s).intValue() * EngineAssetManager.getInstance().getScale());
        if ((y -= (float)lineHeight) > (float)height) {
            this.stringHead = i + 1;
            this.scrollY -= (float)lineHeight;
        }
        return y;
    }

    private void processCreditMusic(String s) {
        if (this.music != null) {
            this.music.dispose();
        }
        final String file = EngineAssetManager.getInstance().checkIOSSoundName("music/" + s);
        new Thread(){

            @Override
            public void run() {
                CreditsScreen.this.music = Gdx.audio.newMusic(EngineAssetManager.getInstance().getAsset(file));
                try {
                    CreditsScreen.this.music.play();
                    CreditsScreen.this.music.setVolume(0.5f);
                }
                catch (Exception e) {
                    if (Gdx.app.getType() == Application.ApplicationType.Desktop && e.getMessage().contains("40963")) {
                        EngineLogger.debug("!!!!!!!!!!!!!!!!!!!!!!!ERROR playing music trying again...!!!!!!!!!!!!!!!");
                        CreditsScreen.this.music = Gdx.audio.newMusic(EngineAssetManager.getInstance().getAsset(file));
                        CreditsScreen.this.music.play();
                        CreditsScreen.this.music.setVolume(0.5f);
                        return;
                    }
                    EngineLogger.error("Error Playing music: " + file);
                }
            }
        }.start();
    }

    private float processCreditDefault(SpriteBatch batch, int width, int height, float y, int i, String s) {
        this.drawCenteredScreenX(batch, this.style.font, s, y, width);
        float lineHeight = this.style.font.getLineHeight();
        y -= lineHeight;
        if (y > (float)height + lineHeight) {
            this.stringHead = i + 1;
            this.scrollY -= lineHeight;
        }
        return y;
    }

    public void resize(int width, int height) {
        this.viewport.update(width, height, true);
    }

    public void dispose() {
        for (Texture t : this.images.values()) {
            t.dispose();
        }
        this.images.clear();
        this.credits.clear();
        if (this.music != null) {
            this.music.stop();
            this.music.dispose();
            this.music = null;
        }
    }

    private void retrieveAssets() {
        this.style = (CreditScreenStyle)this.ui.getSkin().get(CreditScreenStyle.class);
        Locale locale = Locale.getDefault();
        String localeFilename = MessageFormat.format("{0}_{1}.txt", CREDITS_FILENAME, locale.getLanguage());
        if (!EngineAssetManager.getInstance().assetExists(localeFilename)) {
            localeFilename = MessageFormat.format("{0}.txt", CREDITS_FILENAME);
        }
        BufferedReader reader = EngineAssetManager.getInstance().getAsset(localeFilename).reader(4096, "utf-8");
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                this.credits.add(line);
            }
        }
        catch (Exception e) {
            EngineLogger.error(e.getMessage());
            this.ui.setCurrentScreen(UI.Screens.MENU_SCREEN);
        }
        this.scrollY += this.style.titleFont.getLineHeight();
        for (String s : this.credits) {
            if (s.indexOf(35) == -1 || s.charAt(0) != 'i') continue;
            s = s.substring(2);
            Texture tex = new Texture(EngineAssetManager.getInstance().getResAsset("ui/" + s));
            tex.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
            this.images.put(s, tex);
        }
    }

    public void show() {
        this.retrieveAssets();
        Gdx.input.setInputProcessor(this.inputProcessor);
        this.viewport = new ScreenViewport();
        this.stringHead = 0;
        this.scrollY = 0.0f;
        this.controller = new ScreenControllerHandler(this.ui, null, this.viewport){

            @Override
            protected boolean buttonUp(Controller controller, int buttonCode) {
                CreditsScreen.this.ui.setCurrentScreen(UI.Screens.MENU_SCREEN);
                return true;
            }
        };
    }

    public void hide() {
        this.dispose();
    }

    @Override
    public void setUI(UI ui) {
        this.ui = ui;
    }

    public void drawCenteredScreenX(SpriteBatch batch, BitmapFont font, CharSequence str, float y, int viewportWidth) {
        float x = 0.0f;
        this.layout.setText(font, str, Color.WHITE, (float)viewportWidth, 1, true);
        font.draw((Batch)batch, this.layout, x, y);
    }

    public static class CreditScreenStyle {
        public Drawable background;
        public String bgFile;
        public BitmapFont titleFont;
        public BitmapFont font;

        public CreditScreenStyle() {
        }

        public CreditScreenStyle(CreditScreenStyle style) {
            this.background = style.background;
            this.bgFile = style.bgFile;
            this.titleFont = style.titleFont;
            this.font = style.font;
        }
    }
}

